/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.domain.installation.impl;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.domain.PostSetInstallation;
import gui.installation.VariableNameConflictAction;
import gui.installation.naming.NameClashResolverService;
import gui.polyscope.DashBoard;
import gui.program.ProgramRootNode;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ResolveNameOnInstallationOrProgramLoad
implements PostSetInstallation {
    private static ResolveNameOnInstallationOrProgramLoad instance;
    private NameClashResolverService nameClashResolverService;

    @Inject
    public ResolveNameOnInstallationOrProgramLoad(NameClashResolverService nameClashResolverService) {
        this.nameClashResolverService = nameClashResolverService;
        instance = this;
    }

    public static void postLoadProgram(ProgramRootNode program, boolean withUserVariableNameClashResolution) {
        VariableNameConflictAction variableNameConflictAction = withUserVariableNameClashResolution ? VariableNameConflictAction.REQUEST_USER_INPUT : VariableNameConflictAction.USE_INSTALLATION_VARIABLES;
        instance.resolveNameClashingAndReferencesOfInstallationVariables(program, variableNameConflictAction);
    }

    public void postLoad(Installation newInstallation) {
        this.resolveNameClashingAndReferencesOfInstallationVariables(DashBoard.getProgram(), VariableNameConflictAction.REQUEST_USER_INPUT);
    }

    public void resolveNameClashingAndReferencesOfInstallationVariables(ProgramRootNode program, VariableNameConflictAction variableNameConflictAction) {
        this.nameClashResolverService.resolveNameClash(program, variableNameConflictAction);
    }
}

