/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.domain.program.expression;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.expression.ExpressionLeafNode;
import gui.program.services.geom.GeomFeatureReference;
import java.util.Collection;

public class ExpressionGeomFeatureNode
extends ExpressionLeafNode {
    private static final String FEATURE_EXPRESSION_POSTFIX = "_const";
    private GeomFeatureReference featureReference = null;

    public void initialSetFeatureReference(GeomFeatureReference reference) {
        this.featureReference = reference;
    }

    private GeomFeature getGeomFeature() {
        return this.getReference().dereference();
    }

    public GeomFeatureReference getReference() {
        return this.featureReference;
    }

    public ExpressionGeomFeatureNode clone() {
        ExpressionGeomFeatureNode clone = new ExpressionGeomFeatureNode();
        clone.featureReference = this.featureReference;
        return clone;
    }

    public void generateText(StringBuffer s) {
        if (this.getGeomFeature() != null) {
            s.append(ExpressionGeomFeatureNode.getGeomFeatureExpressionName(this.getGeomFeature()));
        } else {
            s.append(this.toString());
        }
    }

    public String generateScriptCode() {
        if (this.getGeomFeature() != null) {
            return this.getGeomFeature().getScriptCode();
        }
        return this.toString();
    }

    public int getLength() {
        if (this.getGeomFeature() != null) {
            return ExpressionGeomFeatureNode.getGeomFeatureExpressionName(this.getGeomFeature()).length();
        }
        return this.toString().length();
    }

    public static String getGeomFeatureExpressionName(GeomFeature geomFeature) {
        return String.valueOf(geomFeature.toString()) + FEATURE_EXPRESSION_POSTFIX;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public void getProgramEntities(Collection<Object> collection) {
        collection.add((Object)this.featureReference);
    }

    public boolean substituteReference(Object original, Object substitute) {
        boolean result = false;
        if (this.featureReference == original && substitute instanceof GeomFeatureReference) {
            this.featureReference = (GeomFeatureReference)((Object)substitute);
            result = true;
        }
        return result;
    }

    public boolean isUndefined() {
        return this.getGeomFeature() == null;
    }

    public boolean equals(Object o) {
        if (o instanceof ExpressionGeomFeatureNode) {
            ExpressionGeomFeatureNode other = (ExpressionGeomFeatureNode)((Object)o);
            return EqualsUtil.equals((Object)((Object)this.featureReference), (Object)((Object)other.featureReference));
        }
        return false;
    }

    public int hashCode() {
        return this.featureReference == null ? 0 : this.featureReference.hashCode();
    }
}

