/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.domain.program.expression;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.ResolvablePin;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.expression.ExpressionLeafNode;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import java.util.Collection;

public class ExpressionIONode
extends ExpressionLeafNode {
    private PinReference reference;

    public ExpressionIONode(PinReference pinReference) {
        this.reference = pinReference;
    }

    public PinReference getPinReference() {
        return this.reference;
    }

    public void generateText(StringBuffer s) {
        Pin<?> pin = this.getPin();
        s.append(pin == null ? this.reference.getKey() : pin.toString());
    }

    private ErrorMessage undefinedExpression(String expressionText) {
        TextResource textBundle = LanguagePack.getTextResource();
        return new ErrorMessage(textBundle.undefinedexpressionTitle(), textBundle.undefinedexpressionMessage(expressionText), textBundle.undefinedexpressionSuggestion());
    }

    public String generateScriptCode() {
        if (this.isUndefined()) {
            LegacyURDialogCreator.showErrorDialog(this.undefinedExpression(this.reference.toString()));
            return this.reference.toString();
        }
        try {
            return this.getPin().generateGetterScriptCode();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Unable to process ExpressionIO-node");
        }
    }

    public int getLength() {
        return this.toString().length();
    }

    public boolean isUndefined() {
        return this.reference.isUndefined() || this.isAnalogUndefined() || this.isPinUnresolvable();
    }

    private boolean isAnalogUndefined() {
        Pin<?> analogInput = this.getPin();
        return analogInput instanceof AnalogIOPin && ((AnalogIOPin)analogInput).isAssignedForToolComm();
    }

    private boolean isPinUnresolvable() {
        Pin<?> pin = this.getPin();
        if (pin instanceof ResolvablePin) {
            return !((ResolvablePin)pin).isResolvable();
        }
        return false;
    }

    public void getProgramEntities(Collection<Object> collection) {
        collection.add(this.reference);
    }

    public boolean substituteReference(Object original, Object substitute) {
        boolean result = false;
        if (this.reference == original && substitute instanceof PinReference) {
            this.reference = (PinReference)substitute;
            result = true;
        }
        return result;
    }

    public ExpressionIONode clone() {
        return new ExpressionIONode(this.reference);
    }

    public boolean equals(Object o) {
        if (o instanceof ExpressionIONode) {
            ExpressionIONode other = (ExpressionIONode)((Object)o);
            return EqualsUtil.equals((Object)this.reference, (Object)other.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.reference == null ? 0 : this.reference.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.generateText(buffer);
        return buffer.toString();
    }

    private Pin<?> getPin() {
        return this.reference.dereference();
    }
}

