/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.domain.program.expression;

import com.ur.swing.expression.ExpressionLeafNode;
import com.ur.util.event.EventNotificationService;
import gui.polyscope.program.ProgramTreeChangeObserver;
import gui.program.position.WaypointNode;
import java.lang.ref.WeakReference;
import java.util.Collection;

public class ExpressionWaypointNode
extends ExpressionLeafNode {
    private WaypointNode waypointNode;

    public ExpressionWaypointNode(WaypointNode waypointNode) {
        this.waypointNode = waypointNode;
        EventNotificationService.register((Object)((Object)this), ProgramTreeChangeObserver.class, (Object)new ChangeEventListener(this));
    }

    public ExpressionWaypointNode clone() {
        ExpressionWaypointNode clone = new ExpressionWaypointNode(this.waypointNode);
        return clone;
    }

    public void generateText(StringBuffer s) {
        s.append(this.waypointNode.getName());
    }

    public WaypointNode getWaypointNode() {
        return this.waypointNode;
    }

    public String generateScriptCode() {
        return this.waypointNode.generatePoseScriptCode();
    }

    public int getLength() {
        return this.waypointNode.getName().length();
    }

    public String toString() {
        return "ExpWaypointNode:'" + (this.waypointNode != null ? this.waypointNode.getName() : "(null)") + "'";
    }

    public void getProgramEntities(Collection<Object> collection) {
        collection.add(this.waypointNode);
    }

    public boolean substituteReference(Object original, Object substitute) {
        boolean result = false;
        if (this.waypointNode == original && substitute instanceof WaypointNode) {
            this.waypointNode = (WaypointNode)substitute;
            result = true;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof ExpressionWaypointNode) {
            ExpressionWaypointNode other = (ExpressionWaypointNode)((Object)o);
            return this.waypointNode == null ? other.waypointNode == null : this.waypointNode.equivalentTo(other.waypointNode);
        }
        return false;
    }

    public int hashCode() {
        return this.waypointNode == null ? 0 : this.waypointNode.hashCode();
    }

    public boolean isUndefined() {
        return this.waypointNode == null || this.waypointNode.isInvalidWaypoint() || super.isUndefined();
    }

    static class ChangeEventListener
    implements ProgramTreeChangeObserver {
        WeakReference<ExpressionWaypointNode> owner;

        ChangeEventListener(ExpressionWaypointNode owner) {
            this.owner = new WeakReference<ExpressionWaypointNode>(owner);
        }

        @Override
        public void handleProgramTreeEvent(ProgramTreeChangeObserver.ProgramTreeEvent event) {
            WaypointNode wp;
            ExpressionWaypointNode owner = (ExpressionWaypointNode)((Object)this.owner.get());
            if (owner != null && owner.waypointNode != null && event.node instanceof WaypointNode && event.type == ProgramTreeChangeObserver.Type.NODE_INSERTED && (wp = (WaypointNode)event.node).getName().equals(owner.waypointNode.getName())) {
                owner.waypointNode = wp;
            }
        }
    }
}

