/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.domain.program.services.impl;

import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.cache.DefinedCache;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.EditProgramService;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.reference.ReferenceOwner;
import com.ur.util.logging.Log;
import com.ur.view.action.programnode.ProgramTreeClipboard;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure1;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure11;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure13;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure15;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure17;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure19;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure3;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure5;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure7;
import com.ur.view.domain.program.services.impl.EditProgramServiceImpl$AjcClosure9;
import com.ur.view.domain.program.services.impl.UpdateInternalVariables;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.installation.naming.VariableNameClashResolver;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.program.InsertNodeStrategy;
import gui.polyscope.program.RemoveNodeStrategy;
import gui.program.EntityFactory;
import gui.program.IfNode;
import gui.program.InitVariablesNode;
import gui.program.MainProgram;
import gui.program.PlaceholderNode;
import gui.program.ProgramRootNode;
import gui.program.SuppressedNode;
import gui.program.services.ProgramReferenceService;
import gui.program.switchnode.SwitchNode;
import gui.tools.LegacyURDialogCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class EditProgramServiceImpl
implements EditProgramService {
    private final EntityFactory entityFactory;
    private final ProgramTreeClipboard programTreeClipboard;
    private final ProgramLookupService lookupService;
    private final RemoveNodeStrategy removeNodeStrategy;
    private final InsertNodeStrategy.BeforePlacementStrategy beforePlacementStrategy;
    private final InsertNodeStrategy.AfterPlacementStrategy afterPlacementStrategy;
    private final InsertNodeStrategy.MoveBeforeInsertStrategy replaceInsertStrategy;
    private final InsertNodeStrategy.MoveBeforeInsertStrategy moveBeforeStrategy;
    private final InsertNodeStrategy.MoveAfterInsertStrategy moveAfterStrategy;
    private final NamingService namingService;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private final VariableNameClashResolver variableNameClassResolver;
    private final ProgramReferenceService programReferenceService;
    private final DefinedCache programNodeDefinedCache;
    private final TextResource textResource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    @Inject
    public EditProgramServiceImpl(ProgramLookupService lookupService, NamingService namingService, EntityFactory entityFactory, ProgramTreeClipboard programTreeClipboard, InsertNodeStrategy.BeforePlacementStrategy beforePlacementStrategy, InsertNodeStrategy.AfterPlacementStrategy afterPlacementStrategy, InsertNodeStrategy.MoveBeforeInsertStrategy moveBeforeStrategy, InsertNodeStrategy.MoveAfterInsertStrategy moveAfterStrategy, RemoveNodeStrategy removeNodeStrategy, ControlProgramTreeStructure controlProgramTreeStructure, VariableNameClashResolver variableNameClashResolver, ProgramReferenceService programReferenceService, DefinedCache programNodeDefinedCache, TextResource textResource) {
        this.lookupService = lookupService;
        this.namingService = namingService;
        this.entityFactory = entityFactory;
        this.programTreeClipboard = programTreeClipboard;
        this.beforePlacementStrategy = beforePlacementStrategy;
        this.afterPlacementStrategy = afterPlacementStrategy;
        this.replaceInsertStrategy = moveBeforeStrategy;
        this.moveBeforeStrategy = moveBeforeStrategy;
        this.moveAfterStrategy = moveAfterStrategy;
        this.removeNodeStrategy = removeNodeStrategy;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.variableNameClassResolver = variableNameClashResolver;
        this.programReferenceService = programReferenceService;
        this.programNodeDefinedCache = programNodeDefinedCache;
        this.textResource = textResource;
    }

    @CompoundProgramChange
    public void moveNodeUp(AbstractProgramNode toBeMovedNode) {
        AbstractProgramNode abstractProgramNode = toBeMovedNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure1 editProgramServiceImpl$AjcClosure1 = new EditProgramServiceImpl$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public void moveNodeDown(AbstractProgramNode toBeMovedNode) {
        AbstractProgramNode abstractProgramNode = toBeMovedNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure3 editProgramServiceImpl$AjcClosure3 = new EditProgramServiceImpl$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private void moveSelectedNode(AbstractProgramNode toBeMovedNode, Direction moveDirection) {
        if (toBeMovedNode instanceof IfNode) {
            toBeMovedNode = ((IfNode)toBeMovedNode).getMasterIfNode();
        }
        if (toBeMovedNode.getParent() instanceof SwitchNode) {
            return;
        }
        AbstractProgramNode parentNode = (AbstractProgramNode)toBeMovedNode.getParent();
        int currentIndex = parentNode.getIndex((TreeNode)toBeMovedNode);
        int index = moveDirection == Direction.UP ? currentIndex - 1 : currentIndex + 1;
        ArrayList<AbstractProgramNode> toBeMoved = new ArrayList<AbstractProgramNode>();
        toBeMoved.add(toBeMovedNode);
        if (toBeMovedNode instanceof IfNode) {
            List<AbstractProgramNode> elseIfsAndElse = ((IfNode)toBeMovedNode).calculateElseIfsAndElse();
            toBeMoved.addAll(elseIfsAndElse);
            if (moveDirection == Direction.DOWN) {
                index += elseIfsAndElse.size();
            }
        }
        try {
            this.programNodeDefinedCache.enable();
            if (index >= 0 && index < parentNode.getChildCount()) {
                AbstractProgramNode pivot = (AbstractProgramNode)parentNode.getChildAt(index);
                this.putNodes(toBeMoved, pivot, moveDirection == Direction.DOWN ? this.moveAfterStrategy : this.moveBeforeStrategy);
            }
        }
        finally {
            this.programNodeDefinedCache.disable();
        }
        toBeMovedNode.setSelected();
    }

    private void putNodes(List<AbstractProgramNode> nodes, AbstractProgramNode pivot, InsertNodeStrategy initialStrategy) {
        int i = 0;
        while (i < nodes.size()) {
            AbstractProgramNode each = nodes.get(i);
            InsertNodeStrategy strategy = i == 0 ? initialStrategy : this.moveAfterStrategy;
            strategy.insert(each, pivot);
            pivot = each;
            ++i;
        }
    }

    @CompoundProgramChange
    public Collection<AbstractProgramNode> deleteNode(AbstractProgramNode toDelete) {
        AbstractProgramNode abstractProgramNode = toDelete;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure5 editProgramServiceImpl$AjcClosure5 = new EditProgramServiceImpl$AjcClosure5(objectArray);
        return (Collection)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    private Collection<AbstractProgramNode> doDeleteNode(AbstractProgramNode nodeToDelete) {
        if (!this.isDeletable(nodeToDelete)) {
            return null;
        }
        this.selectPreviousNode(nodeToDelete);
        List<AbstractProgramNode> dependentNodes = this.getAllDependentNodes(nodeToDelete);
        this.deleteAll(dependentNodes);
        return dependentNodes;
    }

    private void deleteAll(Collection<AbstractProgramNode> nodesToDelete) {
        for (AbstractProgramNode each : nodesToDelete) {
            this.removeNodeStrategy.removeNode(each);
        }
    }

    private boolean isDeletable(AbstractProgramNode programNode) {
        if (programNode == null || programNode.getParent() == null) {
            Log.error((String)"Node given was either null or parent was null");
            return false;
        }
        List<AbstractProgramNode> dependentNodes = this.getAllDependentNodes(programNode);
        for (AbstractProgramNode each : dependentNodes) {
            if (this.removeNodeStrategy.isRemovable(each)) continue;
            String errorMessage = this.removeNodeStrategy.getErrorMessage(each);
            if (!StringUtils.isNullOrEmpty((String)errorMessage)) {
                LegacyURDialogCreator.showMessageDialog(errorMessage);
            }
            return false;
        }
        return true;
    }

    private void selectPreviousNode(AbstractProgramNode node) {
        AbstractProgramNode previousNode = (AbstractProgramNode)node.getPreviousSibling();
        if (previousNode == null) {
            previousNode = (AbstractProgramNode)node.getPreviousNode();
        }
        if (previousNode == null || previousNode == this.lookupService.getProgramRootNode()) {
            Log.warning((String)"Node given does not have a previous node");
            previousNode = (AbstractProgramNode)this.lookupService.getProgramRootNode().getFirstChild();
        }
        this.lookupService.setSelectedNode(previousNode);
        this.controlProgramTreeStructure.makeVisible((TreeNode)previousNode);
    }

    public void setSelected(AbstractProgramNode nodeToSelect) {
        this.lookupService.setSelectedNode(nodeToSelect);
    }

    public AbstractProgramNode getSelected() {
        return this.lookupService.getSelectedNode();
    }

    private List<AbstractProgramNode> getAllDependentNodes(AbstractProgramNode programNode) {
        ArrayList<AbstractProgramNode> result = new ArrayList<AbstractProgramNode>();
        result.add(programNode);
        if (this.isStartingIfNode(programNode)) {
            IfNode ifNode = (IfNode)programNode;
            TreeNode programNodesParent = programNode.getParent();
            int i = programNodesParent.getIndex((TreeNode)((Object)ifNode)) + 1;
            while (i < ifNode.getSiblingCount()) {
                AbstractProgramNode nextSibling = (AbstractProgramNode)programNodesParent.getChildAt(i);
                if (this.isDependentIfNode(nextSibling)) {
                    result.add(nextSibling);
                } else {
                    if (!(nextSibling instanceof SuppressedNode) || !this.isDependentIfNode(((SuppressedNode)nextSibling).getSuppressedNode())) break;
                    result.add(nextSibling);
                }
                ++i;
            }
        }
        return result;
    }

    @CompoundProgramChange
    public boolean insertNodeAfter(AbstractProgramNode newNodeToInsert, AbstractProgramNode afterThisNode) {
        AbstractProgramNode abstractProgramNode = newNodeToInsert;
        AbstractProgramNode abstractProgramNode2 = afterThisNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)abstractProgramNode, (Object)abstractProgramNode2);
        Object[] objectArray = new Object[]{this, abstractProgramNode, abstractProgramNode2, joinPoint};
        EditProgramServiceImpl$AjcClosure7 editProgramServiceImpl$AjcClosure7 = new EditProgramServiceImpl$AjcClosure7(objectArray);
        return Conversions.booleanValue((Object)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    @CompoundProgramChange
    public boolean insertNodeBefore(AbstractProgramNode newNodeToInsert, AbstractProgramNode beforeThisNode) {
        AbstractProgramNode abstractProgramNode = newNodeToInsert;
        AbstractProgramNode abstractProgramNode2 = beforeThisNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)abstractProgramNode, (Object)abstractProgramNode2);
        Object[] objectArray = new Object[]{this, abstractProgramNode, abstractProgramNode2, joinPoint};
        EditProgramServiceImpl$AjcClosure9 editProgramServiceImpl$AjcClosure9 = new EditProgramServiceImpl$AjcClosure9(objectArray);
        return Conversions.booleanValue((Object)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648)));
    }

    private boolean insertNewNode(AbstractProgramNode newNodeToInsert, AbstractProgramNode beforeOrAfterThisNode, InsertNodeStrategy insertNodeStrategy) {
        try {
            this.programNodeDefinedCache.enable();
            boolean isInserted = this.insertNode(newNodeToInsert, beforeOrAfterThisNode, insertNodeStrategy);
            if (!isInserted) {
                this.cleanUp(newNodeToInsert);
            }
            boolean bl = isInserted;
            return bl;
        }
        finally {
            this.programNodeDefinedCache.disable();
        }
    }

    private void cleanUp(AbstractProgramNode programNode) {
        NamedEntityCollection programEntities = (NamedEntityCollection)programNode.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection());
        this.namingService.deregisterNamedEntities(programEntities);
        if (!programNode.isUnregisterProgramReferencesOnDelete()) {
            return;
        }
        Enumeration descendants = programNode.preorderEnumeration();
        while (descendants.hasMoreElements()) {
            Object node = descendants.nextElement();
            if (!(node instanceof ReferenceOwner)) continue;
            this.programReferenceService.setOwnedReferences((ReferenceOwner)node, Collections.emptyList());
        }
    }

    private boolean insertNode(AbstractProgramNode newNodeToInsert, AbstractProgramNode beforeOrAfterThisNode, InsertNodeStrategy insertNodeStrategy) {
        boolean isInserted;
        ProgramRootNode.setProgramRoot(this.lookupService.getProgramRootNode(), newNodeToInsert);
        try {
            isInserted = insertNodeStrategy.insert(newNodeToInsert, beforeOrAfterThisNode);
        }
        catch (RuntimeException runtimeException) {
            isInserted = false;
        }
        return isInserted;
    }

    private boolean isDependentIfNode(AbstractProgramNode nextSibling) {
        return nextSibling instanceof IfNode && !this.isStartingIfNode(nextSibling);
    }

    private boolean isStartingIfNode(AbstractProgramNode programNode) {
        return programNode instanceof IfNode && ((IfNode)programNode).getType() == IfNode.Type.IF;
    }

    private AbstractProgramNode unsuppressAll(AbstractProgramNode nodeToUnsuppress) {
        if (nodeToUnsuppress == null) {
            return null;
        }
        AbstractProgramNode unSuppressedNode = nodeToUnsuppress;
        if (nodeToUnsuppress instanceof SuppressedNode) {
            List<AbstractProgramNode> unsuppressedNodes = this.unsuppressNode(nodeToUnsuppress);
            unSuppressedNode = this.replaceNode(nodeToUnsuppress, unsuppressedNodes);
            for (AbstractProgramNode node : unsuppressedNodes) {
                this.unsuppressChildren(node);
            }
        } else {
            this.unsuppressChildren(nodeToUnsuppress);
        }
        return unSuppressedNode;
    }

    private void unsuppressChildren(AbstractProgramNode node) {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            int i = 0;
            while (i < childCount) {
                TreeNode treeNode = node.getChildAt(i);
                if (treeNode instanceof AbstractProgramNode) {
                    this.unsuppressAll((AbstractProgramNode)treeNode);
                }
                ++i;
            }
        }
    }

    private AbstractProgramNode replaceNode(AbstractProgramNode currentNode, List<AbstractProgramNode> newNodes) {
        AbstractProgramNode parent = (AbstractProgramNode)currentNode.getParent();
        if (parent == null || currentNode instanceof MainProgram || currentNode instanceof ProgramRootNode) {
            return currentNode;
        }
        int index = parent.getIndex((TreeNode)currentNode);
        boolean insertionSucceeded = true;
        for (AbstractProgramNode each : newNodes) {
            insertionSucceeded &= this.replaceInsertStrategy.insert(each, currentNode);
        }
        if (insertionSucceeded) {
            this.doDeleteNode(currentNode);
        }
        AbstractProgramNode programNodeToSelect = (AbstractProgramNode)parent.getChildAt(index);
        this.setSelected(programNodeToSelect);
        return programNodeToSelect;
    }

    @CompoundProgramChange
    public AbstractProgramNode suppressNode(AbstractProgramNode nodeToSuppress) {
        AbstractProgramNode abstractProgramNode = nodeToSuppress;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure11 editProgramServiceImpl$AjcClosure11 = new EditProgramServiceImpl$AjcClosure11(objectArray);
        return (AbstractProgramNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public boolean addNode(AbstractProgramNode nodeToAdd, AbstractProgramNode parentNode) {
        if (parentNode.getChildCount() == 0) {
            PlaceholderNode placeholderNode = this.entityFactory.createPlaceholderNode();
            parentNode.add((MutableTreeNode)((Object)placeholderNode));
            return this.insertNodeAfter(nodeToAdd, placeholderNode);
        }
        AbstractProgramNode lastChildNode = this.getLastChild(parentNode);
        return this.insertNodeAfter(nodeToAdd, lastChildNode);
    }

    private AbstractProgramNode getLastChild(AbstractProgramNode parentNode) {
        return (AbstractProgramNode)parentNode.getLastChild();
    }

    private List<AbstractProgramNode> unsuppressNode(AbstractProgramNode nodeToSuppress) {
        List<AbstractProgramNode> suppressedNodes = this.entityFactory.unpackSuppressedNode((SuppressedNode)nodeToSuppress);
        for (AbstractProgramNode each : suppressedNodes) {
            each.setUnregisterProgramReferencesOnDelete(true);
        }
        return suppressedNodes;
    }

    @CompoundProgramChange
    public void cutToClipboard(AbstractProgramNode programNode) {
        AbstractProgramNode abstractProgramNode = programNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure13 editProgramServiceImpl$AjcClosure13 = new EditProgramServiceImpl$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    @IgnoreProgramChanges
    public void copyToClipboard(AbstractProgramNode programNode) {
        AbstractProgramNode abstractProgramNode = programNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure15 editProgramServiceImpl$AjcClosure15 = new EditProgramServiceImpl$AjcClosure15(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    private boolean isCopyable(AbstractProgramNode programNode) {
        if (programNode instanceof MainProgram) {
            LegacyURDialogCreator.showErrorDialog(this.textResource.Error(), this.textResource.youCannotCopyTheMainProgram(), "");
            return false;
        }
        if (programNode instanceof InitVariablesNode) {
            LegacyURDialogCreator.showErrorDialog(this.textResource.Error(), this.textResource.youCannotCopyTheVariablesSetup(), "");
            return false;
        }
        return true;
    }

    @CompoundProgramChange
    public AbstractProgramNode pasteNodeBefore(AbstractProgramNode beforeThisNode) {
        AbstractProgramNode abstractProgramNode = beforeThisNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure17 editProgramServiceImpl$AjcClosure17 = new EditProgramServiceImpl$AjcClosure17(objectArray);
        return (AbstractProgramNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    public AbstractProgramNode pasteNodeAfter(AbstractProgramNode afterThisNode) {
        AbstractProgramNode abstractProgramNode = afterThisNode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        EditProgramServiceImpl$AjcClosure19 editProgramServiceImpl$AjcClosure19 = new EditProgramServiceImpl$AjcClosure19(objectArray);
        return (AbstractProgramNode)ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(editProgramServiceImpl$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    private AbstractProgramNode pasteNode(AbstractProgramNode currentSelection, InsertNodeStrategy initialStrategy, List<AbstractProgramNode> nodesOnClipboard) {
        AbstractProgramNode toSelect;
        try {
            this.programNodeDefinedCache.enable();
            toSelect = this.insertNodes(initialStrategy, this.afterPlacementStrategy, nodesOnClipboard, currentSelection);
            if (toSelect != null) {
                toSelect.setSelected();
            }
            this.variableNameClassResolver.resolveNameClash();
        }
        finally {
            this.programNodeDefinedCache.disable();
        }
        return toSelect;
    }

    private AbstractProgramNode insertNodes(InsertNodeStrategy initialStrategy, InsertNodeStrategy strategy, List<AbstractProgramNode> nodes, AbstractProgramNode currentSelection) {
        for (AbstractProgramNode node : nodes) {
            this.updateProgramCounters(node);
        }
        this.insertNodes(nodes, currentSelection, initialStrategy, strategy);
        return nodes.size() > 0 ? nodes.get(0) : null;
    }

    private void updateProgramCounters(AbstractProgramNode node) {
        if (node instanceof UpdateInternalVariables) {
            ((UpdateInternalVariables)node).updateProgramCounters(this.entityFactory, this.namingService);
        }
        int i = 0;
        while (i < node.getChildCount()) {
            TreeNode child = node.getChildAt(i);
            if (child instanceof SuppressedNode) {
                this.updateProgramCounters(((SuppressedNode)((Object)child)).getSuppressedNode());
            } else if (child instanceof AbstractProgramNode) {
                this.updateProgramCounters((AbstractProgramNode)child);
            }
            ++i;
        }
    }

    private void insertNodes(List<AbstractProgramNode> nodes, AbstractProgramNode currentSelection, InsertNodeStrategy initialStrategy, InsertNodeStrategy strategy) {
        InsertNodeStrategy currentStrategy = initialStrategy;
        for (AbstractProgramNode each : nodes) {
            ProgramRootNode.setProgramRoot(this.lookupService.getProgramRootNode(), each);
            if (!currentStrategy.insert(each, currentSelection)) {
                return;
            }
            currentSelection = each;
            currentStrategy = strategy;
        }
    }

    static {
        EditProgramServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ void moveNodeUp_aroundBody0(EditProgramServiceImpl ajc$this, AbstractProgramNode toBeMovedNode, JoinPoint joinPoint) {
        ajc$this.moveSelectedNode(toBeMovedNode, Direction.UP);
    }

    static final /* synthetic */ void moveNodeDown_aroundBody2(EditProgramServiceImpl ajc$this, AbstractProgramNode toBeMovedNode, JoinPoint joinPoint) {
        ajc$this.moveSelectedNode(toBeMovedNode, Direction.DOWN);
    }

    static final /* synthetic */ Collection deleteNode_aroundBody4(EditProgramServiceImpl ajc$this, AbstractProgramNode toDelete, JoinPoint joinPoint) {
        try {
            ajc$this.programNodeDefinedCache.enable();
            Collection<AbstractProgramNode> collection = ajc$this.doDeleteNode(ajc$this.unsuppressAll(toDelete));
            return collection;
        }
        finally {
            ajc$this.programNodeDefinedCache.disable();
        }
    }

    static final /* synthetic */ boolean insertNodeAfter_aroundBody6(EditProgramServiceImpl ajc$this, AbstractProgramNode newNodeToInsert, AbstractProgramNode afterThisNode, JoinPoint joinPoint) {
        return ajc$this.insertNewNode(newNodeToInsert, afterThisNode, ajc$this.afterPlacementStrategy);
    }

    static final /* synthetic */ boolean insertNodeBefore_aroundBody8(EditProgramServiceImpl ajc$this, AbstractProgramNode newNodeToInsert, AbstractProgramNode beforeThisNode, JoinPoint joinPoint) {
        return ajc$this.insertNewNode(newNodeToInsert, beforeThisNode, ajc$this.beforePlacementStrategy);
    }

    static final /* synthetic */ AbstractProgramNode suppressNode_aroundBody10(EditProgramServiceImpl ajc$this, AbstractProgramNode nodeToSuppress, JoinPoint joinPoint) {
        if (!nodeToSuppress.isSuppressible()) {
            return nodeToSuppress;
        }
        try {
            List<AbstractProgramNode> suppressedNodes;
            ajc$this.programNodeDefinedCache.enable();
            if (nodeToSuppress instanceof SuppressedNode) {
                suppressedNodes = ajc$this.unsuppressNode(nodeToSuppress);
            } else {
                suppressedNodes = new ArrayList<AbstractProgramNode>();
                suppressedNodes.add(ajc$this.entityFactory.createSuppressedNode(nodeToSuppress));
                nodeToSuppress.setUnregisterProgramReferencesOnDelete(false);
            }
            AbstractProgramNode abstractProgramNode = ajc$this.replaceNode(nodeToSuppress, suppressedNodes);
            return abstractProgramNode;
        }
        finally {
            ajc$this.programNodeDefinedCache.disable();
        }
    }

    static final /* synthetic */ void cutToClipboard_aroundBody12(EditProgramServiceImpl ajc$this, AbstractProgramNode programNode, JoinPoint joinPoint) {
        if (ajc$this.isDeletable(programNode)) {
            ajc$this.copyToClipboard(programNode);
            ajc$this.deleteNode(programNode);
        }
    }

    static final /* synthetic */ void copyToClipboard_aroundBody14(EditProgramServiceImpl ajc$this, AbstractProgramNode programNode, JoinPoint joinPoint) {
        if (ajc$this.isCopyable(programNode)) {
            ajc$this.programTreeClipboard.setAll(ajc$this.getAllDependentNodes(programNode));
        }
    }

    static final /* synthetic */ AbstractProgramNode pasteNodeBefore_aroundBody16(EditProgramServiceImpl ajc$this, AbstractProgramNode beforeThisNode, JoinPoint joinPoint) {
        List<AbstractProgramNode> nodesOnClipboard = ajc$this.programTreeClipboard.getAll();
        return ajc$this.pasteNode(beforeThisNode, ajc$this.beforePlacementStrategy, nodesOnClipboard);
    }

    static final /* synthetic */ AbstractProgramNode pasteNodeAfter_aroundBody18(EditProgramServiceImpl ajc$this, AbstractProgramNode afterThisNode, JoinPoint joinPoint) {
        List<AbstractProgramNode> nodesOnClipboard = ajc$this.programTreeClipboard.getAll();
        return ajc$this.pasteNode(afterThisNode, ajc$this.afterPlacementStrategy, nodesOnClipboard);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EditProgramServiceImpl.java", EditProgramServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "moveNodeUp", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "toBeMovedNode", "", "void"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "moveNodeDown", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "toBeMovedNode", "", "void"), 108);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteNode", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "toDelete", "", "java.util.Collection"), 159);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertNodeAfter", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode:com.ur.polyscope.program.nodes.AbstractProgramNode", "newNodeToInsert:afterThisNode", "", "boolean"), 256);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertNodeBefore", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode:com.ur.polyscope.program.nodes.AbstractProgramNode", "newNodeToInsert:beforeThisNode", "", "boolean"), 262);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "suppressNode", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "nodeToSuppress", "", "com.ur.polyscope.program.nodes.AbstractProgramNode"), 368);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cutToClipboard", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "programNode", "", "void"), 416);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "copyToClipboard", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "programNode", "", "void"), 425);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pasteNodeBefore", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "beforeThisNode", "", "com.ur.polyscope.program.nodes.AbstractProgramNode"), 444);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pasteNodeAfter", "com.ur.view.domain.program.services.impl.EditProgramServiceImpl", "com.ur.polyscope.program.nodes.AbstractProgramNode", "afterThisNode", "", "com.ur.polyscope.program.nodes.AbstractProgramNode"), 451);
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

