/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.geometric;

import com.ur.lang.Defense;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.UpdateGeomPoseStrategy;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import javax.media.j3d.Transform3D;
import javax.swing.tree.MutableTreeNode;

public class GeomFeatureUpdatePoseStrategy
implements UpdateGeomPoseStrategy {
    public void setPosition(ViewableGeomFeature viewableGeomFeature, Pose6d newPose, JointPositionVector jpv) {
        if (viewableGeomFeature instanceof GeomPoseNode) {
            GeomPoseNode gpn = (GeomPoseNode)viewableGeomFeature;
            gpn.setPosition(jpv, newPose);
            gpn.environmentChange();
        } else if (viewableGeomFeature instanceof GeomPlaneNode) {
            GeomPlaneNode geomPlaneNode = (GeomPlaneNode)viewableGeomFeature;
            GeomPoseNode p1 = geomPlaneNode.getPoint(0);
            GeomPoseNode p2 = geomPlaneNode.getPoint(1);
            GeomPoseNode p3 = geomPlaneNode.getPoint(2);
            Transform3D transform3D = Pose6dTransformUtils.getTransform3D((Pose6d)newPose);
            geomPlaneNode.setNewTransform(transform3D);
            p1.setPositionNoRecalculate(jpv, newPose);
            p1.setNewTransform(transform3D);
            Pose6d xAxisTransformation = new Pose6d(0.0, 1.0, 0.0, 0.0, 0.0, 0.0);
            Pose6d yAxisTransformation = new Pose6d(-1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Pose6d pose6dX = p1.transformPoseInFeatureFrameToPoseInBaseFrame(xAxisTransformation);
            Pose6d pose6dY = p1.transformPoseInFeatureFrameToPoseInBaseFrame(yAxisTransformation);
            p2.setPositionNoRecalculate(jpv, pose6dX);
            p3.setPosition(jpv, pose6dY);
            geomPlaneNode.setHasUserPoints(false);
            geomPlaneNode.setManualEdited(true);
            geomPlaneNode.environmentChange();
        }
    }

    public ViewableGeomFeature deepClonePlane(ViewableGeomFeature node) {
        if (node instanceof GeomPlaneNode) {
            GeomPlaneNode source = (GeomPlaneNode)node;
            GeomPlaneNode clone = (GeomPlaneNode)((Object)node.clone());
            if (source.getPoint(0) != null) {
                clone.insert((MutableTreeNode)source.getPoint(0).clone(), 0);
            }
            if (source.getPoint(1) != null) {
                clone.insert((MutableTreeNode)source.getPoint(1).clone(), 1);
            }
            if (source.getPoint(2) != null) {
                clone.insert((MutableTreeNode)source.getPoint(2).clone(), 2);
            }
            return clone;
        }
        if (node instanceof GeomPoseNode) {
            return (ViewableGeomFeature)node.clone();
        }
        Defense.notNull(null);
        return null;
    }
}

