/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.geometric.feature;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamingService;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.move.MoveTab;
import com.ur.move.automove.AutoMoveHelper;
import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.AutoMoveTitleComposite;
import com.ur.move.poseeditor.FeaturePoseEditorPanelImpl;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.JoggableGeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.swing.CardPanel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.view.geometric.feature.PlaneTeachWizardCallback;
import gui.commandpanels.WaypointCard;
import gui.geom.BaseView;
import gui.geom.GeomFeatureFactory;
import gui.geom.ToolView;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.media.j3d.Transform3D;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class EditGeomFeatureCardPanel
extends CardPanel {
    public static final String SET_THIS_POINT = WaypointCard.CHANGE_THIS_FEATURE_BUTTON;
    public static final String MOVE_ROBOT_TO_FEATURE = "moveRobotToFeature.EditGeomFeatureCardPanel";
    public static final String EDIT_FEATURE = String.valueOf(EditGeomFeatureCardPanel.class.getSimpleName()) + ".editFeature";
    protected final NamingService namingService;
    protected final PoweredOnRobotRequirement poweredOnRobotRequirement;
    protected final TextResource textResource;
    private final AutoMoveHelper autoMoveHelper;
    protected JoggableGeomFeature joggableGeomFeature = null;
    protected boolean updating = false;
    JPanel jPanel1;
    JCheckBox joggableCheckBox;
    JCheckBox showAxesCheckBox;
    private ProgramVisualization programVisualizerToEdit;
    private JButton changePositionButton;
    private JButton moveRobotToFeatureButton;
    protected JButton editFeatureButton;
    protected JPanel rightSideButtons;
    protected boolean enableJoggableCheckBoxAndAllowMoveRobot;
    protected JLabel unreachableLabel;
    private final InverseKinematicProviderExt inverseKinematicProviderExt;
    private HelpIdAssigner helpIdAssigner;

    EditGeomFeatureCardPanel(ProgramVisualization programVisualizer, NamingService namingService, PoweredOnRobotRequirement poweredOnRobotRequirement, TextResource textResource, AutoMoveHelper autoMoveHelper, InverseKinematicProviderExt inverseKinematicProviderExt, HelpIdAssigner helpIdAssigner) {
        this.programVisualizerToEdit = programVisualizer;
        this.namingService = namingService;
        this.poweredOnRobotRequirement = poweredOnRobotRequirement;
        this.textResource = textResource;
        this.autoMoveHelper = autoMoveHelper;
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
        this.helpIdAssigner = helpIdAssigner;
        this.initComponents();
        this.assignHelpIds();
        this.nameComponents();
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.showAxesCheckBox, "gui:geom_edit_show_axes");
        this.helpIdAssigner.assignHelpId((JComponent)this.joggableCheckBox, "gui:geom_edit_joggable");
        this.helpIdAssigner.assignHelpId((JComponent)this.changePositionButton, "gui:geom_edit_change_position");
        this.helpIdAssigner.assignHelpId((JComponent)this.moveRobotToFeatureButton, "gui:geom_edit_move_robot_to_feature");
        this.helpIdAssigner.assignHelpId((JComponent)this.editFeatureButton, "gui:feature_edit");
    }

    private void nameComponents() {
        this.changePositionButton.setName(SET_THIS_POINT);
    }

    public void enter(Object o) {
        if (o instanceof JoggableGeomFeature) {
            this.joggableGeomFeature = (JoggableGeomFeature)o;
        }
        if (this.joggableGeomFeature != null) {
            this.updateCard();
        }
    }

    protected void updateChangePositionButton() {
        if (this.joggableGeomFeature instanceof GeomPoseNode) {
            this.changePositionButton.setText(this.textResource.teachThisPoint());
            this.changePositionButton.setVisible(true);
        } else if (this.joggableGeomFeature instanceof GeomPlaneNode) {
            if (this.joggableGeomFeature.hasHiddenSubFeatureChildren()) {
                this.changePositionButton.setVisible(true);
                this.changePositionButton.setText(this.textResource.teachThisPlane());
            } else {
                this.changePositionButton.setVisible(false);
            }
        } else {
            this.changePositionButton.setVisible(false);
        }
    }

    protected void updateCard() {
        this.updating = true;
        this.joggableCheckBox.setSelected(this.joggableGeomFeature.isJoggableEnabled());
        this.enableJoggableCheckBoxAndAllowMoveRobot = true;
        if (this.joggableGeomFeature instanceof BaseView || this.joggableGeomFeature instanceof ToolView) {
            this.enableJoggableCheckBoxAndAllowMoveRobot = false;
        }
        if (this.joggableGeomFeature instanceof GeomLineNode) {
            this.joggableGeomFeature.recalculateTransform();
        }
        this.moveRobotToFeatureButton.setEnabled(this.enableJoggableCheckBoxAndAllowMoveRobot && !this.joggableGeomFeature.isUndefined() && this.isFeatureReachable());
        this.showAxesCheckBox.setSelected(this.joggableGeomFeature.getShowAxes());
        this.updateChangePositionButton();
        this.updating = false;
    }

    protected boolean isFeatureReachable() {
        return this.inverseKinematicProviderExt.getInverseKinematics(new Pose6d(this.joggableGeomFeature.getSpatialPose().asArray()), RobotState.getLatestRobotState().clone().jointPosition, RobotState.getLatestRobotState().tcpOffset, false) != null;
    }

    public Object exit() {
        return null;
    }

    protected void changePositionButtonActionPerformed() {
        this.stackCurrentCardAndSwitchTo(MoveTab.class, this.joggableGeomFeature);
    }

    private void showAxesCheckBoxActionPerformed() {
        if (!this.updating) {
            this.joggableGeomFeature.setShowAxes(this.showAxesCheckBox.isSelected());
            this.joggableGeomFeature.applyShowAxesChoice(this.programVisualizerToEdit);
        }
    }

    public EditGeomFeatureCardPanel withoutJoggableAndShowAxes() {
        this.joggableCheckBox.getParent().remove(this.joggableCheckBox);
        this.showAxesCheckBox.getParent().remove(this.showAxesCheckBox);
        return this;
    }

    protected void initComponents() {
        this.jPanel1 = new JPanel();
        this.showAxesCheckBox = new JCheckBox();
        this.joggableCheckBox = new JCheckBox();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.moveRobotToFeatureButton = new JButton();
        this.changePositionButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridLayout(3, 1));
        this.showAxesCheckBox.setText(this.textResource.showAxes());
        this.showAxesCheckBox.setName("featuresShowAxesCheckBox");
        this.showAxesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditGeomFeatureCardPanel.this.showAxesCheckBoxActionPerformed();
            }
        });
        this.jPanel1.add(this.showAxesCheckBox);
        this.joggableCheckBox.setText(this.textResource.Joggable());
        this.joggableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditGeomFeatureCardPanel.this.joggableCheckBoxItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.joggableCheckBox);
        this.add(this.jPanel1, "Before");
        jPanel2.setLayout(new CardLayout());
        this.rightSideButtons = new JPanel();
        this.rightSideButtons.setLayout(new FlowLayout(2));
        this.moveRobotToFeatureButton.setText(this.textResource.moveRobotHere());
        this.moveRobotToFeatureButton.setName(MOVE_ROBOT_TO_FEATURE);
        this.moveRobotToFeatureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (EditGeomFeatureCardPanel.this.poweredOnRobotRequirement.checkAndNotify()) {
                    EditGeomFeatureCardPanel.this.moveRobotToFeatureButtonActionPerformed();
                }
            }
        });
        this.editFeatureButton = new JButton();
        this.editFeatureButton.setVisible(false);
        this.editFeatureButton.setFocusPainted(false);
        this.editFeatureButton.setText(this.textResource.Edit());
        this.editFeatureButton.setName(EDIT_FEATURE);
        this.editFeatureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditGeomFeatureCardPanel.this.stackCurrentCardAndSwitchTo(FeaturePoseEditorPanelImpl.class, EditGeomFeatureCardPanel.this.joggableGeomFeature);
            }
        });
        this.rightSideButtons.add(this.editFeatureButton);
        this.rightSideButtons.add(this.moveRobotToFeatureButton);
        this.changePositionButton.setText(this.textResource.changeThisPosition());
        this.changePositionButton.setName(SET_THIS_POINT);
        this.changePositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (EditGeomFeatureCardPanel.this.poweredOnRobotRequirement.checkAndNotify()) {
                    EditGeomFeatureCardPanel.this.changePositionButtonActionPerformed();
                }
            }
        });
        this.rightSideButtons.add(this.changePositionButton);
        this.unreachableLabel = new JLabel();
        this.unreachableLabel.setFont(new Font("DejaVu Sans", 0, 13));
        jPanel3.add(this.unreachableLabel);
        jPanel3.add((Component)this.rightSideButtons, "East");
        jPanel2.add((Component)jPanel3, "card4");
        this.add(jPanel2, "Center");
    }

    private void joggableCheckBoxItemStateChanged(ItemEvent evt) {
        if (!this.updating) {
            this.joggableGeomFeature.setJoggableEnabled(evt.getStateChange() == 1);
        }
    }

    private void moveRobotToFeatureButtonActionPerformed() {
        if (this.joggableGeomFeature != null && !this.joggableGeomFeature.isUndefined() && this.autoMoveHelper.isReadyToTransitionToAutoMove(this.joggableGeomFeature.getTransform())) {
            Pose6d targetPose = Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)this.joggableGeomFeature.getTransform());
            this.stackCurrentCardAndSwitchTo(AutoMoveTab.class, new AutoMoveTitleComposite((Object)targetPose, this.joggableGeomFeature.toString()));
        }
    }

    protected static class UpdatePlaneNodeCallback
    implements PlaneTeachWizardCallback {
        private final GeomFeatureFactory geomFeatureFactory;
        private final GeomPlaneNode planeNode;

        UpdatePlaneNodeCallback(GeomFeatureFactory geomFeatureFactory, GeomPlaneNode planeNode) {
            this.geomFeatureFactory = geomFeatureFactory;
            this.planeNode = planeNode;
        }

        @Override
        public void onOk(List<GeomPoseNode> userPoints, List<GeomPoseNode> calculatedPoints) {
            this.planeNode.setManualEdited(false);
            this.planeNode.setHasUserPoints(true);
            this.planeNode.getUserPoints().clear();
            for (GeomPoseNode userPoint : userPoints) {
                GeomPoseNode userPointCopy = this.geomFeatureFactory.createPoseNode(true, true);
                this.setupChildNodeForPlane(userPointCopy, userPoint);
                this.planeNode.getUserPoints().add(userPointCopy);
            }
            this.setupChildNodeForPlane(this.planeNode.getPoint(0), calculatedPoints.get(0));
            this.setupChildNodeForPlane(this.planeNode.getPoint(1), calculatedPoints.get(1));
            this.setupChildNodeForPlane(this.planeNode.getPoint(2), calculatedPoints.get(2));
        }

        @Override
        public void onCancel() {
        }

        @Override
        public List<GeomPoseNode> getInitialUserPoints() {
            return this.planeNode.getUserPoints();
        }

        @Override
        public boolean isEdited() {
            return this.planeNode.isManualEdited();
        }

        private void setupChildNodeForPlane(GeomPoseNode child, GeomPoseNode planeTeachMeasurement) {
            child.setJoggableEnabled(false);
            child.setPosition(planeTeachMeasurement.getJointPositionVector(), planeTeachMeasurement.getPose());
            child.setTcpOffset(planeTeachMeasurement.getTcpOffset());
        }
    }
}

