/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.geometric.feature;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.lang.react.RecipeHelper;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.automove.AutoMoveHelper;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.swing.CardPanel;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidValuesValidator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import com.ur.view.geometric.feature.EditGeomFeatureCardPanel;
import com.ur.view.geometric.feature.EditGeomFeatureCardPanelImpl;
import com.ur.view.geometric.feature.ViewGeomFeatureCardPanel;
import gui.geom.BaseView;
import gui.geom.GeomFeatureFactory;
import gui.geom.ToolView;
import gui.polyscope.setup.treenodes.SetupTreeContainer;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import gui.tools.LanguagePack;
import gui.tools.dialogs.input.NameValidationFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Provider;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public abstract class FeaturesCardPanel
extends CardPanel {
    public static final String DELETE_SELECTED_FEATURE = "GeomCardDeleteFeatureButton";
    public static final String RENAME_SELECTED_FEATURE = "GeomCardRenameFeatureButton";
    final NamingService namingService;
    final PoweredOnRobotRequirement poweredOnRobotRequirement;
    final Provider<SetupTreeContainer> provideTreeContainer;
    final TextResource textResource;
    final GeomFeatureFactory geomFeatureFactory;
    protected final AutoMoveHelper autoMoveHelper;
    protected ViewableGeomFeature viewableGeomFeature = null;
    protected FlippablePanel flippableBottomPanel;
    protected JPanel graphicsPanel;
    protected JPanel northPanel;
    protected JButton deleteFeatureButton;
    protected JButton renameButton;
    protected JLabel nameOfFeature;
    protected RobotCanvas3D robotCanvas3D;
    protected ProgramVisualization programVisualizer;
    private SetupFeatureContainerNode featureContainerNode = null;
    private final FeaturesLookup lookupService;
    private final RobotCanvas3DFactory robotCanvas3DFactory;
    private final InstallationComponentLookup installationLookupService;
    protected final InverseKinematicProviderExt inverseKinematicProviderExt;
    private HelpIdAssigner helpIdAssigner;
    private final RecipeHelper recipeHelper = new RecipeHelper();

    FeaturesCardPanel(NamingService namingService, FeaturesLookup lookupService, PoweredOnRobotRequirement poweredOnRobotRequirement, Provider<SetupTreeContainer> provideTreeContainer, InstallationComponentLookup installationLookupService, RobotCanvas3DFactory robotCanvas3DFactory, TextResource textResource, GeomFeatureFactory geomFeatureFactory, AutoMoveHelper autoMoveHelper, @Source(value=Arm.class) Recipe<Arm> armRecipe, InverseKinematicProviderExt inverseKinematicProviderExt, HelpIdAssigner helpIdAssigner) {
        this.namingService = namingService;
        this.lookupService = lookupService;
        this.poweredOnRobotRequirement = poweredOnRobotRequirement;
        this.provideTreeContainer = provideTreeContainer;
        this.installationLookupService = installationLookupService;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.textResource = textResource;
        this.geomFeatureFactory = geomFeatureFactory;
        this.autoMoveHelper = autoMoveHelper;
        this.inverseKinematicProviderExt = inverseKinematicProviderExt;
        this.helpIdAssigner = helpIdAssigner;
        this.recipeHelper.add(Arm.class, armRecipe, (Consumer)new ArmConsumer());
        this.initialize();
    }

    private void initialize() {
        this.initializeGraphics();
        this.setupButtons();
        this.setupComponents();
        this.assignHelpIds();
    }

    public void enter(Object o) {
        this.programVisualizer.clearVisualization();
        this.updateSelectedFeature(o);
        this.robotCanvas3D.setVisible(true);
        this.recipeHelper.subscribe(Arm.class);
        this.updateCard();
    }

    public Object exit() {
        this.recipeHelper.unsubscribe(Arm.class);
        return null;
    }

    public void updateSelectedFeature(Object o) {
        if (o instanceof ViewableGeomFeature) {
            this.enterViewableGeomFeature((ViewableGeomFeature)o);
        } else if (o instanceof SetupFeatureContainerNode) {
            this.enterSetupFeatureContainerNode((SetupFeatureContainerNode)o);
        }
    }

    private EditGeomFeatureCardPanel getEditPanel() {
        return new EditGeomFeatureCardPanelImpl(this.programVisualizer, this.namingService, this.poweredOnRobotRequirement, this.textResource, this.autoMoveHelper, this.geomFeatureFactory, this.inverseKinematicProviderExt, this.helpIdAssigner).withoutJoggableAndShowAxes();
    }

    private ViewGeomFeatureCardPanel getViewPanel() {
        return new ViewGeomFeatureCardPanel(this.namingService, this.poweredOnRobotRequirement, this.textResource, this.autoMoveHelper, this.helpIdAssigner);
    }

    protected abstract void setButtonLookAndFeel();

    protected abstract void setComponentLookAndFeel();

    protected abstract void updateGraphics(boolean var1);

    protected abstract Class<? extends CardPanel> getFeatureEditCardClass();

    protected abstract Class<? extends CardPanel> getFeatureViewCardClass();

    private void updateCard() {
        if (this.viewableGeomFeature != null) {
            boolean isBaseOrTool;
            this.viewableGeomFeature.setTransformAccordingToRobotState(((Arm)this.recipeHelper.lastProviderValue(Arm.class)).getTool().getCartesianInfo().getTool());
            this.nameOfFeature.setText(HTML.html((String)HTML.h1((String)this.viewableGeomFeature.toString())));
            boolean showRenameButton = true;
            boolean bl = isBaseOrTool = this.viewableGeomFeature instanceof BaseView || this.viewableGeomFeature instanceof ToolView;
            if (isBaseOrTool) {
                showRenameButton = false;
            }
            this.updateGraphics(isBaseOrTool);
            this.renameButton.setVisible(showRenameButton);
            boolean showDeleteButton = true;
            if (this.viewableGeomFeature instanceof BaseView || this.viewableGeomFeature instanceof ToolView || this.viewableGeomFeature.getParent() instanceof GeomFeature) {
                showDeleteButton = false;
            }
            this.deleteFeatureButton.setVisible(showDeleteButton);
            if (this.viewableGeomFeature instanceof GeomPoseNodeContributed) {
                this.flippableBottomPanel.switchTo(this.getFeatureViewCardClass(), (Object)this.viewableGeomFeature);
                this.renameButton.setVisible(false);
                this.deleteFeatureButton.setVisible(false);
            } else {
                this.flippableBottomPanel.switchTo(this.getFeatureEditCardClass(), (Object)this.viewableGeomFeature);
            }
            this.flippableBottomPanel.getCurrentCard().enter((Object)this.viewableGeomFeature);
            this.robotCanvas3D.addQueue((Runnable)new UpdateVisualizationRunnable());
        }
    }

    private void setupButtons() {
        AutoCorrectionValidator validator = NameValidationFactory.getVariableNameValidatorWithWhiteList(this.namingService, GeomFeature.class, this.textResource.variableNameAlreadyExists(), this.textResource.illegalVariableName(), this.textResource, "");
        this.deleteFeatureButton = new JButton(this.textResource.Delete());
        this.deleteFeatureButton.setName(DELETE_SELECTED_FEATURE);
        this.deleteFeatureButton.addActionListener(new DeleteFeatureAction());
        this.renameButton = new JButton();
        this.renameButton.setName(RENAME_SELECTED_FEATURE);
        this.renameButton.addMouseListener(new RenameFeatureAdapter((ValidValuesValidator)validator));
        this.setButtonLookAndFeel();
        TextFieldUtils.bindTextPicker((JComponent)this.renameButton, (TextHolder)new FeatureTextHolder(), (ValidationStrategy)validator);
    }

    protected void setupComponents() {
        this.flippableBottomPanel = new FlippablePanel();
        this.flippableBottomPanel.setCardParent((CardPanel)this);
        this.flippableBottomPanel.addCardPanel((CardPanel)this.getEditPanel());
        this.flippableBottomPanel.addCardPanel((CardPanel)this.getViewPanel());
        this.nameOfFeature = new JLabel();
        this.nameOfFeature.setText(HTML.html((String)HTML.h1((String)LanguagePack.getCommandName("Point"))));
        this.northPanel = new JPanel();
        this.graphicsPanel = new JPanel(new BorderLayout());
        this.graphicsPanel.add(this.robotCanvas3D.getComponent());
        this.setComponentLookAndFeel();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)this.flippableBottomPanel);
        bottomPanel.validate();
        this.add(this.northPanel, "North");
        this.add(this.graphicsPanel, "Center");
        this.add(bottomPanel, "South");
    }

    protected void initializeGraphics() {
        this.robotCanvas3D = this.robotCanvas3DFactory.buildMetalRobot();
        this.robotCanvas3D.setDebugName("Features 3D Canvas");
        this.programVisualizer = new ProgramVisualization(this.robotCanvas3D.isActualCanvas());
        if (this.robotCanvas3D.isActualCanvas()) {
            this.robotCanvas3D.addNodeToScene(this.programVisualizer.getElementNode());
        }
        this.robotCanvas3D.setTransitionTime(0.5f);
        new URCanvas3DFingerDragViewShifter(this.robotCanvas3D);
    }

    protected void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.nameOfFeature, "gui:installation_features");
        this.helpIdAssigner.assignHelpId((JComponent)this.renameButton, "gui:installation_features_rename_button");
        this.helpIdAssigner.assignHelpId((JComponent)this.deleteFeatureButton, "gui:installation_features_delete_button");
    }

    private void enterViewableGeomFeature(ViewableGeomFeature o) {
        this.viewableGeomFeature = o.isHiddenSubFeature() ? (ViewableGeomFeature)o.getParent() : o;
        this.featureContainerNode = null;
    }

    private void enterSetupFeatureContainerNode(SetupFeatureContainerNode o) {
        this.featureContainerNode = o;
        this.viewableGeomFeature = null;
    }

    protected List<String> getValidFeatureNames() {
        ArrayList<String> featureNames = new ArrayList<String>();
        if (this.viewableGeomFeature != null) {
            featureNames.add(this.viewableGeomFeature.toString());
        }
        if (this.getSetupFeatureContainerNode().isLinkable((GeomFeature)this.viewableGeomFeature)) {
            featureNames.addAll(this.getNamesOfAllLinkableFeatures());
        }
        return featureNames;
    }

    private Collection<? extends String> getNamesOfAllLinkableFeatures() {
        List<GeomFeature> linkableFeatures = this.getSetupFeatureContainerNode().getLinkableFeatures();
        return Lists.transform(linkableFeatures, (Function)Functions.toStringFunction());
    }

    private SetupFeatureContainerNode getSetupFeatureContainerNode() {
        return (SetupFeatureContainerNode)this.installationLookupService.getComponent(SetupFeatureContainerNode.class);
    }

    protected void setSize(Component c, Dimension dimension) {
        c.setSize(dimension);
        c.setPreferredSize(dimension);
        c.setMaximumSize(dimension);
    }

    private class ArmConsumer
    implements Consumer<Arm> {
        private ArmConsumer() {
        }

        public void accept(Arm arm) {
            FeaturesCardPanel.this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable(arm.getTool().getCartesianInfo().getTool(), arm.getActualJointsPosition()));
        }
    }

    private class DeleteFeatureAction
    implements ActionListener {
        private DeleteFeatureAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ViewableGeomFeature feature = FeaturesCardPanel.this.viewableGeomFeature;
            FeaturesCardPanel.this.namingService.deregisterNamedEntity((NamedEntity)feature);
            ((SetupTreeContainer)FeaturesCardPanel.this.provideTreeContainer.get()).removeGeomFeature((GeomFeature)feature);
        }
    }

    private class FeatureTextHolder
    implements TextHolder {
        private FeatureTextHolder() {
        }

        public String getText() {
            return FeaturesCardPanel.this.viewableGeomFeature.getName();
        }

        public void setText(String text) {
            FeaturesCardPanel.this.viewableGeomFeature.setName(text);
            FeaturesCardPanel.this.updateCard();
            FeaturesCardPanel.this.lookupService.getFeatureContainer().getTreeModel().nodeChanged((TreeNode)FeaturesCardPanel.this.viewableGeomFeature);
        }
    }

    private class RenameFeatureAdapter
    extends MouseAdapter {
        private final ValidValuesValidator validator;

        private RenameFeatureAdapter(ValidValuesValidator validator) {
            this.validator = validator;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.addValidValues();
        }

        private void addValidValues() {
            this.validator.setValidValues(FeaturesCardPanel.this.getValidFeatureNames().toArray(new String[0]));
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private Pose6d tool;
        private JointPositionVector jointPosition;

        public UpdateGraphicsRunnable(Pose6d tool, JointPositionVector jointPosition) {
            this.tool = tool;
            this.jointPosition = jointPosition;
        }

        @Override
        public void run() {
            if (FeaturesCardPanel.this.viewableGeomFeature != null) {
                FeaturesCardPanel.this.viewableGeomFeature.setTransformAccordingToRobotState(this.tool);
            } else if (FeaturesCardPanel.this.featureContainerNode != null) {
                for (GeomFeature each : FeaturesCardPanel.this.featureContainerNode.getUniqueGeomNodes(true)) {
                    if (!(each instanceof ViewableGeomFeature)) continue;
                    ViewableGeomFeature v = (ViewableGeomFeature)each;
                    v.setTransformAccordingToRobotState(this.tool);
                }
            }
            FeaturesCardPanel.this.robotCanvas3D.setJointAngleVector(this.jointPosition);
        }
    }

    private class UpdateVisualizationRunnable
    implements Runnable {
        private UpdateVisualizationRunnable() {
        }

        @Override
        public void run() {
            FeaturesCardPanel.this.viewableGeomFeature.setProgramVisualization(FeaturesCardPanel.this.programVisualizer);
        }
    }
}

