/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.geometric.feature;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.polyscope.visualizer.canvasbehavior.URCanvas3DFingerDragViewShifter;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.swing.wizard.AbstractWizardPage;
import com.ur.swing.wizard.ButtonEvent;
import com.ur.util.event.Subscription;
import com.ur.view.geometric.feature.PlaneTeachModel;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PlaneTeachFinaliseWizardPage
extends AbstractWizardPage {
    private PlaneTeachModel planeTeachModel;
    private final VisualizerFactory visualizerFactory;
    private Recipe<Arm> armRecipe;
    private RobotCanvas3D robotCanvas3D;
    private ProgramVisualization programVisualizer;
    private ViewableGeomFeature viewableGeomFeature = null;
    private Subscription armSubscription;

    public PlaneTeachFinaliseWizardPage(String title, PlaneTeachModel planeTeachModel, VisualizerFactory visualizerFactory, @Source(value=Arm.class) Recipe<Arm> armRecipe) {
        super(title);
        this.planeTeachModel = planeTeachModel;
        this.visualizerFactory = visualizerFactory;
        this.armRecipe = armRecipe;
        this.initComponents();
        new URCanvas3DFingerDragViewShifter(this.robotCanvas3D);
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.robotCanvas3D = (RobotCanvas3D)this.visualizerFactory.createCanvas();
        this.robotCanvas3D.setDebugName("Plane Teach Finalize 3D Canvas");
        this.programVisualizer = new ProgramVisualization(this.robotCanvas3D.isActualCanvas());
        if (this.robotCanvas3D.isActualCanvas()) {
            this.robotCanvas3D.addNodeToScene(this.programVisualizer.getElementNode());
        }
        this.robotCanvas3D.setTransitionTime(0.5f);
        JPanel graphicsPanel = new JPanel(new BorderLayout());
        graphicsPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0), BorderFactory.createMatteBorder(2, 2, 2, 2, UIManager.getColor("CardPanel.background"))));
        graphicsPanel.add(this.robotCanvas3D.getComponent());
        this.add(graphicsPanel, "Center");
    }

    private void updateCard() {
        if (this.viewableGeomFeature != null) {
            RobotState robotState = RobotState.getLatestRobotState();
            this.viewableGeomFeature.setTransformAccordingToRobotState(robotState.tool);
            this.viewableGeomFeature.setShowAxes(true);
            this.robotCanvas3D.addQueue((Runnable)new UpdateGeomFeatureRunnable());
        }
        this.updateGraphics();
    }

    private void updateGraphics() {
        this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable((Arm)this.armRecipe.lastProvider().get()));
    }

    public void enter(Object object) {
        this.armSubscription = this.armRecipe.executeOnUIThread().distinctUntilChanged().subscribe((Consumer)new ArmConsumer());
        this.robotCanvas3D.setVisible(true);
        this.programVisualizer.clearVisualization();
        if (this.stateOK()) {
            this.viewableGeomFeature = this.planeTeachModel.createPlaneWithCalculatedPoints();
        }
        this.updateCard();
    }

    public Object exit() {
        this.viewableGeomFeature = null;
        this.programVisualizer.clearVisualization();
        this.armSubscription.dispose();
        this.updateGraphics();
        this.robotCanvas3D.setVisible(false);
        this.fireButtonEvent(ButtonEvent.ButtonEventType.DISABLE_BUTTON, AbstractWizardPage.BUTTON_FINISH);
        return null;
    }

    public void setupWizardButtons() {
        super.setupWizardButtons();
        if (this.stateOK()) {
            this.fireButtonEvent(ButtonEvent.ButtonEventType.ENABLE_BUTTON, AbstractWizardPage.BUTTON_FINISH);
        }
    }

    private boolean stateOK() {
        return this.planeTeachModel.getState() == PlaneTeachModel.PlaneTeachInState.OK;
    }

    private class ArmConsumer
    implements Consumer<Arm> {
        private ArmConsumer() {
        }

        public void accept(Arm arm) {
            PlaneTeachFinaliseWizardPage.this.robotCanvas3D.addQueue((Runnable)new UpdateGraphicsRunnable(arm));
        }
    }

    private class UpdateGeomFeatureRunnable
    implements Runnable {
        private UpdateGeomFeatureRunnable() {
        }

        @Override
        public void run() {
            PlaneTeachFinaliseWizardPage.this.viewableGeomFeature.setProgramVisualization(PlaneTeachFinaliseWizardPage.this.programVisualizer);
            PlaneTeachFinaliseWizardPage.this.viewableGeomFeature.applyShowAxesChoice(PlaneTeachFinaliseWizardPage.this.programVisualizer);
        }
    }

    private class UpdateGraphicsRunnable
    implements Runnable {
        private Arm arm;

        public UpdateGraphicsRunnable(Arm arm) {
            this.arm = arm;
        }

        @Override
        public void run() {
            if (PlaneTeachFinaliseWizardPage.this.viewableGeomFeature != null) {
                PlaneTeachFinaliseWizardPage.this.viewableGeomFeature.setTransformAccordingToRobotState(this.arm.getTool().getCartesianInfo().getTool());
            }
            PlaneTeachFinaliseWizardPage.this.robotCanvas3D.setJointAngleVector(this.arm.getActualJointsPosition());
        }
    }
}

