/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.geometric.feature;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.lang.URMath;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PlaneTeachModel {
    public static final int MEASUREMENT_COUNT = 3;
    private List<GeomPoseNode> measurementList = new ArrayList<GeomPoseNode>();
    private PlaneTeachInState state = PlaneTeachInState.NOT_ENOUGH_POINTS;
    private GeomPlaneNode planeNode = null;
    private RobotInstallationSite robotInstallationSite;

    public PlaneTeachModel(RobotInstallationSite robotInstallationSite) {
        this.robotInstallationSite = robotInstallationSite;
        int i = 0;
        while (i < 3) {
            this.measurementList.add(null);
            ++i;
        }
    }

    public void setMeasurement(int index, GeomPoseNode measurement) {
        this.measurementList.set(index, measurement);
        if (this.getCompletedMeasurementCount() == 3) {
            this.createPlane();
        }
    }

    public List<GeomPoseNode> getMeasurementList() {
        return this.measurementList;
    }

    public PlaneTeachInState getState() {
        return this.state;
    }

    public void setState(PlaneTeachInState state) {
        this.state = state;
    }

    public GeomPlaneNode getPlaneNode() {
        return this.planeNode;
    }

    public static String getPlaneTeachInStateString(PlaneTeachInState state, TextResource textResource) {
        switch (state) {
            case OK: {
                return textResource.OK();
            }
            case POINTS_NOT_DIVERSE: {
                return textResource.PointsNotSufficientlyDiverse();
            }
            case NOT_ENOUGH_POINTS: {
                return textResource.MorePointsNeeded();
            }
        }
        return "";
    }

    public int getCompletedMeasurementCount() {
        int count = 0;
        for (GeomPoseNode m : this.measurementList) {
            if (m == null) continue;
            ++count;
        }
        return count;
    }

    public void clear() {
        this.state = PlaneTeachInState.NOT_ENOUGH_POINTS;
        int i = 0;
        while (i < this.measurementList.size()) {
            this.measurementList.set(i, null);
            ++i;
        }
    }

    private void createPlane() {
        this.planeNode = new GeomPlaneNode(this.robotInstallationSite);
        GeomPoseNode child1 = new GeomPoseNode(this.robotInstallationSite);
        GeomPoseNode child2 = new GeomPoseNode(this.robotInstallationSite);
        GeomPoseNode child3 = new GeomPoseNode(this.robotInstallationSite);
        this.setupChildNodeForPlane(this.planeNode, child1, this.measurementList.get(0));
        this.setupChildNodeForPlane(this.planeNode, child2, this.measurementList.get(1));
        this.setupChildNodeForPlane(this.planeNode, child3, this.measurementList.get(2));
    }

    private void setupChildNodeForPlane(GeomPlaneNode planeNode, GeomPoseNode child, GeomPoseNode planeTeachMeasurement) {
        planeNode.add((MutableTreeNode)((Object)child));
        this.setupChildNode(child, planeTeachMeasurement);
    }

    private void setupChildNode(GeomPoseNode child, GeomPoseNode planeTeachMeasurement) {
        child.setJoggableEnabled(false);
        child.setPosition(planeTeachMeasurement.getJointPositionVector(), planeTeachMeasurement.getPose());
        child.setTcpOffset(planeTeachMeasurement.getTcpOffset());
        child.setHiddenSubFeature(true);
    }

    public GeomPlaneNode createPlaneWithCalculatedPoints() {
        GeomPlaneNode node = new GeomPlaneNode(this.robotInstallationSite);
        GeomPoseNode child1 = new GeomPoseNode(this.robotInstallationSite);
        GeomPoseNode child2 = new GeomPoseNode(this.robotInstallationSite);
        GeomPoseNode child3 = new GeomPoseNode(this.robotInstallationSite);
        this.setupChildNodeForPlane(node, child1, this.measurementList.get(0));
        this.setupChildNodeForPlane(node, child2, this.measurementList.get(1));
        this.setupChildNodeForPlane(node, child3, this.measurementList.get(2));
        node.setHasUserPoints(true);
        node.setUserPoints(this.measurementList);
        this.calculatePoints(child1, child2, child3);
        return node;
    }

    public List<GeomPoseNode> getUserPoints() {
        return this.measurementList;
    }

    public List<GeomPoseNode> getCalculatedPoints() {
        ArrayList<GeomPoseNode> calculatedPoints = new ArrayList<GeomPoseNode>();
        GeomPoseNode child1 = new GeomPoseNode(this.robotInstallationSite);
        GeomPoseNode child2 = new GeomPoseNode(this.robotInstallationSite);
        GeomPoseNode child3 = new GeomPoseNode(this.robotInstallationSite);
        this.setupChildNode(child1, this.measurementList.get(0));
        this.setupChildNode(child2, this.measurementList.get(1));
        this.setupChildNode(child3, this.measurementList.get(2));
        this.calculatePoints(child1, child2, child3);
        calculatedPoints.add(child1);
        calculatedPoints.add(child2);
        calculatedPoints.add(child3);
        return calculatedPoints;
    }

    private void calculatePoints(GeomPoseNode child1, GeomPoseNode child2, GeomPoseNode child3) {
        Vector3d p0 = child1.getPose().getPos();
        Vector3d p1 = child2.getPose().getPos();
        Vector3d p2 = child3.getPose().getPos();
        Vector3d a = new Vector3d(p1.x - p0.x, p1.y - p0.y, p1.z - p0.z);
        a.normalize();
        Vector3d b = new Vector3d(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        b.normalize();
        Vector3d newZAxis = new Vector3d();
        newZAxis.cross(a, b);
        newZAxis.normalize();
        Vector3d newYAxis = new Vector3d();
        newYAxis.cross(newZAxis, a);
        newYAxis.normalize();
        Vector3d newXAxis = a;
        Matrix3d m = new Matrix3d();
        m.setColumn(0, newXAxis);
        m.setColumn(1, newYAxis);
        m.setColumn(2, newZAxis);
        m.normalize();
        Vector3d rotationVector = URMath.getRotationVector((Matrix3d)m);
        Point3d toolRotation = new Point3d((Tuple3d)rotationVector);
        Point3d child1Position = new Point3d((Tuple3d)child1.getPose().getPos());
        child1.setPosition(child1.getJointPositionVector(), child1Position, toolRotation);
        Point3d child2Position = new Point3d(child1Position.x + newYAxis.x, child1Position.y + newYAxis.y, child1Position.z + newYAxis.z);
        child2.setPosition(child2.getJointPositionVector(), child2Position, new Point3d((Tuple3d)child1.getPose().getRot()));
    }

    public static enum PlaneTeachInState {
        NOT_ENOUGH_POINTS,
        POINTS_NOT_DIVERSE,
        OK;

    }
}

