/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.geometric.feature;

import com.ur.i18n.TextResource;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.move.legacy.MoveRequester;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.viewfacade.move.wizard.SelectPoseWizardPage;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.resources.ButtonImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.wizard.AbstractWizardPage;
import com.ur.swing.wizard.ButtonEvent;
import com.ur.view.geometric.feature.PlaneTeachModel;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlaneTeachSelectPoseWizardPage
extends SelectPoseWizardPage {
    private PlaneTeachModel planeTeachModel;
    private int pointIndex;
    private JLabel stateLabel;
    private RobotInstallationSite robotInstallationSite;

    public PlaneTeachSelectPoseWizardPage(String title, ViewContext viewContext, VisualizerFactory visualizerFactory, Component robotCanvas3D, PlaneTeachModel planeTeachModel, String description, Icon illustrationIcon, int pointIndex, CardPanel cardPanel, PositionRequester positionRequester, MoveRequester moveRequester, RobotInstallationSite robotInstallationSite) {
        super(title, viewContext, visualizerFactory, robotCanvas3D, description, illustrationIcon, cardPanel, positionRequester, moveRequester);
        this.planeTeachModel = planeTeachModel;
        this.pointIndex = pointIndex;
        this.robotInstallationSite = robotInstallationSite;
    }

    protected JComponent createTopComponent() {
        JPanel panel = new JPanel();
        this.stateLabel = new JLabel(PlaneTeachModel.PlaneTeachInState.NOT_ENOUGH_POINTS.toString(), ButtonImageResource.redLed(), 0);
        this.stateLabel.setFont(new Font(this.stateLabel.getFont().getName(), 1, this.stateLabel.getFont().getSize()));
        panel.add(this.stateLabel);
        panel.setAlignmentX(0.5f);
        return panel;
    }

    protected void calculatePlaneTeachInState() {
        int numberOfCompletedMeasurements = this.planeTeachModel.getCompletedMeasurementCount();
        if (numberOfCompletedMeasurements == this.planeTeachModel.getMeasurementList().size()) {
            GeomPlaneNode planeNode = this.planeTeachModel.getPlaneNode();
            if (planeNode.arePointsTooClose() || planeNode.arePointsOnALine()) {
                this.planeTeachModel.setState(PlaneTeachModel.PlaneTeachInState.POINTS_NOT_DIVERSE);
            } else {
                this.planeTeachModel.setState(PlaneTeachModel.PlaneTeachInState.OK);
            }
        }
    }

    protected void setPoseAndJointPositionVector(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
        super.setPoseAndJointPositionVector(pose, jointPositionVector, tcpOffset);
        this.planeTeachModel.setMeasurement(this.pointIndex, this.createPoseNode(pose, jointPositionVector, tcpOffset));
        this.calculatePlaneTeachInState();
    }

    public void enter(Object o) {
        GeomPoseNode poseNode = this.planeTeachModel.getMeasurementList().get(this.pointIndex);
        if (poseNode != null) {
            super.setPoseAndJointPositionVector(poseNode.getPose(), poseNode.getJointPositionVector(), poseNode.getTcpOffset());
            this.calculatePlaneTeachInState();
        }
        super.enter(o);
    }

    private GeomPoseNode createPoseNode(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
        GeomPoseNode poseNode = new GeomPoseNode(this.robotInstallationSite);
        poseNode.setJoggableEnabled(false);
        poseNode.setPosition(jointPositionVector, pose);
        poseNode.setTcpOffset(tcpOffset);
        return poseNode;
    }

    private static Icon getIconForState(PlaneTeachModel.PlaneTeachInState state) {
        switch (state) {
            case OK: {
                return ButtonImageResource.greenLed();
            }
            case POINTS_NOT_DIVERSE: {
                return ButtonImageResource.redLed();
            }
            case NOT_ENOUGH_POINTS: {
                return ButtonImageResource.grayLed();
            }
        }
        return ButtonImageResource.grayLed();
    }

    public void setupWizardButtons() {
        super.setupWizardButtons();
        if (this.pointsNotDiverse() && this.isOnFinalPositionPage()) {
            this.fireButtonEvent(ButtonEvent.ButtonEventType.DISABLE_BUTTON, AbstractWizardPage.BUTTON_NEXT);
        }
    }

    private boolean pointsNotDiverse() {
        return this.planeTeachModel.getState() == PlaneTeachModel.PlaneTeachInState.POINTS_NOT_DIVERSE;
    }

    private boolean isOnFinalPositionPage() {
        return this.pointIndex == this.planeTeachModel.getMeasurementList().size() - 1;
    }

    protected void updateComponents() {
        super.updateComponents();
        this.stateLabel.setIcon(PlaneTeachSelectPoseWizardPage.getIconForState(this.planeTeachModel.getState()));
        this.stateLabel.setText(PlaneTeachModel.getPlaneTeachInStateString(this.planeTeachModel.getState(), (TextResource)this.viewContext.getTextResource(TextResource.class)));
    }
}

