/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.geometric.feature;

import com.ur.i18n.TextResource;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.move.legacy.MoveRequester;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.resources.IllustrationImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.wizard.G5WizardCardPanel;
import com.ur.view.geometric.feature.PlaneTeachFinaliseWizardPage;
import com.ur.view.geometric.feature.PlaneTeachModel;
import com.ur.view.geometric.feature.PlaneTeachSelectPoseWizardPage;
import com.ur.view.geometric.feature.PlaneTeachWizardCallback;
import com.ur.view.geometric.feature.TextAndImageWizardPage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.JComponent;

public class PlaneTeachWizardCardPanelImpl
extends G5WizardCardPanel {
    private PlaneTeachWizardCallback callback;
    private PlaneTeachModel planeTeachModel;
    private ConfirmationDialogCreator confirmationDialogCreator;
    private TextResource textResource;

    @Inject
    public PlaneTeachWizardCardPanelImpl(ViewContext viewContext, VisualizerFactory visualizerFactory, PositionRequester positionRequester, MoveRequester moveRequester, RobotInstallationSite robotInstallationSite, @Source(value=Arm.class) Recipe<Arm> armRecipe, ConfirmationDialogCreator confirmationDialogCreator) {
        super(((TextResource)viewContext.getTextResource(TextResource.class)).planeTeachTitle());
        this.confirmationDialogCreator = confirmationDialogCreator;
        this.planeTeachModel = new PlaneTeachModel(robotInstallationSite);
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        ArrayList<Object> pageList = new ArrayList<Object>();
        Component robotCanvas3D = visualizerFactory.createCanvas();
        visualizerFactory.setDebugName(robotCanvas3D, "G5 Plane Teach 3D Canvas");
        pageList.add((Object)new TextAndImageWizardPage(this.textResource.planeTeachIntroTitle(), this.textResource.planeTeachIntroDescription(), IllustrationImageResource.teachPlaneAll()));
        pageList.add((Object)new PlaneTeachSelectPoseWizardPage(this.textResource.planeTeachFirstPointTitle(), viewContext, visualizerFactory, robotCanvas3D, this.planeTeachModel, this.textResource.planeTeachFirstPointDescription(), IllustrationImageResource.teachPlane1(), 0, (CardPanel)this, positionRequester, moveRequester, robotInstallationSite));
        pageList.add((Object)new PlaneTeachSelectPoseWizardPage(this.textResource.planeTeachSecondPointTitle(), viewContext, visualizerFactory, robotCanvas3D, this.planeTeachModel, this.textResource.planeTeachSecondPointDescription(), IllustrationImageResource.teachPlane2(), 1, (CardPanel)this, positionRequester, moveRequester, robotInstallationSite));
        pageList.add((Object)new PlaneTeachSelectPoseWizardPage(this.textResource.planeTeachThirdPointTitle(), viewContext, visualizerFactory, robotCanvas3D, this.planeTeachModel, this.textResource.planeTeachThirdPointDescription(), IllustrationImageResource.teachPlane3(), 2, (CardPanel)this, positionRequester, moveRequester, robotInstallationSite));
        pageList.add((Object)new PlaneTeachFinaliseWizardPage(this.textResource.planeTeachFinalise(), this.planeTeachModel, visualizerFactory, armRecipe));
        this.addDummyIconsToPages(pageList);
        this.setPageList(pageList);
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:installation_features_add_plane_wizard");
    }

    public void enter(Object o) {
        if (o instanceof PlaneTeachWizardCallback) {
            if (((PlaneTeachWizardCallback)o).isEdited()) {
                ConfirmationMessage warning = new ConfirmationMessage(this.textResource.planeTeachWarningHeadline(), this.textResource.planeTeachWarningText(), this.textResource.OK(), this.textResource.CANCEL());
                this.confirmationDialogCreator.showConfirmationDialog(warning, new ConfirmationDialogListener(){

                    public void onOkClicked() {
                    }

                    public void onCancelClicked() {
                        PlaneTeachWizardCardPanelImpl.this.getCancelButton().doClick();
                    }
                });
            }
            this.callback = (PlaneTeachWizardCallback)o;
            int i = 0;
            while (i < this.callback.getInitialUserPoints().size()) {
                this.planeTeachModel.setMeasurement(i, this.callback.getInitialUserPoints().get(i));
                ++i;
            }
        }
    }

    protected void completedActionPerformed() {
        this.planeTeachModel.clear();
        super.completedActionPerformed();
    }

    protected void finishActionPerformed(ActionEvent e) {
        if (this.callback != null) {
            this.callback.onOk(this.planeTeachModel.getUserPoints(), this.planeTeachModel.getCalculatedPoints());
        }
        super.finishActionPerformed(e);
    }

    protected void cancelActionPerformed(ActionEvent e) {
        if (this.callback != null) {
            this.callback.onCancel();
        }
        super.cancelActionPerformed(e);
    }
}

