/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui;

import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public final class ExtensionPointUtil {
    private ExtensionPointUtil() {
    }

    public static <T> Set<T> reduce(Set<T> toReduce) {
        HashSet<T> results = new HashSet<T>();
        for (T each : toReduce) {
            if (each.getClass().getAnnotation(Extension.class) != null) continue;
            results.add(each);
        }
        return results;
    }

    public static <T> Set<T> reduce(String extensionPointName, Set<T> toReduce) {
        HashSet<T> results = new HashSet<T>();
        for (T each : toReduce) {
            if (each.getClass().getAnnotation(Extension.class) == null || !extensionPointName.equalsIgnoreCase(each.getClass().getAnnotation(Extension.class).value())) continue;
            results.add(each);
        }
        return results;
    }

    public static Collection<MenuExtension> fetchCategorySorted(String category, Set<MenuExtension> toReduceAndSortByPriority) {
        ArrayList<MenuExtension> withCategory = new ArrayList<MenuExtension>(CollectionUtils.filter(toReduceAndSortByPriority, (Predicate)new WithCategory(category)));
        Collections.sort(withCategory, new ByOrdinal());
        return withCategory;
    }

    private static class ByOrdinal
    implements Comparator<MenuExtension> {
        private ByOrdinal() {
        }

        @Override
        public int compare(MenuExtension o1, MenuExtension o2) {
            MenuExtension.MenuContribution first = o1.create();
            MenuExtension.MenuContribution second = o2.create();
            return first.getPriority() - second.getPriority();
        }
    }

    private static class WithCategory
    implements Predicate<MenuExtension> {
        private String category;

        public WithCategory(String category) {
            this.category = category;
        }

        public boolean test(MenuExtension o) {
            return this.category.equalsIgnoreCase(o.create().getCategory());
        }
    }
}

