/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.rendering;

import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.swing.SwingUtil;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramRootNode;
import javax.inject.Singleton;
import javax.swing.tree.TreeNode;

@Singleton
public class ProgramTreeReRenderer
implements Runnable {
    private ProgramLookupService programLookupService;

    public ProgramTreeReRenderer(ProgramLookupService programLookupService) {
        this.programLookupService = programLookupService;
    }

    @Override
    public void run() {
        if (SwingUtil.isUiOrEventThread()) {
            this.reRender();
        } else {
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgramTreeReRenderer.this.reRender();
                }
            });
        }
    }

    private void reRender() {
        ProgramRootNode program = this.programLookupService.getProgramRootNode();
        if (program != null) {
            ProgramModel programTreeModel = program.getProgramTreeModel();
            programTreeModel.nodeChanged((TreeNode)programTreeModel.getRoot());
        }
    }
}

