/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.tables;

import com.ur.i18n.TextResource;
import com.ur.view.variables.core.InstallationVariable;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;

public class InstallationVariablesTableModel
extends AbstractTableModel {
    private Collection<InstallationVariable> variables;
    private final String[] columnNames;
    private TextResource textResource;

    public InstallationVariablesTableModel(Collection<InstallationVariable> variables, String[] columnNames) {
        this.variables = variables;
        this.columnNames = columnNames;
    }

    public InstallationVariablesTableModel(Collection<InstallationVariable> variables, String[] columnNames, TextResource textResource) {
        this.variables = variables;
        this.columnNames = columnNames;
        this.textResource = textResource;
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        if (this.variables == null) {
            return 0;
        }
        return this.variables.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String retVal;
        if (this.variables.isEmpty()) {
            return null;
        }
        InstallationVariable variable = (InstallationVariable)this.variables.toArray()[row];
        switch (column) {
            case 0: {
                retVal = variable.isFavourite() ? this.textResource.favoriteColumn() : "";
                break;
            }
            case 1: {
                retVal = variable.getName();
                break;
            }
            case 2: {
                retVal = variable.getValue();
                break;
            }
            case 3: {
                retVal = variable.getDescription() != null ? variable.getDescription() : "";
                break;
            }
            default: {
                retVal = null;
            }
        }
        return retVal;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public InstallationVariable getVariableAt(int row) {
        return (InstallationVariable)this.variables.toArray()[row];
    }

    public InstallationVariable getVariableByName(String name) {
        return this.variables.stream().filter(variable -> name.equals(variable.getName())).findFirst().orElse(null);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setName(int rowIndex, String newName) {
        ((InstallationVariable)this.variables.toArray()[rowIndex]).setName(newName);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        super.setValueAt(value, rowIndex, columnIndex);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void removeRow(int selectedIndex) {
        InstallationVariable variable = this.getVariableAt(selectedIndex);
        this.variables.remove(variable);
        this.fireTableRowsDeleted(selectedIndex, selectedIndex);
    }

    public int findRow(InstallationVariable variable) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getVariableAt(i).getName().equals(variable.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setVariables(Collection<InstallationVariable> variables) {
        this.variables = variables;
        this.fireTableDataChanged();
    }
}

