/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.tables;

import com.ur.i18n.TextResource;
import com.ur.swing.expression.Expression;
import com.ur.util.event.EventManager;
import com.ur.view.gui.tables.VariablesTableCollection;
import com.ur.view.variables.core.Variable;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;

public class VariablesSetupTableModel
extends AbstractTableModel {
    private final VariablesTableCollection variablesCollection;
    private String[] columnNames = new String[]{"Name", "Initial Value", "Description"};
    private transient TextResource textResource;

    public VariablesSetupTableModel(Collection<Variable> variables, EventManager eventManager) {
        this.variablesCollection = new VariablesTableCollection(eventManager, variables);
    }

    public VariablesSetupTableModel(Collection<Variable> variables, String[] columnNames, TextResource textResource, EventManager eventManager) {
        this.variablesCollection = new VariablesTableCollection(eventManager, variables);
        this.columnNames = columnNames;
        this.textResource = textResource;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 1: {
                return Expression.class;
            }
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.variablesCollection.getVariables().size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String returnValue;
        if (this.variablesCollection.getVariables().isEmpty()) {
            return null;
        }
        Variable variable = (Variable)this.variablesCollection.getVariables().toArray()[row];
        switch (column) {
            case 0: {
                returnValue = variable.isFavourite() ? this.textResource.favoriteColumn() : "";
                break;
            }
            case 1: {
                returnValue = variable.getName();
                break;
            }
            case 2: {
                returnValue = this.determineExpression(variable);
                break;
            }
            case 3: {
                String description = variable.getDescription();
                returnValue = description == null ? "" : description;
                break;
            }
            default: {
                returnValue = null;
            }
        }
        return returnValue;
    }

    private String determineExpression(Variable variable) {
        String result = "";
        if (variable.hasExpression()) {
            result = String.valueOf(result) + variable.getExpression();
            if (variable.prefersPersistentValue()) {
                result = String.valueOf(result) + ", " + this.textResource.setToValueFromPreviousRunTableField();
            }
        } else if (variable.prefersPersistentValue()) {
            result = String.valueOf(result) + this.textResource.setToValueFromPreviousRunTableField();
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Variable getVariableAt(int row) {
        return (Variable)this.variablesCollection.getVariables().toArray()[row];
    }

    public Variable getVariableByName(String variableName) {
        return (Variable)this.variablesCollection.getVariables().toArray()[this.findRow(variableName)];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void setName(int row, String newName) {
        ((Variable)this.variablesCollection.getVariables().toArray()[row]).setName(newName);
    }

    private int findRow(String variable) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getVariableAt(i).getName().equals(variable)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setVariables(Collection<Variable> variables) {
        this.variablesCollection.setVariables(this, variables);
    }
}

