/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.tables;

import com.ur.view.gui.tables.InstallationVariablesTableModel;
import com.ur.view.gui.tables.VariablesSetupTableModel;
import com.ur.view.gui.tables.VariablesTableModel;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.RowSorter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class VariablesTable
extends JXTable {
    private static final String TABLE_NAME = "VariablesTable.table";
    private List<? extends RowSorter.SortKey> sortKeys;
    private int nameColumnIndex = 1;

    public VariablesTable() {
        this.initTableSettings();
        this.setName(TABLE_NAME);
    }

    public VariablesTable(TableModel tableModel) {
        super(tableModel);
        this.updateNameColumnIndex(tableModel);
        this.initTableSettings();
    }

    private void initTableSettings() {
        this.initLookSettings();
        this.initHeaderSettings();
        this.initGridSettings();
        this.initCellsSettings();
        this.initSelectionSettings();
    }

    private void initLookSettings() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
    }

    private void initHeaderSettings() {
        this.setAutoCreateRowSorter(true);
        this.getTableHeader().setReorderingAllowed(false);
    }

    private void initCellsSettings() {
        this.setDefaultEditor(Object.class, null);
    }

    private void initGridSettings() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    private void initSelectionSettings() {
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setCellSelectionEnabled(false);
        this.setFocusable(false);
        this.setSelectionMode(0);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.isRowSelected(rowIndex)) {
            this.clearSelection();
        } else {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    public Variable getVariableAt(int row) {
        String variableName = (String)this.getValueAt(row, this.nameColumnIndex);
        TableModel tableModel = this.getModel();
        if (tableModel instanceof VariablesSetupTableModel) {
            return ((VariablesSetupTableModel)tableModel).getVariableByName(variableName);
        }
        if (tableModel instanceof VariablesTableModel) {
            return ((VariablesTableModel)tableModel).getVariableByName(variableName);
        }
        return null;
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.updateNameColumnIndex(tableModel);
    }

    private void updateNameColumnIndex(TableModel tableModel) {
        if (tableModel instanceof VariablesTableModel) {
            this.nameColumnIndex = 0;
        }
    }

    public void setColumnWidth(int column, int width) {
        this.getColumnModel().getColumn(column).setMaxWidth(width);
        this.getColumnModel().getColumn(column).setPreferredWidth(width);
    }

    public void setColumnWidthsByPixels(int ... columnWidthsByPixels) {
        int i = 0;
        while (i < columnWidthsByPixels.length) {
            this.setColumnWidth(i, columnWidthsByPixels[i]);
            ++i;
        }
    }

    public void setSortOnColumn(int column, boolean sort) {
        ((DefaultRowSorter)this.getRowSorter()).setSortable(column, sort);
    }

    public void saveSortOrder() {
        this.sortKeys = this.getRowSorter().getSortKeys();
    }

    public void restoreSortOrder() {
        if (this.sortKeys != null) {
            this.getRowSorter().setSortKeys(this.sortKeys);
        }
    }

    public int getRow(InstallationVariable variable) {
        return this.getRowIndexFromName(variable.getName());
    }

    public int getRow(Variable variable) {
        return this.getRowIndexFromName(variable.getName());
    }

    private int getRowIndexFromName(String name) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getValueAt(i, this.nameColumnIndex).equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setRendererOnColumn(int column, TableCellRenderer tableCellRenderer) {
        this.getColumnModel().getColumn(column).setCellRenderer(tableCellRenderer);
    }

    public void initSort(int column) {
        this.getRowSorter().toggleSortOrder(column);
    }

    public InstallationVariable getInstallationVariableAtRow(int row) {
        String variableName = (String)this.getValueAt(row, this.nameColumnIndex);
        TableModel tableModel = this.getModel();
        if (tableModel instanceof InstallationVariablesTableModel) {
            return ((InstallationVariablesTableModel)tableModel).getVariableByName(variableName);
        }
        return null;
    }
}

