/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.tables;

import com.ur.view.gui.tables.AbstractVariablesTableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class VariablesTableHeaderRenderer
extends AbstractVariablesTableRenderer {
    private final JLabel title = new JLabel();
    private final JLabel icon = new JLabel();
    private final Icon ascIcon = UIManager.getIcon("Table.ascendingSortIcon");
    private final Icon descIcon = UIManager.getIcon("Table.descendingSortIcon");
    private final int numberOfColumns;

    public VariablesTableHeaderRenderer(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
        this.title.setFont(AbstractVariablesTableRenderer.headerFont);
        this.setLayout(new BorderLayout());
        this.add((Component)this.title, "West");
        this.add((Component)this.icon, "East");
        this.setBackground(AbstractVariablesTableRenderer.tableHeader);
        this.setPreferredSize(new Dimension(0, 35));
        this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, AbstractVariablesTableRenderer.tableOutline), new EmptyBorder(5, 6, 5, 5)));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        this.title.setText((String)value);
        this.icon.setIcon(this.ascIcon);
        if (this.shouldShowIconInHeader(table, column)) {
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey.getColumn() != table.convertColumnIndexToModel(column)) continue;
                SortOrder o = sortKey.getSortOrder();
                this.icon.setIcon(o == SortOrder.ASCENDING ? this.ascIcon : this.descIcon);
                break;
            }
        }
        return this;
    }

    private boolean shouldShowIconInHeader(JTable table, int column) {
        if (!((DefaultRowSorter)table.getRowSorter()).isSortable(column) || this.numberOfColumns == 4 && column == 0) {
            this.icon.setIcon(null);
            return false;
        }
        return true;
    }
}

