/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.tables;

import com.ur.i18n.TextResource;
import com.ur.util.event.EventManager;
import com.ur.view.gui.tables.VariablesTableCollection;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.VariablesServer;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.Variable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;

public class VariablesTableModel
extends AbstractTableModel {
    private final String[] columnNames;
    private final VariablesServer variablesServer;
    private final VariablesTableCollection variablesCollection;

    public VariablesTableModel(VariablesServer variablesServer, TextResource textResource, EventManager eventManager) {
        this.variablesServer = variablesServer;
        this.variablesCollection = new VariablesTableCollection(eventManager, new ArrayList<Variable>());
        this.columnNames = new String[]{textResource.Name(), textResource.Value(), textResource.Description()};
    }

    @Override
    public int getRowCount() {
        return this.variablesCollection.getVariables().size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String returnValue;
        if (this.variablesCollection.getVariables().isEmpty()) {
            return null;
        }
        Variable variable = (Variable)this.variablesCollection.getVariables().toArray()[rowIndex];
        switch (columnIndex) {
            case 0: {
                returnValue = variable.getName();
                break;
            }
            case 1: {
                returnValue = this.getValueFromVariable(variable);
                break;
            }
            case 2: {
                returnValue = this.getDescriptionFromVariable(variable);
                break;
            }
            default: {
                returnValue = null;
            }
        }
        return returnValue;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    private String getValueFromVariable(Variable variable) {
        String value = this.variablesServer.getValue(variable.getScriptName());
        return value != null ? value : "";
    }

    private String getDescriptionFromVariable(Variable variable) {
        InstallationVariable installationVariable;
        String description = variable instanceof InstallationVariableReference ? ((installationVariable = ((InstallationVariableReference)variable).dereference()) != null ? installationVariable.getDescription() : "") : variable.getDescription();
        return description != null ? description : "";
    }

    public void setVariables(Collection<Variable> variables) {
        this.variablesCollection.setVariables(this, variables);
    }

    public void forceSetVariables(Collection<Variable> variables) {
        this.variablesCollection.forceSetVariables(this, variables);
    }

    public Variable getVariableByName(String variableName) {
        return (Variable)this.variablesCollection.getVariables().toArray()[this.findRow(variableName)];
    }

    private Variable getVariableAt(int row) {
        return (Variable)this.variablesCollection.getVariables().toArray()[row];
    }

    private int findRow(String variable) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getVariableAt(i).getName().equals(variable)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

