/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.tables;

import com.ur.resources.ButtonImageResource;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.view.gui.tables.VariablesTable;
import com.ur.view.gui.tables.VariablesTableCellRenderer;
import com.ur.view.gui.tables.VariablesTableHeaderRenderer;
import com.ur.view.gui.tables.WrapTextColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXButton;

public final class VariablesTablePanel
extends JPanel {
    private static final Icon collapseIcon = ButtonImageResource.CollapseTable();
    private static final Icon expandIcon = ButtonImageResource.ExpandTable();
    private final VariablesTable variablesTable;
    private TableColumn descriptionColumn;
    private JXButton columnControlButton;
    private int[] columnSizes;
    private boolean collapsed;
    private boolean firstPress = true;
    private JScrollPane scrollPane;

    private VariablesTablePanel(VariablesTable variablesTable, int numberOfColumns) {
        this.variablesTable = variablesTable;
        this.setLayout(new BorderLayout());
        this.configureTable(numberOfColumns);
        this.add((Component)this.configureScrollPane(), "Center");
    }

    public static VariablesTablePanel createTableWithThreeColumns(VariablesTable variablesTable) {
        return new VariablesTablePanel(variablesTable, 3);
    }

    public static VariablesTablePanel createTableWithFourColumns(VariablesTable variablesTable) {
        return new VariablesTablePanel(variablesTable, 4);
    }

    private void configureTable(int numberOfColumns) {
        new URFingerDragScrollMouseListener((Component)((Object)this.variablesTable));
        this.variablesTable.getTableHeader().setDefaultRenderer(new VariablesTableHeaderRenderer(numberOfColumns));
        this.variablesTable.setRendererOnColumn(0, new VariablesTableCellRenderer());
        this.variablesTable.setRendererOnColumn(1, new VariablesTableCellRenderer());
        if (numberOfColumns == 3) {
            this.variablesTable.setSortOnColumn(2, false);
            this.variablesTable.setRendererOnColumn(2, new WrapTextColumnRenderer());
            this.variablesTable.initSort(0);
        } else if (numberOfColumns == 4) {
            this.variablesTable.setSortOnColumn(3, false);
            this.variablesTable.setRendererOnColumn(2, new VariablesTableCellRenderer());
            this.variablesTable.setRendererOnColumn(3, new WrapTextColumnRenderer());
            this.variablesTable.initSort(1);
        }
        this.variablesTable.setFillsViewportHeight(false);
        this.variablesTable.setRowHeight(29);
    }

    private JScrollPane configureScrollPane() {
        this.scrollPane = new JScrollPane((Component)((Object)this.variablesTable));
        this.scrollPane.getViewport().setBackground(G5LookAndFeel.DEFAULT_BACKGROUND);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.scrollPane.getVerticalScrollBar().setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.LIGHT_GRAY));
        return this.scrollPane;
    }

    public void addMouseListenerToScrollPane(MouseListener mouseListener) {
        this.scrollPane.addMouseListener(mouseListener);
    }

    public void addColumnCollapseButton() {
        this.collapsed = false;
        this.descriptionColumn = this.variablesTable.getColumn(this.variablesTable.getColumnCount() - 1);
        this.initControlButton();
        this.columnControlButton.addActionListener(actionEvent -> this.columnControlClicked());
        this.variablesTable.setColumnControl((JComponent)this.columnControlButton);
        this.variablesTable.setColumnControlVisible(true);
    }

    void columnControlClicked() {
        if (this.firstPress) {
            this.collectColumnSizes();
            this.firstPress = false;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.collapsed) {
                this.expandColumns();
            } else {
                this.collapseColumns();
            }
            this.variablesTable.setRowHeight(29);
            this.updateCollapseIcon();
        });
    }

    private void collectColumnSizes() {
        int columnCount = this.variablesTable.getColumnCount();
        this.columnSizes = new int[columnCount];
        int i = 0;
        while (i < columnCount) {
            this.columnSizes[i] = this.variablesTable.getColumn(i).getWidth();
            ++i;
        }
    }

    private void expandColumns() {
        this.variablesTable.addColumn(this.descriptionColumn);
        int columnIndex = this.variablesTable.getColumnCount() - 1;
        this.variablesTable.setSortOnColumn(columnIndex, false);
        this.variablesTable.setRendererOnColumn(columnIndex, new WrapTextColumnRenderer());
        this.setExpandedColumnSizes();
        this.variablesTable.repaint();
        this.variablesTable.revalidate();
        this.collapsed = false;
    }

    private void collapseColumns() {
        this.setCollapsedSizes();
        this.variablesTable.removeColumn(this.descriptionColumn);
        this.variablesTable.repaint();
        this.variablesTable.revalidate();
        this.collapsed = true;
    }

    private void setExpandedColumnSizes() {
        int i = 0;
        while (i < this.columnSizes.length) {
            this.variablesTable.setColumnWidth(i, this.columnSizes[i]);
            ++i;
        }
    }

    private void setCollapsedSizes() {
        int lastColumn = this.variablesTable.getColumnCount() - 1;
        int secondToLastColumn = lastColumn - 1;
        this.variablesTable.setColumnWidth(lastColumn, 0);
        this.variablesTable.setColumnWidth(secondToLastColumn, this.columnSizes[secondToLastColumn] + this.columnSizes[lastColumn]);
    }

    private void updateCollapseIcon() {
        if (this.collapsed) {
            this.columnControlButton.setIcon(expandIcon);
            this.columnControlButton.setBorder((Border)BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        } else {
            this.columnControlButton.setIcon(collapseIcon);
            this.columnControlButton.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 1, 1, Color.LIGHT_GRAY));
        }
    }

    private void initControlButton() {
        this.columnControlButton = new JXButton();
        this.updateCollapseIcon();
        this.columnControlButton.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.columnControlButton.setFocusable(false);
        this.columnControlButton.setFocusPainted(false);
    }
}

