/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.textfield;

import com.ur.lang.StringUtils;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.expression.ExpressionCharNode;
import com.ur.swing.expression.ExpressionNode;
import com.ur.swing.expression.ExpressionTokenNode;
import com.ur.swing.expression.ExpressionValidator;
import com.ur.swing.expression.field.ExpressionEditorJTextField;
import com.ur.swing.expression.field.ExpressionInserter;
import com.ur.view.domain.program.expression.ExpressionGeomFeatureNode;
import com.ur.view.domain.program.expression.ExpressionIONode;
import com.ur.view.domain.program.expression.ExpressionVariableNode;
import com.ur.view.domain.program.expression.ExpressionWaypointNode;
import com.ur.view.variables.core.Variable;
import gui.controllerinterface.DefaultExpressionValidatorImpl;
import gui.program.position.WaypointNode;
import gui.program.services.GeomFeatureVariable;
import gui.program.services.ProgramReferenceService;
import gui.tools.ExpressionFunctionComboBoxContent;
import javax.inject.Inject;

public class ExpressionInserterImpl
implements ExpressionInserter {
    private final ProgramReferenceService programReferenceService;
    private final ExpressionValidator expressionValidator;

    @Inject
    public ExpressionInserterImpl(ProgramReferenceService programReferenceService) {
        this.programReferenceService = programReferenceService;
        this.expressionValidator = new DefaultExpressionValidatorImpl();
    }

    public boolean isValid(String expression) {
        return this.expressionValidator.isValid(expression);
    }

    public void insertObjectOnSelect(ExpressionEditorJTextField textField, Object selected) {
        if (selected instanceof GeomFeature) {
            this.insertVariableGeomFeature(textField, (GeomFeature)selected);
        } else if (selected instanceof Variable) {
            this.insertVariable(textField, (Variable)selected);
        } else if (selected instanceof ExpressionFunctionComboBoxContent.UrCapHeading) {
            this.insertFunction(textField, ((ExpressionFunctionComboBoxContent.UrCapHeading)selected).getTitle());
        } else if (selected instanceof String) {
            this.insertFunction(textField, (String)selected);
        }
    }

    public void insertObjectOnBind(ExpressionEditorJTextField textField, Object selected) {
        if (selected instanceof Pin) {
            this.insertIONode(textField, (Pin)selected);
        } else if (selected instanceof WaypointNode) {
            this.insertWaypoint(textField, (WaypointNode)selected);
        } else if (selected instanceof GeomFeature) {
            this.insertGeomFeature(textField, (GeomFeature)selected);
        } else if (selected instanceof Variable) {
            this.insertVariable(textField, (Variable)selected);
        } else if (selected instanceof ExpressionFunctionComboBoxContent.UrCapHeading) {
            this.insertFunction(textField, ((ExpressionFunctionComboBoxContent.UrCapHeading)selected).getTitle());
        } else if (selected instanceof String) {
            this.insertFunction(textField, (String)selected);
        }
    }

    void insertVariableGeomFeature(ExpressionEditorJTextField textField, GeomFeature geomFeature) {
        textField.removeSelection(textField.getSelectionStart(), textField.getSelectionEnd());
        GeomFeatureVariable variable = this.programReferenceService.getGeomFeatureVariable(geomFeature);
        ExpressionVariableNode variableNode = new ExpressionVariableNode(variable);
        textField.getExpression().insertElementAt((ExpressionNode)variableNode, textField.getSelectionStart());
        textField.moveCaretForward(variableNode.getLength());
    }

    void insertVariable(ExpressionEditorJTextField textField, Variable variable) {
        String text = variable.toString();
        textField.removeSelection(textField.getSelectionStart(), textField.getSelectionEnd());
        textField.getExpression().insertElementAt((ExpressionNode)new ExpressionVariableNode(variable), textField.getSelectionStart());
        textField.moveCaretForward(text.length());
    }

    void insertIONode(ExpressionEditorJTextField textField, Pin<?> pin) {
        textField.removeSelection(textField.getSelectionStart(), textField.getSelectionEnd());
        ExpressionIONode ioNode = new ExpressionIONode(this.programReferenceService.getPinReference(pin));
        textField.getExpression().insertElementAt((ExpressionNode)ioNode, textField.getSelectionStart());
        textField.moveCaretForward(ioNode.getLength());
    }

    void insertWaypoint(ExpressionEditorJTextField textField, WaypointNode waypointNode) {
        String text = waypointNode.getName();
        textField.removeSelection(textField.getSelectionStart(), textField.getSelectionEnd());
        textField.getExpression().insertElementAt((ExpressionNode)new ExpressionWaypointNode(waypointNode), textField.getSelectionStart());
        textField.moveCaretForward(text.length());
    }

    void insertGeomFeature(ExpressionEditorJTextField textField, GeomFeature geomFeature) {
        textField.removeSelection(textField.getSelectionStart(), textField.getSelectionEnd());
        ExpressionGeomFeatureNode featureNode = new ExpressionGeomFeatureNode();
        featureNode.initialSetFeatureReference(this.programReferenceService.getGeomFeatureReference(geomFeature));
        textField.getExpression().insertElementAt((ExpressionNode)featureNode, textField.getSelectionStart());
        textField.moveCaretForward(featureNode.getLength());
    }

    void insertFunction(ExpressionEditorJTextField textField, String function) {
        this.insertToken(textField, function.substring(0, function.indexOf(40)));
        textField.insertText("(");
        boolean insertComma = false;
        String[] stringArray = function.substring(function.indexOf(40) + 1, function.indexOf(41)).split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            if (insertComma) {
                textField.insertText(", ");
            }
            if (!StringUtils.isNullOrOnlyWhitespace((String)each)) {
                this.insertToken(textField, each.trim());
                insertComma = true;
            }
            ++n2;
        }
        textField.insertText(")");
    }

    public void insertToken(ExpressionEditorJTextField textField, String text) {
        textField.removeSelection(textField.getSelectionStart(), textField.getSelectionEnd());
        textField.getExpression().insertElementAt((ExpressionNode)new ExpressionTokenNode(text), textField.getSelectionStart());
        textField.moveCaretForward(text.length());
    }

    public void insertSpecialChar(ExpressionEditorJTextField textField, char c) {
        textField.removeSelection(textField.getSelectionStart(), textField.getSelectionEnd());
        textField.getExpression().insertElementAt((ExpressionNode)new ExpressionCharNode(c), textField.getSelectionStart());
        textField.getSelectionStart();
        textField.setText(textField.generateText());
    }
}

