/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.gui.threading;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MinimumDelayBetweenRunsExecutor {
    private final Runnable runnable;
    private final ScheduledExecutorService scheduledExecutorService;
    private long lastScheduledRun = 0L;
    private ScheduledFuture<?> latestScheduled;

    public MinimumDelayBetweenRunsExecutor(Runnable runnable) {
        this.runnable = runnable;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public synchronized void run(long minimumDelay, boolean ignoreIfAlreadyQueued) {
        if (ignoreIfAlreadyQueued && this.latestScheduled != null && !this.latestScheduled.isDone()) {
            return;
        }
        long now = System.currentTimeMillis();
        long delay = Math.max(0L, this.lastScheduledRun + minimumDelay - now);
        this.lastScheduledRun = now + delay;
        this.latestScheduled = this.scheduledExecutorService.schedule(this.runnable, delay, TimeUnit.MILLISECONDS);
    }
}

