/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.help;

import com.ur.i18n.TextResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.util.event.EventManager;
import com.ur.view.help.HelpListener;
import com.ur.view.help.HelpManager;
import java.awt.event.ActionEvent;
import javax.inject.Inject;

public class HelpAction
extends AbstractActionDefinition {
    private final HelpManager help;

    @Inject
    public HelpAction(EventManager manager, TextResource text, HelpManager help) {
        this.help = help;
        this.putValue("SmallIcon", ViewImageResource.helpWhite());
        this.putValue("SelectedSmallIcon", ViewImageResource.helpBlack());
        this.putValue("Name", text.tabHelp());
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        manager.addStrongListener(HelpListener.class, (Object)new HelpListener(){

            @Override
            public void helpShowing(boolean showingState) {
                HelpAction.this.setEnabled(!showingState);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        this.help.setHelpActivated(true);
    }
}

