/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.help;

import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.swing.CardPanel;
import com.ur.swing.g5.GlassPaneHeaderToolBar;
import com.ur.swing.help.HelpIconListener;
import com.ur.util.logging.Log;
import com.ur.view.Settings;
import com.ur.view.help.HelpPane;
import com.ur.view.help.HelpPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.media.j3d.Canvas3D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class HelpLoader {
    private static final boolean DISABLE_HELP = false;
    private static JFrame currentWindow;
    private static final JLabel helpButton;
    private static Component oldGlassPane;
    private static HelpPane helpGlassPaneOverlay;
    private static final HashMap<Component, String> componentsToIds;
    private static Map<Rectangle, Component> showingComponents;
    private static CardPanel helpScreen;
    private static ArrayList<Component> visibleCanvas;
    private static final List<HelpIconListener> helpIconListeners;
    private static RobotConfigurationProvider robot;
    private static RobotInstallationSite robotInstallationSite;

    static {
        helpButton = new JLabel("Dummy");
        componentsToIds = new HashMap();
        showingComponents = new HashMap<Rectangle, Component>();
        helpScreen = null;
        visibleCanvas = null;
        helpIconListeners = new ArrayList<HelpIconListener>();
    }

    @Inject
    public static void setConfigurationProvider(RobotConfigurationProvider robot, RobotInstallationSite robotInstallationSite) {
        HelpLoader.robot = robot;
        HelpLoader.robotInstallationSite = robotInstallationSite;
    }

    public static void setVersionSite() {
        helpGlassPaneOverlay = new HelpPane();
        visibleCanvas = new ArrayList();
    }

    public static void setHelpScreen(HelpPanel helpPanel) {
        helpScreen = helpPanel.getHelpCardPanel();
    }

    public static boolean isHelpIconsShowing() {
        if (helpScreen == null) {
            return true;
        }
        return helpGlassPaneOverlay.isHelpIconsShowing();
    }

    public static void setOverlaidHelpPainFor(JFrame window) {
        HelpLoader.setNewGlassOverlaidOnWindow(window);
        GlassPaneHeaderToolBar.addToToolBar((JComponent)helpButton);
        helpGlassPaneOverlay.setVisible(true);
    }

    public static void assignHelpId(JComponent comp, String id) {
    }

    static void loadHelpSetAccordingToRobotConfiguration() {
    }

    public static void updatePairInHelpMap(JComponent oldComp, JComponent newComp, String id) {
    }

    public static void setHelpActivated(boolean activated) {
        if (activated) {
            HelpLoader.prepareToHelp();
        }
    }

    protected static String getPathToHelp(boolean loadDefault) {
        String euromapAppend = HelpLoader.getEuromapAppend(loadDefault);
        String robotTypeAppend = HelpLoader.getRobotTypeAppend(loadDefault);
        String combinationAppend = String.valueOf(robotTypeAppend) + euromapAppend + Settings.getLanguage().getHelpRegionName();
        return "/help/Combination" + combinationAppend + "/help" + Settings.getLanguage().getHelpLanguageName() + combinationAppend + ".hs";
    }

    protected static String getEuromapAppend(boolean loadDefault) {
        String euromapAppend = loadDefault ? "_E67OFF" : (((Immi)robotInstallationSite.getInstallation().getComponent(Immi.class)).isEnabled() ? "_E67ON" : "_E67OFF");
        return euromapAppend;
    }

    protected static String getRobotTypeAppend(boolean loadDefault) {
        String robotTypeAppend = loadDefault ? "UR5" : robot.getRobotID().getTypeAsString();
        return "_" + robotTypeAppend + "e";
    }

    protected static void clickAtPoint(Point point) {
        HelpLoader.reenableCanvas3DComponents();
        Component component = HelpLoader.findComponentInWindow(point);
        if (component != null) {
            if (componentsToIds.containsKey(component)) {
                String messageId = componentsToIds.get(component);
                Point posComponent = component.getLocationOnScreen();
                Point posWindow = currentWindow.getContentPane().getLocationOnScreen();
                currentWindow.setGlassPane(oldGlassPane);
                posComponent.x -= posWindow.x;
                posComponent.y -= posWindow.y;
                if (helpScreen != null) {
                    helpScreen.stackCurrentCardAndSwitchTo(helpScreen.getClass(), (Object)messageId);
                } else {
                    HelpLoader.setHelpButtonVisible(true);
                }
            } else {
                Log.error((String)("Found no mapping for component: " + component));
                HelpLoader.setHelpButtonVisible(true);
            }
        } else {
            HelpLoader.setHelpButtonVisible(true);
            Log.error((String)("No component found at clicked point: " + point));
        }
        currentWindow.setGlassPane(helpGlassPaneOverlay);
    }

    public static void resetHelp() {
        helpGlassPaneOverlay.releaseMouseInput();
        currentWindow.setGlassPane(helpGlassPaneOverlay);
        HelpLoader.reenableCanvas3DComponents();
        HelpLoader.setHelpButtonVisible(true);
    }

    private static Component findComponentInWindow(Point point) {
        Component component = HelpLoader.findCompAt(point, currentWindow.getContentPane());
        if (component == null) {
            component = HelpLoader.findCompAt(point, (Container)currentWindow.getGlassPane());
        }
        return component;
    }

    private static Component findCompAt(Point point, Container container) {
        point.x -= container.getX();
        point.y -= container.getY();
        ArrayList<Rectangle> hitSpaces = new ArrayList<Rectangle>(showingComponents.keySet());
        Collections.sort(hitSpaces, new SortRectanglesByWidthComparator());
        for (Rectangle each : hitSpaces) {
            if (!each.contains(point)) continue;
            return showingComponents.get(each);
        }
        return null;
    }

    public static void setHelpButtonVisible(boolean visible) {
        helpButton.setVisible(visible);
        helpButton.setEnabled(visible);
    }

    private static void prepareToHelp() {
        helpScreen.stackCurrentCardAndSwitchTo(helpScreen.getClass(), (Object)"Help Panel");
        HelpLoader.setHelpButtonEnabled(false);
    }

    private static void setHelpButtonEnabled(boolean enable) {
        helpButton.setEnabled(enable);
    }

    private static void reenableCanvas3DComponents() {
        for (Component canvas : visibleCanvas) {
            if (!(canvas instanceof Canvas3D)) continue;
            ((Canvas3D)canvas).setVisible(true);
        }
        visibleCanvas.clear();
    }

    private static void setNewGlassOverlaidOnWindow(JFrame window) {
        currentWindow = window;
        oldGlassPane = currentWindow.getGlassPane();
        currentWindow.setGlassPane(helpGlassPaneOverlay);
    }

    public static void addIconClickedListener(HelpIconListener helpIconListener) {
        helpIconListeners.add(helpIconListener);
    }

    public static boolean removeIconClickedListener(HelpIconListener helpIconListener) {
        return helpIconListeners.remove(helpIconListener);
    }

    private static final class SortRectanglesByWidthComparator
    implements Comparator<Rectangle> {
        private SortRectanglesByWidthComparator() {
        }

        @Override
        public int compare(Rectangle o1, Rectangle o2) {
            int width = (int)(o1.getWidth() - o2.getWidth());
            if (width == 0) {
                return (int)(o1.getHeight() - o2.getHeight());
            }
            return width;
        }
    }
}

