/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.help;

import com.ur.view.help.HelpLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

class HelpPane
extends JPanel {
    Color colorQuestionMark = new Color(1.0f, 0.0f, 0.0f, 0.8f);
    Color colorFrame = new Color(0.0f, 0.0f, 1.0f, 0.7f);
    BasicStroke frameStroke = new BasicStroke(10.0f);
    private List<Rectangle> buttonRects = new ArrayList<Rectangle>();
    private List<Rectangle> squareRects = new ArrayList<Rectangle>();
    private boolean drawTheButtons;
    int insX;
    int insY;
    private HelpMouseListener helpMouseListener;
    public boolean drawHelpSurroundings = false;

    public HelpPane() {
        this.initializeComponent();
    }

    public boolean isHelpIconsShowing() {
        return this.drawTheButtons;
    }

    private void initializeComponent() {
        this.setOpaque(false);
        this.helpMouseListener = new HelpMouseListener();
        this.setLayout(null);
    }

    private void drawComponentsWithHelpIds(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(Font.decode("DejaVu-bold-48"));
        g2.setColor(this.colorQuestionMark);
        for (Rectangle rect : this.buttonRects) {
            g2.drawString("?", rect.x + rect.width / 2 - 5, rect.y + rect.height / 2 + 18);
        }
        g2.setColor(this.colorFrame);
        g2.setStroke(this.frameStroke);
        double rectSizeThreshold = 50.0;
        for (Rectangle rect : this.squareRects) {
            if (rect.getHeight() > rectSizeThreshold && rect.getWidth() > rectSizeThreshold) {
                g2.drawRect(rect.x, rect.y, rect.width, rect.height);
                continue;
            }
            if (!(rect.getHeight() < rectSizeThreshold) || rect.getWidth() < rectSizeThreshold) continue;
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawRect(rect.x, rect.y, rect.width, rect.height);
            g2.setStroke(this.frameStroke);
        }
    }

    public void drawQuestionMark(Rectangle bounds) {
        this.buttonRects.add(bounds);
        this.repaint();
    }

    public void drawSquare(Rectangle bounds) {
        this.squareRects.add(bounds);
        this.repaint();
    }

    public void setDrawAroundHelpWindow(boolean val) {
        this.drawHelpSurroundings = val;
        this.repaint();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.drawTheButtons) {
            this.drawComponentsWithHelpIds(g);
        }
    }

    public void releaseMouseInput() {
        this.removeMouseListener(this.helpMouseListener);
        this.drawTheButtons = false;
        this.setCursor(null);
    }

    public void resetSquares() {
        this.buttonRects.clear();
        this.squareRects.clear();
    }

    public void takeMouseInput() {
        this.addMouseListener(this.helpMouseListener);
        this.drawTheButtons = true;
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private class HelpMouseListener
    extends MouseAdapter {
        private HelpMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            HelpLoader.clickAtPoint(e.getPoint());
            HelpPane.this.releaseMouseInput();
        }
    }
}

