/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.help;

import com.ur.i18n.TextResource;
import com.ur.polyscope.core.api.annotation.NoControlButtonVisibilityChange;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.version.urversion.URVersionProvider;
import com.ur.swing.CardPanel;
import com.ur.swing.qrcode.QRCodeGenerator;
import com.ur.util.event.EventManager;
import com.ur.view.Settings;
import com.ur.view.help.HelpListener;
import com.ur.view.help.HelpLoader;
import com.ur.view.help.HelpPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

@NoControlButtonVisibilityChange
public class QRHelpPanel
extends CardPanel
implements HelpPanel {
    private static final String QR_HELP_URL = "https://www.universal-robots.com/gethelp/?version=%s&robottype=%s&language=%s&serialnumber=%s";
    private static final String QR_DIRECT_URL = "https://www.universal-robots.com/help";
    private final RobotConfigurationProvider robotConfigurationProvider;
    private final URVersionProvider urVersionProvider;
    private final TextResource textResource;
    private final EventManager eventManager;
    private final RobotIdentification robotIdentification;
    private JLabel imageLabel;

    @Inject
    public QRHelpPanel(RobotConfigurationProvider robotConfigurationProvider, URVersionProvider urVersionProvider, TextResource textResource, EventManager eventManager, RobotIdentification robotIdentification) {
        this.robotConfigurationProvider = robotConfigurationProvider;
        this.urVersionProvider = urVersionProvider;
        this.textResource = textResource;
        this.eventManager = eventManager;
        this.robotIdentification = robotIdentification;
        this.initComponents();
    }

    private void initComponents() {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 3));
        innerPanel.setBorder(new LineBorder(new Color(86, 160, 211), 5));
        innerPanel.add(Box.createVerticalStrut(20));
        innerPanel.add(this.createHeaderPanel());
        innerPanel.add(Box.createVerticalStrut(20));
        innerPanel.add(this.createCenterPanel());
        innerPanel.add(this.createButtonPanel());
        innerPanel.add(Box.createVerticalStrut(20));
        this.setLayout(new BorderLayout());
        this.setBorder(new LineBorder(new Color(230, 230, 230), 40));
        this.add(innerPanel, "Center");
    }

    private JPanel createButtonPanel() {
        JPanel footerPanel = new JPanel();
        footerPanel.setLayout(new BoxLayout(footerPanel, 2));
        JButton exitButton = new JButton(this.textResource.Close());
        exitButton.setName("QRCodeExit");
        exitButton.addActionListener(new NavigateBackAction());
        exitButton.setPreferredSize(new Dimension(200, 40));
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(exitButton);
        footerPanel.add(Box.createHorizontalStrut(20));
        return footerPanel;
    }

    private JPanel createCenterPanel() {
        JPanel centerPanel = new JPanel(new GridLayout(1, 2));
        centerPanel.setLayout(new BoxLayout(centerPanel, 2));
        JPanel infoPanel = this.createInfoPanel();
        centerPanel.add(Box.createGlue());
        centerPanel.add(this.createQrPanel());
        centerPanel.add(Box.createGlue());
        centerPanel.add(new JSeparator(1));
        centerPanel.add(Box.createGlue());
        centerPanel.add(infoPanel);
        centerPanel.add(Box.createGlue());
        return centerPanel;
    }

    private JPanel createQrPanel() {
        JPanel qrCodePanel = new JPanel();
        qrCodePanel.setLayout(new BoxLayout(qrCodePanel, 3));
        qrCodePanel.setAlignmentX(0.5f);
        this.imageLabel = new JLabel();
        this.imageLabel.setAlignmentX(0.5f);
        qrCodePanel.add(this.imageLabel);
        JLabel scanLabel = new JLabel(this.textResource.scanQrCode());
        scanLabel.setFont(scanLabel.getFont().deriveFont(30.0f).deriveFont(1));
        scanLabel.setAlignmentX(0.5f);
        qrCodePanel.add(scanLabel);
        return qrCodePanel;
    }

    private JPanel createHeaderPanel() {
        JLabel headerLabel = new JLabel(this.textResource.tabHelp());
        headerLabel.setFont(headerLabel.getFont().deriveFont(1).deriveFont(50.0f));
        JPanel headerPanel = new JPanel(new FlowLayout());
        headerPanel.add(headerLabel);
        return headerPanel;
    }

    private JPanel createInfoPanel() {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        infoPanel.setAlignmentX(0.5f);
        this.addSentInformationText(infoPanel);
        this.addQRAlternativeText(infoPanel);
        return infoPanel;
    }

    private void addSentInformationText(JPanel infoPanel) {
        infoPanel.add(Box.createVerticalStrut(40));
        infoPanel.add(this.buildOneColumnJPanel(this.buildJTextAreaWithLineWrap(this.textResource.followingInformationSent(), 18.0f, 1)));
        this.addSentInfoRow(infoPanel, this.textResource.softwareVersionColon(), this.getSoftwareVersion());
        this.addSentInfoRow(infoPanel, this.textResource.robotTypeColon(), this.getRobotType());
        this.addSentInfoRow(infoPanel, this.textResource.languageColon(), Settings.getLanguage().toString());
        this.addSentInfoRow(infoPanel, this.textResource.serialnumberColon(), this.getSerialNumber());
    }

    private void addSentInfoRow(JPanel infoPanel, String label, String content) {
        infoPanel.add(Box.createVerticalStrut(5));
        infoPanel.add(this.buildTwoColumJPanel(this.buildJLabelWithSpecifiedSize(label, 16.0f, 1), this.buildJLabelWithSpecifiedSize(content, 16.0f, 0)));
    }

    private void addQRAlternativeText(JPanel infoPanel) {
        infoPanel.add(Box.createVerticalStrut(30));
        infoPanel.add(this.buildOneColumnJPanel(this.buildOneColumnJPanel(this.buildJLabelWithSpecifiedSize(this.textResource.qrAlternateOption(), 16.0f, 1))));
        infoPanel.add(Box.createVerticalStrut(5));
        infoPanel.add(this.buildOneColumnJPanel(this.buildJLabelWithSpecifiedSize(QR_DIRECT_URL, 16.0f, 0)));
        infoPanel.add(new Box.Filler(new Dimension(620, 10), new Dimension(620, 200), new Dimension(620, 250)));
    }

    private JPanel buildOneColumnJPanel(JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.5f);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(jComponent);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel buildTwoColumJPanel(JComponent leftComponent, JComponent rightComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.5f);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(leftComponent);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(rightComponent);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JTextArea buildJTextAreaWithLineWrap(String text, float fontSize, int fontType) {
        JTextArea jTextArea = new JTextArea(text);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(jTextArea.getFont().deriveFont(fontSize).deriveFont(fontType));
        jTextArea.setMaximumSize(new Dimension(640, 100));
        return jTextArea;
    }

    private JLabel buildJLabelWithSpecifiedSize(String text, float fontSize, int fontType) {
        JLabel jLabel = new JLabel(text);
        jLabel.setFont(jLabel.getFont().deriveFont(fontSize).deriveFont(fontType));
        jLabel.setMaximumSize(new Dimension(640, 100));
        return jLabel;
    }

    public void enter(Object helpId) {
        super.enter(helpId);
        if (!(helpId instanceof String)) {
            return;
        }
        HelpLoader.setHelpButtonVisible(false);
        this.eventManager.fireEvent(HelpListener.class, listener -> listener.helpShowing(true));
        this.updateQrCode(this.generateHelpUrl(QR_HELP_URL));
    }

    @Override
    public CardPanel getHelpCardPanel() {
        return this;
    }

    @Override
    public Class<? extends CardPanel> getHelpClass() {
        return this.getClass();
    }

    private void updateQrCode(String url) {
        Icon qrCode = this.generateQrCode(url);
        this.imageLabel.setIcon(qrCode);
    }

    private Icon generateQrCode(String url) {
        return new ImageIcon(QRCodeGenerator.getQRCode((String)url));
    }

    private String generateHelpUrl(String url) {
        return String.format(url, this.getSoftwareVersion(), this.getRobotType(), this.getLanguage(), this.getSerialNumber());
    }

    private String getSerialNumber() {
        return this.robotIdentification.getSerialNumber().getSerialNumber();
    }

    private String getRobotType() {
        return this.robotConfigurationProvider.getRobotID().getTypeAsString();
    }

    private String getSoftwareVersion() {
        URVersion version = this.urVersionProvider.getMarketingVersion();
        return version.toString();
    }

    private String getLanguage() {
        return Settings.getLanguage().getLanguageName();
    }

    private class NavigateBackAction
    implements ActionListener {
        private NavigateBackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpLoader.setHelpButtonVisible(true);
            QRHelpPanel.this.eventManager.fireEvent(HelpListener.class, listener -> listener.helpShowing(false));
            QRHelpPanel.this.flipManager.navigateBack();
        }
    }
}

