/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.hmc;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.view.constants.runtime.PolyscopeFaultType;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.vecmath.Vector3d;

public final class ControllerSocketSender {
    private static final String END_PROGRAM = "end\n";
    private static final String INKOGNITO = "inkognito";
    private static List<StopRobotListener> stopRobotListeners = new ArrayList<StopRobotListener>();
    private static ControllerInterface controllerInterface;

    private ControllerSocketSender() {
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        ControllerSocketSender.controllerInterface = controllerInterface;
    }

    public static void addStopRobotListener(StopRobotListener listener) {
        stopRobotListeners.add(listener);
    }

    public static void sendStopJoint(double acceleration) {
        String b = "def inkognito():\n  stopj(" + acceleration + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendZeroSpecificJoints(String jointsToZero) {
        controllerInterface.runScript("zero joints " + jointsToZero + "\n");
    }

    public static void sendSetSpeed(double speed) {
        controllerInterface.runScript("set speed " + speed + "\n");
    }

    public static void sendSetSpeedLimit(double speedCap) {
        controllerInterface.runScript("set speed_limit " + speedCap + "\n");
    }

    public static void sendIncreaseSpeedLimit() {
        controllerInterface.runScript("increase speed limit\n");
    }

    public static void sendUnlockProtectiveStop() {
        controllerInterface.runScript("set unlock protective stop\n");
    }

    public static void sendReleaseBrakes() {
        controllerInterface.runScript("set robotmode run\n");
    }

    public static void sendRunProgram() {
        controllerInterface.runScript("run program\n");
    }

    public static boolean sendStopProgram() {
        boolean didWritBytes = controllerInterface.runScript("stop program\n");
        CopyOnWriteArrayList<StopRobotListener> copyList = new CopyOnWriteArrayList<StopRobotListener>(stopRobotListeners);
        for (StopRobotListener stopRobotListener : copyList) {
            stopRobotListener.stopProgramSent();
        }
        if (didWritBytes) {
            controllerInterface.setUserProgramOnRobot(false);
        }
        return didWritBytes;
    }

    public static boolean sendPauseProgram() {
        return controllerInterface.runScript("pause program\n");
    }

    public static boolean sendResumeProgram() {
        return controllerInterface.runScript("resume program\n");
    }

    public static boolean sendStep() {
        return controllerInterface.runScript("step\n");
    }

    public static void sendPolyScopeFault(PolyscopeFaultType type) {
        controllerInterface.runScript("polyscope fault " + type.getId() + "\n");
    }

    public static void sendConfirmtionOfSafetySetup() {
        controllerInterface.runScript("confirm user safety parameters\n");
    }

    public static void sendSetTCPTransform(ToolPosition pose) {
        ControllerSocketSender.sendSetTCPTransform(new Pose6d(pose.asArray()));
    }

    public static void sendSetTCPTransform(Pose6d pose) {
        String b = "sec setTCPTransform():\n  set_tcp(" + pose + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendAsSecondaryProgram(String s) {
        String b = "sec p():\n  " + s + "\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    private static String getSetGravityFunctionCall(Vector3d gravity) {
        return "set_gravity([" + gravity.x + ", " + gravity.y + ", " + gravity.z + "])";
    }

    public static void sendSetGravity(Vector3d gravity) {
        ControllerSocketSender.pauseProgramIfRunning();
        ControllerSocketSender.sendAsSecondaryProgram(ControllerSocketSender.getSetGravityFunctionCall(gravity));
    }

    public static String set_gravity(Vector3d gravity) {
        return "set_gravity([" + gravity.x + ", " + gravity.y + ", " + gravity.z + "])";
    }

    public static void pauseProgramIfRunning() {
        if (RobotState.getLatestRobotState().programRunning) {
            ControllerSocketSender.sendPauseProgram();
        }
    }

    public static void sendInkognito(String script) {
        StringBuilder b = new StringBuilder();
        b.append("def inkognito():\n");
        ControllerSocketSender.createBody(script, b);
        b.append(END_PROGRAM);
        if (controllerInterface.isConnected()) {
            controllerInterface.runScript(b.toString());
        }
    }

    private static void createBody(String script, StringBuilder b) {
        StringTokenizer stringTokenizer = new StringTokenizer(script, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            b.append("  ");
            b.append(stringTokenizer.nextToken());
            b.append("\n");
        }
    }

    public static interface StopRobotListener
    extends EventListener {
        public void stopProgramSent();
    }
}

