/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.hmc;

import com.ur.i18n.TextResource;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.RequestFromController;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.hmc.ControllerInterfaceBlend;
import com.ur.view.hmc.ControllerInterfacePositionNode;
import com.ur.view.hmc.ControllerRPC;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class HMC
implements ControllerRPC,
RequestFromController {
    private static final int HMC_PATH_CACHE_MAX_SIZE = 1000;
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final Map<String, Point3d[]> hmcPathCache = Collections.synchronizedMap(new LinkedHashMap<String, Point3d[]>(1000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Point3d[]> eldest) {
            return this.size() > 1000;
        }
    });
    private static ControllerInterface controllerInterface;
    private static HMCInterface hmcInterface;
    @Inject
    private TextResource textResource;

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        HMC.controllerInterface = controllerInterface;
    }

    @Inject
    public static void setHmcInterface(HMCInterface hmcInterface) {
        HMC.hmcInterface = hmcInterface;
    }

    private HMCResponse sendHMCMessageAndWait(StringBuffer s) {
        return hmcInterface.sendHMCMessageAndWait(s.toString());
    }

    private HMCResponse sendHMCMessageAndWait(StringBuffer s, int timeout) {
        return hmcInterface.sendHMCMessageAndWait(s.toString(), timeout);
    }

    @Override
    public JointPositionVector getRealJointPositions() {
        return this.getJointPositions(true);
    }

    @Override
    public JointPositionVector getSimJointPositions() {
        return this.getJointPositions(false);
    }

    private JointPositionVector getJointPositions(boolean real) {
        StringBuffer s = new StringBuffer("get_joint_positions(");
        s.append(real ? "True" : "False");
        s.append(")");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(s);
        if (hmcResponseMessage != null) {
            try {
                JointPositionVector jpv = new JointPositionVector();
                ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                DataInputStream dis = new DataInputStream(bais);
                int j = 0;
                while (j < 6) {
                    jpv.setJoint(j, dis.readDouble());
                    ++j;
                }
                dis.close();
                bais.close();
                return jpv;
            }
            catch (IOException e) {
                Log.error((String)("Parse error (or similar): " + e));
            }
        }
        return null;
    }

    @Override
    public int getKinematicFlags() {
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(new StringBuffer("get_flags()"));
        if (hmcResponseMessage != null) {
            if (hmcResponseMessage.getResponseData().length == 1) {
                byte flags = hmcResponseMessage.getResponseData()[0];
                return flags;
            }
            Log.error((String)"get_flags(): singularity");
        }
        return -1;
    }

    @Override
    public double getPayloadMass() {
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(new StringBuffer("get_payload_mass()"));
        if (hmcResponseMessage != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                DataInputStream dis = new DataInputStream(bais);
                return dis.readDouble();
            }
            catch (IOException e) {
                Log.error((String)("Parse error (or similar): " + e));
            }
        }
        return -1.0;
    }

    @Override
    public String parseExpressionCheck(String s) {
        String result = null;
        StringBuffer sb = new StringBuffer("parse_expr($(" + s + ")$)");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(sb);
        if (hmcResponseMessage != null) {
            result = this.unpackParsedExpressionCheckMessage(hmcResponseMessage);
        }
        return result;
    }

    @Override
    public String parseAssignmentExpressionCheck(String s) {
        String result = null;
        StringBuffer sb = new StringBuffer("parse_expr($" + s + "$)");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(sb);
        if (hmcResponseMessage != null) {
            result = this.unpackParsedExpressionCheckMessage(hmcResponseMessage);
        }
        return result;
    }

    private String unpackParsedExpressionCheckMessage(HMCResponse hmcResponseMessage) {
        if (hmcResponseMessage.getResponseData() == null) {
            throw new IllegalStateException("HMC Message buffer is null");
        }
        String resultString = null;
        FilterInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(new ByteArrayInputStream(hmcResponseMessage.getResponseData()));
                int length = ((DataInputStream)dis).readInt();
                byte[] bb = new byte[length];
                ((DataInputStream)dis).readFully(bb);
                resultString = new String(bb, CHARSET_UTF8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't parse Expression Check Message.", e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (Exception exception) {}
        return resultString;
    }

    @Override
    public String analyseExpression(String expression) throws RuntimeException {
        String result = null;
        StringBuffer sb = new StringBuffer("analyse_expression($ " + expression + " $)");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(sb);
        if (hmcResponseMessage != null) {
            result = this.unpackAnalyseProgramMessage(hmcResponseMessage);
        }
        return result;
    }

    private String unpackAnalyseProgramMessage(HMCResponse hmcResponseMessage) {
        String resultString;
        if (hmcResponseMessage.getResponseData() == null) {
            throw new IllegalStateException("HMC Message buffer is null");
        }
        FilterInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(new ByteArrayInputStream(hmcResponseMessage.getResponseData()));
                boolean isJson = ((DataInputStream)dis).readBoolean();
                int length = ((DataInputStream)dis).readInt();
                byte[] bb = new byte[length];
                ((DataInputStream)dis).readFully(bb);
                resultString = new String(bb, CHARSET_UTF8);
                if (!isJson) {
                    throw new IOException("HMC message is not a JSON:" + resultString);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't parse Analyse Program Message. ", e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (Exception exception) {}
        return resultString;
    }

    public static void clearHMC() {
        hmcPathCache.clear();
    }

    private Point3d[] getPath(StringBuffer s) {
        Point3d[] cached = hmcPathCache.get(s.toString());
        if (cached != null) {
            return cached;
        }
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(s, 500);
        if (hmcResponseMessage != null) {
            ByteArrayInputStream bais;
            DataInputStream dis;
            int nPos;
            block7: {
                if (hmcResponseMessage.getResponseData() == null) {
                    Log.error((String)"HMC Message buffer is null!?");
                }
                if ((nPos = (dis = new DataInputStream(bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData()))).readInt()) != 0) break block7;
                return null;
            }
            try {
                Point3d[] p3d = new Point3d[nPos];
                int i = 0;
                while (i < nPos) {
                    p3d[i] = new Point3d(dis.readDouble(), dis.readDouble(), dis.readDouble());
                    ++i;
                }
                dis.close();
                bais.close();
                hmcPathCache.put(s.toString(), p3d);
                return p3d;
            }
            catch (IOException e) {
                Log.error((String)"HMC.getJointPath: Parse error (or similar) ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Point3d[] getJointPath(ControllerInterfacePositionNode fromNode, ControllerInterfacePositionNode toNode, double point_spacing) {
        JointPositionVector fromJpv = fromNode.getActualJointPositionVector();
        JointPositionVector toJpv = toNode.getActualJointPositionVector();
        if (fromJpv.isUndefined() || toJpv.isUndefined()) {
            return null;
        }
        StringBuffer s = new StringBuffer("pathj(");
        s.append(fromJpv);
        if (!fromNode.isStopPoint() && fromNode.getBlendRadius() > 0.0) {
            s.append(", r=" + fromNode.getBlendRadius());
        }
        s.append(", " + toJpv);
        if (!toNode.isStopPoint() && toNode.getBlendRadius() > 0.0) {
            s.append(", r=" + toNode.getBlendRadius());
        }
        s.append(", " + point_spacing + ")");
        return this.getPath(s);
    }

    @Override
    public Point3d[] getBlendPath(ControllerInterfaceBlend blend, double pointspacing) {
        JointPositionVector jpv;
        double localPointSpacing = pointspacing;
        ControllerInterfacePositionNode fromNode = null;
        ControllerInterfacePositionNode toNode = null;
        ControllerInterfacePositionNode nextNode = null;
        if (blend.toMotion().getToPositionNode().isCircleDefiningNode()) {
            if (blend.fromMotion().getFromPositionNode().isCircleDefiningNode()) {
                if (blend.fromMotion().getFromPositionNode().getPreviousPositionNodes(ControllerInterfacePositionNode.class).iterator().hasNext()) {
                    fromNode = (ControllerInterfacePositionNode)blend.fromMotion().getFromPositionNode().getPreviousPositionNodes(ControllerInterfacePositionNode.class).iterator().next();
                }
            } else {
                fromNode = blend.fromMotion().getFromPositionNode();
            }
            toNode = blend.fromMotion().getToPositionNode();
            if (blend.toMotion().getToPositionNode().getNextPositionNodes(ControllerInterfacePositionNode.class).iterator().hasNext()) {
                nextNode = (ControllerInterfacePositionNode)blend.toMotion().getToPositionNode().getNextPositionNodes(ControllerInterfacePositionNode.class).iterator().next();
            } else {
                Log.error((String)"HMC.getBlendPath() Error: We do not know where the circle move should end, in determining blend: movep -> movec");
            }
            if (nextNode == null || nextNode.isUndefined() || fromNode == null || fromNode.isUndefined()) {
                return null;
            }
        } else if (blend.fromMotion().getFromPositionNode().isCircleDefiningNode()) {
            if (blend.fromMotion().getFromPositionNode().getPreviousPositionNodes(ControllerInterfacePositionNode.class).iterator().hasNext()) {
                fromNode = (ControllerInterfacePositionNode)blend.fromMotion().getFromPositionNode().getPreviousPositionNodes(ControllerInterfacePositionNode.class).iterator().next();
            } else {
                Log.error((String)"HMC.getBlendPath() Error: We do not know where the circle move should start, in determining blend: movec -> movep");
            }
            if (fromNode == null || fromNode.isUndefined()) {
                return null;
            }
            toNode = blend.fromMotion().getToPositionNode();
            nextNode = blend.toMotion().getToPositionNode();
        } else {
            fromNode = blend.fromMotion().getFromPositionNode();
            toNode = blend.fromMotion().getToPositionNode();
            nextNode = blend.toMotion().getToPositionNode();
        }
        if ((jpv = fromNode.getActualJointPositionVector()).isUndefined() || nextNode.getActualJointPositionVector().isUndefined()) {
            return null;
        }
        StringBuffer s = new StringBuffer("pathb(" + jpv + ", ");
        s.append(String.valueOf(fromNode.isStopPoint() ? "True" : "False") + ", ");
        s.append(toNode.generateMoveCommand(new ScriptWriter(), true, true).toString().trim());
        s.append(", " + (nextNode.isStopPoint() ? "True" : "False") + ", ");
        s.append(nextNode.generateMoveCommand(new ScriptWriter(), true, true).toString().trim());
        s.append(", " + localPointSpacing + ")");
        if (s.toString().contains("pose_trans")) {
            return null;
        }
        return this.getPath(s);
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isRobotMountingCorrect() {
        StringBuffer s = new StringBuffer("is_robot_mounting_correct()");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(s);
        if (hmcResponseMessage != null) {
            ByteArrayInputStream bais;
            int res;
            FilterInputStream dis = null;
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
            }
            boolean bl = (res = ((DataInputStream)(dis = new DataInputStream(bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData())))).readInt()) == 1;
            try {
                dis.close();
            }
            catch (IOException iOException) {}
            return bl;
            catch (Exception e) {
                try {
                    Log.error((String)("HMC.isRobotMountingCorrect: Parse error (or similar) " + e));
                }
                catch (Throwable throwable) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.warning((String)"HMC.isRobotMountingCorrect: HMC call failed on timeout");
        return false;
    }

    @Override
    public void setRealRobotBlocking() {
        if (controllerInterface.isConnected()) {
            try {
                controllerInterface.runScript("set real\n");
            }
            catch (Exception e) {
                Log.error((String)"Could not send \"set real\": ", (Throwable)e);
                throw new RuntimeException(String.valueOf(this.textResource.failedToActivateRealRobot()) + ":" + e.getMessage());
            }
            int waitForHMCResponseInMs = 1500;
            if (!Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                public boolean itHappened() {
                    return RobotState.getLatestRobotState().real;
                }
            }, (int)waitForHMCResponseInMs, (TimeUnit)TimeUnit.MILLISECONDS)) {
                EventNotificationService.notify(ControllerConnectionListener.class, (NotificationStrategy)new NotificationStrategy<ControllerConnectionListener>(){

                    public void notify(ControllerConnectionListener controllerConnectionListener) {
                        controllerConnectionListener.failedToSendMessage("set real");
                    }
                });
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Pose6d getTCPPose(JointPositionVector jpv) {
        if (jpv == null || jpv.isUndefined()) {
            return null;
        }
        StringBuffer s = new StringBuffer("get_tcp_pose(" + jpv + ")");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(s);
        if (hmcResponseMessage != null) {
            FilterInputStream dis = null;
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
            dis = new DataInputStream(bais);
            Pose6d pose6d = new Pose6d(((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble(), ((DataInputStream)dis).readDouble());
            try {
                dis.close();
            }
            catch (IOException iOException) {}
            return pose6d;
            catch (IOException e) {
                try {
                    Log.error((String)("HMC.getJointPath: Parse error (or similar) " + e));
                }
                catch (Throwable throwable) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Override
    public JointPositionVector getInverseKinematics(Pose6d pose, JointPositionVector near_jpv) {
        Point3d p = new Point3d((Tuple3d)pose.getPos());
        Point3d r = new Point3d((Tuple3d)pose.getRot());
        return this.getInverseKinematics(p, r, near_jpv);
    }

    @Override
    public JointPositionVector getInverseKinematics(Point3d pos, Point3d axisangle, JointPositionVector near_jpv) {
        StringBuffer s = new StringBuffer("get_inverse_kinematics([" + pos.x + "," + pos.y + "," + pos.z + "," + axisangle.x + "," + axisangle.y + "," + axisangle.z + "]," + near_jpv + ")");
        JointPositionVector jpv = this.receiveJointPositionVector(this.sendHMCMessageAndWait(s));
        if (jpv == null) {
            Log.error((String)("Could not find inverse kinematics. Position=" + pos + ". Axis angle=" + axisangle + ". Near=" + near_jpv + "."));
        }
        return jpv;
    }

    private JointPositionVector receiveJointPositionVector(HMCResponse hmcResponseMessage) {
        if (hmcResponseMessage != null) {
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
                return null;
            }
            if (hmcResponseMessage.getResponseData().length == 0) {
                return null;
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                DataInputStream dis = new DataInputStream(bais);
                JointPositionVector newjpv = new JointPositionVector();
                int i = 0;
                while (i < 6) {
                    newjpv.setJoint(i, dis.readDouble());
                    ++i;
                }
                dis.close();
                return newjpv;
            }
            catch (IOException e) {
                Log.error((String)("HMC.getJointPath: Parse error (or similar) " + e));
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean canBeReachByMoveL(Pose6d targetPose, JointPositionVector qStart, JointPositionVector qTarget) {
        StringBuffer s = new StringBuffer("hmc_can_be_reached_by_movel([" + targetPose.getPos().x + "," + targetPose.getPos().y + "," + targetPose.getPos().z + "," + targetPose.getRot().x + "," + targetPose.getRot().y + "," + targetPose.getRot().z + "]," + qStart + "," + qTarget + ")");
        HMCResponse hmcResponseMessage = this.sendHMCMessageAndWait(s);
        if (hmcResponseMessage != null) {
            ByteArrayInputStream bais;
            int res;
            FilterInputStream dis = null;
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
            }
            boolean bl = (res = ((DataInputStream)(dis = new DataInputStream(bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData())))).readInt()) == 1;
            try {
                dis.close();
            }
            catch (IOException iOException) {}
            return bl;
            catch (Exception e) {
                try {
                    Log.error((String)("HMC.canBeReachByMoveL: Parse error (or similar) " + e));
                }
                catch (Throwable throwable) {
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public DataInput sendAndWait(String s) {
        HMCResponse hmcResponseMessage = hmcInterface.sendHMCMessageAndWait(s);
        if (hmcResponseMessage == null) {
            return null;
        }
        if (hmcResponseMessage.getResponseData() == null) {
            Log.error((String)"HMC Message buffer is null!?");
            return null;
        }
        if (hmcResponseMessage.getResponseData().length == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
        return new DataInputStream(bais);
    }

    public void close() {
    }
}

