/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.impl;

import com.ur.i18n.TextResource;
import com.ur.injection.Builder;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.program.nodes.EditProgramService;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ArgumentProvider;
import com.ur.swing.FlipManager;
import com.ur.swing.InterceptableAction;
import com.ur.swing.MouseEventActionWrapper;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.view.ActionFactory;
import com.ur.view.action.CopyNodeAction;
import com.ur.view.action.CutNodeAction;
import com.ur.view.action.DeleteNodeAction;
import com.ur.view.action.ExpandTreeAction;
import com.ur.view.action.MoveProgramNodeDownAction;
import com.ur.view.action.MoveProgramNodeUpAction;
import com.ur.view.action.PasteNodeAction;
import com.ur.view.action.RedoProgramAction;
import com.ur.view.action.ShowProgramCorrectionScreenAction;
import com.ur.view.action.ShowSettingsScreenAction;
import com.ur.view.action.SuppressNodeAction;
import com.ur.view.action.UndoProgramAction;
import com.ur.view.action.programnode.AddAssignmentNodeAction;
import com.ur.view.action.programnode.AddCircleMoveNodeAction;
import com.ur.view.action.programnode.AddCommentNodeAction;
import com.ur.view.action.programnode.AddContributedProgramNodeAction;
import com.ur.view.action.programnode.AddEventNodeAction;
import com.ur.view.action.programnode.AddFolderNodeAction;
import com.ur.view.action.programnode.AddForceNodeAction;
import com.ur.view.action.programnode.AddHaltNodeAction;
import com.ur.view.action.programnode.AddIfNodeAction;
import com.ur.view.action.programnode.AddLoopNodeAction;
import com.ur.view.action.programnode.AddMoveDirectionNodeAction;
import com.ur.view.action.programnode.AddMoveNodeAction;
import com.ur.view.action.programnode.AddPalletNodeAction;
import com.ur.view.action.programnode.AddPopupNodeAction;
import com.ur.view.action.programnode.AddScriptNodeAction;
import com.ur.view.action.programnode.AddSeekNodeAction;
import com.ur.view.action.programnode.AddSetNodeAction;
import com.ur.view.action.programnode.AddSubProgramNodeAction;
import com.ur.view.action.programnode.AddSwitchNodeAction;
import com.ur.view.action.programnode.AddThreadNodeAction;
import com.ur.view.action.programnode.AddTimerNodeAction;
import com.ur.view.action.programnode.AddWaitNodeAction;
import com.ur.view.action.programnode.AddWaypointNodeAction;
import com.ur.view.actions.AddNodeActionFactory;
import com.ur.view.actions.EditProgramActionFactory;
import com.ur.view.help.HelpAction;
import com.ur.view.installation.filemanager.RobotInstallationFileManagerConfiguration;
import com.ur.view.polyscope.module.programs.ProgramModule;
import gui.polyscope.setup.RobotMountingTab;
import gui.program.EntityFactory;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.Action;

public class ActionFactoryImpl
implements ActionFactory,
AddNodeActionFactory,
EditProgramActionFactory {
    private final Builder builder;
    private final LockActionCreator actionForPrivilegeDecorator;
    private final TextResource textResource;
    private final Privileges privilegeSite;

    @Inject
    public ActionFactoryImpl(Builder builder, Privileges privilegeSite, LockActionCreator actionForPrivilegeDecorator, TextResource textResource) {
        this.builder = builder;
        this.privilegeSite = privilegeSite;
        this.actionForPrivilegeDecorator = actionForPrivilegeDecorator;
        this.textResource = textResource;
    }

    @Override
    public Action createShowSettingsScreenAction() {
        return (Action)this.builder.get(ShowSettingsScreenAction.class);
    }

    @Override
    public Action createProgramCorrectionPopupAction() {
        ShowProgramCorrectionScreenAction result = (ShowProgramCorrectionScreenAction)this.builder.get(ShowProgramCorrectionScreenAction.class);
        result.setPopupMenuAction(true);
        result.putValue("Name", this.textResource.tabProgramCorrection());
        result.putValue("SmallIcon", ViewImageResource.programCorrectionWhite());
        result.putValue("SelectedSmallIcon", ViewImageResource.programCorrectionBlack());
        result.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        result.putValue("InternalName", "programCorrectionScreen.HeaderMenu");
        return result;
    }

    @Override
    public Action createShowMountingScreen(FlipManager flipManager) {
        ShowScreenActionImpl result = new ShowScreenActionImpl(RobotMountingTab.class, flipManager, true);
        result.putValue("Name", (Object)this.textResource.jumpToMountingTab());
        return this.actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)result, this.privilegeSite.getPrivilege((RestrictedPoint)LockableRestrictedPoint.INSTALLATION));
    }

    @Override
    public Action createShowLoadInstallationScreen(final FlipManager flipManager, final ArgumentProvider fileContainerProvider) {
        final FilePersistence filePersistence = (FilePersistence)this.builder.get(FilePersistence.class);
        return this.actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)new InterceptableAction.Default(){
            {
                this.putValue("HelpId", "gui:initialization_screen_payload_and_installation");
                this.putValue("Name", ActionFactoryImpl.this.textResource.loadInstallation());
            }

            public void doActionPerformed(ActionEvent actionEvent) {
                filePersistence.openFile((FileContainer)fileContainerProvider.argument(), (FileManagerConfiguration)new RobotInstallationFileManagerConfiguration(ActionFactoryImpl.this.textResource.loadInstallation()));
            }

            public FlipManager getFlipManager() {
                return flipManager;
            }
        }, this.privilegeSite.getPrivilege((RestrictedPoint)LockableRestrictedPoint.INSTALLATION));
    }

    @Override
    public Action createHelpAction() {
        return (Action)this.builder.get(HelpAction.class);
    }

    @Override
    public Action createUndoProgramAction() {
        return this.wrapActionWithMouseListener(UndoProgramAction.class);
    }

    @Override
    public Action createRedoProgramAction() {
        return this.wrapActionWithMouseListener(RedoProgramAction.class);
    }

    @Override
    public Action createMoveNodeUpAction() {
        return this.wrapActionWithMouseListener(MoveProgramNodeUpAction.class);
    }

    @Override
    public Action createMoveNodeDownAction() {
        return this.wrapActionWithMouseListener(MoveProgramNodeDownAction.class);
    }

    @Override
    public Action createCopyProgramNodeAction() {
        return this.wrapActionWithMouseListener(CopyNodeAction.class);
    }

    @Override
    public Action createCutProgramNodeAction() {
        return this.wrapActionWithMouseListener(CutNodeAction.class);
    }

    @Override
    public Action createPasteProgramNodeAction() {
        return this.wrapActionWithMouseListener(PasteNodeAction.class);
    }

    @Override
    public Action createDeleteProgramNodeAction() {
        return this.wrapActionWithMouseListener(DeleteNodeAction.class);
    }

    @Override
    public Action createSuppressProgramNodeAction() {
        return this.wrapActionWithMouseListener(SuppressNodeAction.class);
    }

    @Override
    public Action createExpandTreeViewAction() {
        return (Action)this.builder.get(ExpandTreeAction.class);
    }

    @Override
    public Action createAddMoveNodeAction() {
        return this.wrapActionWithMouseListener(AddMoveNodeAction.class);
    }

    @Override
    public Action createAddWaypointNodeAction() {
        return this.wrapActionWithMouseListener(AddWaypointNodeAction.class);
    }

    @Override
    public Action createAddCircleMoveNodeAction() {
        return this.wrapActionWithMouseListener(AddCircleMoveNodeAction.class);
    }

    @Override
    public Action createAddWaitNodeAction() {
        return this.wrapActionWithMouseListener(AddWaitNodeAction.class);
    }

    @Override
    public Action createAddSetNodeAction() {
        return this.wrapActionWithMouseListener(AddSetNodeAction.class);
    }

    @Override
    public Action createAddPopupNodeAction() {
        return this.wrapActionWithMouseListener(AddPopupNodeAction.class);
    }

    @Override
    public Action createAddHaltNodeAction() {
        return this.wrapActionWithMouseListener(AddHaltNodeAction.class);
    }

    @Override
    public Action createAddCommentNodeAction() {
        return this.wrapActionWithMouseListener(AddCommentNodeAction.class);
    }

    @Override
    public Action createAddFolderNodeAction() {
        return this.wrapActionWithMouseListener(AddFolderNodeAction.class);
    }

    @Override
    public Action createAddTimerNodeAction() {
        return this.wrapActionWithMouseListener(AddTimerNodeAction.class);
    }

    @Override
    public Action createAddLoopNodeAction() {
        return this.wrapActionWithMouseListener(AddLoopNodeAction.class);
    }

    @Override
    public Action createAddSubProgramNodeAction() {
        return this.wrapActionWithMouseListener(AddSubProgramNodeAction.class);
    }

    @Override
    public Action createAddAssignmentNodeAction() {
        return this.wrapActionWithMouseListener(AddAssignmentNodeAction.class);
    }

    @Override
    public Action createAddIfNodeAction() {
        return this.wrapActionWithMouseListener(AddIfNodeAction.class);
    }

    @Override
    public Action createAddScriptNodeAction() {
        return this.wrapActionWithMouseListener(AddScriptNodeAction.class);
    }

    @Override
    public Action createAddEventNodeAction() {
        return this.wrapActionWithMouseListener(AddEventNodeAction.class);
    }

    @Override
    public Action createAddThreadNodeAction() {
        return this.wrapActionWithMouseListener(AddThreadNodeAction.class);
    }

    @Override
    public Action createAddSwitchNodeAction() {
        return this.wrapActionWithMouseListener(AddSwitchNodeAction.class);
    }

    @Override
    public Action createAddPalletNodeAction() {
        return this.wrapActionWithMouseListener(AddPalletNodeAction.class);
    }

    @Override
    public Action createAddSeekNodeAction() {
        return this.wrapActionWithMouseListener(AddSeekNodeAction.class);
    }

    @Override
    public Action createAddForceNodeAction() {
        return this.wrapActionWithMouseListener(AddForceNodeAction.class);
    }

    @Override
    public Action createAddMoveDirectionNodeAction() {
        return this.wrapActionWithMouseListener(AddMoveDirectionNodeAction.class);
    }

    @Override
    public Action createAddContributedProgramNodeFactoryAction(ProgramModule.ContributableProgramNodeFactory factory) {
        AddContributedProgramNodeAction newAction = new AddContributedProgramNodeAction(factory, (EditProgramService)this.builder.get(EditProgramService.class), (EntityFactory)this.builder.get(EntityFactory.class));
        return new MouseEventActionWrapper((Action)((Object)newAction));
    }

    private <T extends Action> Action wrapActionWithMouseListener(Class<T> typeToFetch) {
        Action action = (Action)this.builder.get(typeToFetch);
        return new MouseEventActionWrapper(action);
    }
}

