/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.impl;

import com.ur.lang.StringUtils;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.JointType;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.controllerinterface.synchroneous.HMCInterface;
import com.ur.polyscope.controllerinterface.synchroneous.HMCResponse;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.viewfacade.move.InverseKinematicProviderExt;
import com.ur.util.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.inject.Inject;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

class InverseKinematicProviderImpl
implements InverseKinematicProviderExt {
    private final HMCInterface hmcInterface;

    @Inject
    public InverseKinematicProviderImpl(HMCInterface hmcInterface) {
        this.hmcInterface = hmcInterface;
    }

    public JointPositionVector getInverseKinematics(Pose6d pose, JointPositionVector nearJpv) {
        Point3d p = new Point3d((Tuple3d)pose.getPos());
        Point3d r = new Point3d((Tuple3d)pose.getRot());
        return this.getInverseKinematics(p, r, nearJpv);
    }

    public JointPositionVector getInverseKinematics(Point3d pos, Point3d axisangle, JointPositionVector nearJpv) {
        StringBuffer s = new StringBuffer("get_inverse_kinematics([" + pos.x + "," + pos.y + "," + pos.z + "," + axisangle.x + "," + axisangle.y + "," + axisangle.z + "]," + nearJpv + ")");
        JointPositionVector jpv = this.receiveJointPositionVector(this.sendHMCMessageAndWait(s));
        if (jpv == null) {
            Log.error((String)("Could not find inverse kinematics. Position=" + pos + ". Axis angle=" + axisangle + ". Near=" + nearJpv + "."));
        }
        return jpv;
    }

    public JointPositionVector getInverseKinematicsMoveL(Point3d pos, Point3d axisangle, JointPositionVector nearJpv) {
        StringBuffer s = new StringBuffer("get_inverse_kinematics_movel([" + pos.x + "," + pos.y + "," + pos.z + "," + axisangle.x + "," + axisangle.y + "," + axisangle.z + "]," + nearJpv + ")");
        JointPositionVector jpv = this.receiveJointPositionVector(this.sendHMCMessageAndWait(s));
        if (jpv == null) {
            Log.error((String)("Could not find inverse kinematics. Position=" + pos + ". Axis angle=" + axisangle + ". Near=" + nearJpv + "."));
        }
        return jpv;
    }

    public JointPositionVector getInverseKinematicsMoveL(Vector3d pos, Vector3d axisangle, JointPositionVector nearJpv) {
        Point3d p = new Point3d((Tuple3d)pos);
        Point3d r = new Point3d((Tuple3d)axisangle);
        return this.getInverseKinematicsMoveL(p, r, nearJpv);
    }

    public JointConfiguration getInverseKinematics(ToolPosition toolPosition, JointConfiguration qNear, ToolPosition tcpPosition) {
        JointPositionVector nearJpv;
        Point3d rotation;
        Point3d translation = new Point3d(toolPosition.getPositionX(), toolPosition.getPositionY(), toolPosition.getPositionZ());
        JointPositionVector jointPositionVector = this.getInverseKinematics(translation, rotation = new Point3d(toolPosition.getRotationX(), toolPosition.getRotationY(), toolPosition.getRotationZ()), nearJpv = new JointPositionVector(qNear.getBase(), qNear.getShoulder(), qNear.getElbow(), qNear.getWrist1(), qNear.getWrist2(), qNear.getWrist3()), tcpPosition);
        if (jointPositionVector == null) {
            return null;
        }
        return new JointConfiguration(jointPositionVector.getJoint(JointType.BASE), jointPositionVector.getJoint(JointType.SHOULDER), jointPositionVector.getJoint(JointType.ELBOW), jointPositionVector.getJoint(JointType.WRIST1), jointPositionVector.getJoint(JointType.WRIST2), jointPositionVector.getJoint(JointType.WRIST3));
    }

    private JointPositionVector getInverseKinematics(Point3d pos, Point3d axisangle, JointPositionVector nearJpv, ToolPosition tcp) {
        StringBuffer s = new StringBuffer("get_inverse_kinematics([" + pos.x + "," + pos.y + "," + pos.z + "," + axisangle.x + "," + axisangle.y + "," + axisangle.z + "]," + nearJpv + ", [" + StringUtils.joinStringsWith((String)",", (double[])tcp.asArray()) + "])");
        JointPositionVector jpv = this.receiveJointPositionVector(this.sendHMCMessageAndWait(s));
        if (jpv == null) {
            Log.error((String)("Could not find inverse kinematics. Position=" + pos + ". Axis angle=" + axisangle + ". Near=" + nearJpv + "."));
        }
        return jpv;
    }

    public JointPositionVector getInverseKinematics(Pose6d pos, JointPositionVector jpv, Pose6d tcp, boolean logNoSolutionFound) {
        String logNoSolution = logNoSolutionFound ? "True" : "False";
        String poseString = "[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "," + pos.getRX() + "," + pos.getRY() + "," + pos.getRZ() + "]";
        String tcpString = "[" + tcp.getX() + "," + tcp.getY() + "," + tcp.getZ() + "," + tcp.getRX() + "," + tcp.getRY() + "," + tcp.getRZ() + "]";
        String s = "get_inverse_kinematics(" + poseString + "," + jpv + "," + tcpString + "," + logNoSolution + ")";
        JointPositionVector rJpv = this.receiveJointPositionVector(this.hmcInterface.sendHMCMessageAndWait(s));
        if (rJpv == null && logNoSolutionFound) {
            Log.error((String)("Could not find inverse kinematics. Pose=" + pos + ". Position=" + jpv + ". TCP=" + tcp));
        }
        return rJpv;
    }

    private JointPositionVector receiveJointPositionVector(HMCResponse hmcResponseMessage) {
        if (hmcResponseMessage != null) {
            if (hmcResponseMessage.getResponseData() == null) {
                Log.error((String)"HMC Message buffer is null!?");
                return null;
            }
            if (hmcResponseMessage.getResponseData().length == 0) {
                return null;
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(hmcResponseMessage.getResponseData());
                DataInputStream dis = new DataInputStream(bais);
                JointPositionVector newjpv = new JointPositionVector();
                int i = 0;
                while (i < 6) {
                    newjpv.setJoint(i, dis.readDouble());
                    ++i;
                }
                dis.close();
                return newjpv;
            }
            catch (IOException e) {
                Log.error((String)("HMC.getJointPath: Parse error (or similar) " + e));
            }
        }
        return null;
    }

    private HMCResponse sendHMCMessageAndWait(StringBuffer s) {
        return this.hmcInterface.sendHMCMessageAndWait(s.toString());
    }
}

