/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.installation;

import com.ur.i18n.TextResource;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.lang.ErrorablePanel;
import com.ur.polyscope.viewfacade.safety.SafetySettingsComparator;
import com.ur.swing.CardPanel;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.util.event.EventManager;
import com.ur.view.installation.PerformLoadInstallation;
import com.ur.view.installation.QueryUserWhenLoading;
import com.ur.view.installation.filemanager.RobotInstallationFileManagerConfiguration;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.DashBoard;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.URFileUtils;
import java.io.File;

public class InstallationLoadingCardPanel
extends CardPanel
implements QueryUserWhenLoading {
    private final FilePersistence filePersistence;
    protected final RobotInstallationSite installationSite;
    protected final RobotInstallationLookupService lookupService;
    protected final SafetySettingsComparator safetySettingsComparator;
    private final InstallationLoadingContext installationLoadingContext;
    private final ErrorablePanel errorablePanel;
    private final EventManager eventManager;
    private final TextResource textResource;

    public InstallationLoadingCardPanel(FilePersistence filePersistence, RobotInstallationSite installationSite, RobotInstallationLookupService installationLookupService, SafetySettingsComparator safetySettingsComparator, InstallationLoadingContext installationLoadingContext, TextResource textResource, ErrorablePanel errorablePanel, EventManager eventManager) {
        this.filePersistence = filePersistence;
        this.installationSite = installationSite;
        this.lookupService = installationLookupService;
        this.safetySettingsComparator = safetySettingsComparator;
        this.installationLoadingContext = installationLoadingContext;
        this.textResource = textResource;
        this.errorablePanel = errorablePanel;
        this.eventManager = eventManager;
    }

    protected void performLoadRobotInstallation() {
        PerformLoadInstallation installationFileContainer = new PerformLoadInstallation(this, this.installationSite, this.lookupService, this.safetySettingsComparator, this.installationLoadingContext, this.textResource, this.errorablePanel, this.eventManager);
        installationFileContainer.setFile(this.lookupService == null || this.lookupService.getInstallation() == null ? null : ((PersistanceMetaData)this.lookupService.getInstallation().getMetaData(PersistanceMetaData.class)).file());
        this.filePersistence.openFile((FileContainer)installationFileContainer, (FileManagerConfiguration)new RobotInstallationFileManagerConfiguration(this.textResource.loadInstallation()));
    }

    @Override
    public boolean askToApplySafety() {
        DialogReturnValue result = LegacyURDialogCreator.confirmMessageDialog(LanguagePack.getConfirmationMessages().confirmApplySafetySettingsOrCancel());
        return result != DialogReturnValue.CANCEL;
    }

    @Override
    public void askToUseInstallationInCurrentProgram() {
        FileManagementProgramComponent component;
        File currentInstallationFile;
        PersistanceMetaData persistanceMetaData;
        File installationFile;
        ProgramRootNode currentProgram = DashBoard.getProgram();
        if (currentProgram != null && !URFileUtils.areFilesCanonicallyEqual(installationFile = (persistanceMetaData = (PersistanceMetaData)this.installationSite.getInstallation().getMetaData(PersistanceMetaData.class)).fileWithoutExtension(), currentInstallationFile = new File((component = currentProgram.getComponent(FileManagementProgramComponent.class)).getInstallationDirectory(), component.getInstallationFileName())) && !new File(component.getProgramDirectory(), component.getInstallationFileName()).getPath().equals(installationFile.getPath())) {
            String prgInstallPath = URFileUtils.getRelativeToCanonicalProgramPath(component.getInstallationDirectory(), component.getInstallationFileName());
            String currentInstallPath = URFileUtils.getRelativeToProgramPath(persistanceMetaData.directory(), persistanceMetaData.fileName());
            if (!component.isSetToRunProgramWithDifferentInstallationLoaded()) {
                ConfirmationMessage message = LanguagePack.getConfirmationMessages().confirmSetDefaultInstallationOrUseItForNow(prgInstallPath, currentInstallPath);
                DialogReturnValue retVal = LegacyURDialogCreator.confirmMessageDialog(message);
                if (retVal == DialogReturnValue.OK) {
                    component.setInstallationFileName(persistanceMetaData.fileName());
                    component.setInstallationDirectory(persistanceMetaData.directory());
                } else {
                    component.setAcceptToRunProgramWithDifferentInstallationLoaded();
                }
            }
        }
    }

    @Override
    public boolean askUserToResolveSafetyErrors() {
        DialogReturnValue result = LegacyURDialogCreator.confirmMessageDialog(LanguagePack.getConfirmationMessages().confirmResolveSafetyErrorsOrCancel());
        return result != DialogReturnValue.CANCEL;
    }
}

