/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.installation;

import com.ur.i18n.TextResource;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.lang.ErrorablePanel;
import com.ur.polyscope.viewfacade.safety.SafetySettingsComparator;
import com.ur.polyscope.viewfacade.safety.SafetyTabNavigationEvent;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.view.installation.QueryUserWhenLoading;
import com.ur.view.polyscope.module.installation.InstallationContributionsProvider;
import com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence;
import gui.installation.RobotInstallationLookupService;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import java.io.IOException;

public class PerformLoadInstallation
extends PerformingFileContainer {
    private final QueryUserWhenLoading queryUser;
    private final RobotInstallationSite installationSite;
    private final RobotInstallationLookupService robotInstallationLookupService;
    private final SafetySettingsComparator safetySettingsComparator;
    private final InstallationLoadingContext installationLoadingContext;
    private final TextResource textResource;
    private final ErrorablePanel errorablePanel;
    private final EventManager eventManager;

    public PerformLoadInstallation(QueryUserWhenLoading queryUser, RobotInstallationSite installationSite, RobotInstallationLookupService robotInstallationLookupService, SafetySettingsComparator safetySettingsComparator, InstallationLoadingContext installationLoadingContext, TextResource textResource, ErrorablePanel errorablePanel, EventManager eventManager) {
        this.queryUser = queryUser;
        this.installationSite = installationSite;
        this.robotInstallationLookupService = robotInstallationLookupService;
        this.safetySettingsComparator = safetySettingsComparator;
        this.installationLoadingContext = installationLoadingContext;
        this.textResource = textResource;
        this.errorablePanel = errorablePanel;
        this.eventManager = eventManager;
    }

    public boolean perform() {
        block12: {
            try {
                this.installationLoadingContext.setLoading(true);
                if (!this.hasFile()) break block12;
                Installation loadedInstallation = this.loadInstallation();
                if (loadedInstallation == null) {
                    Log.warning((String)"RobotInstallation object reference is null after load");
                    return false;
                }
                if (this.safetySettingsComparator.isControllerSafetySettingDifferent(loadedInstallation) && !this.queryUser.askToApplySafety()) {
                    this.robotInstallationLookupService.loadPreviousInstallation();
                    return false;
                }
                if (!this.installationSite.setInstallation(loadedInstallation)) {
                    this.robotInstallationLookupService.loadPreviousInstallation();
                    return false;
                }
                try {
                    this.queryUser.askToUseInstallationInCurrentProgram();
                    InstallationContributionsProvider contributionsProvider = this.robotInstallationLookupService.getInstallationContributionsProvider();
                    if (contributionsProvider.hasUndefinedInstallationContribution()) {
                        this.informUserOfUndefinedContributions(contributionsProvider);
                    }
                    this.askUserToResolveErrorsAndNavigateToPageWithErrors();
                }
                catch (IOException e) {
                    String err = this.textResource.notAnInstallation(e.getClass().getName());
                    Log.error((String)err, (Throwable)e);
                    LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().notARecognizedInstallationFile());
                    return false;
                }
            }
            finally {
                this.installationLoadingContext.setLoading(false);
            }
        }
        return true;
    }

    void informUserOfUndefinedContributions(InstallationContributionsProvider contributionsProvider) {
        LegacyURDialogCreator.showUndefinedInstallationContributionDialog(contributionsProvider.getUndefinedInstallationContributions());
    }

    Installation loadInstallation() throws IOException {
        return RobotInstallationPersistence.load(this.getFile());
    }

    private void askUserToResolveErrorsAndNavigateToPageWithErrors() {
        if (!this.errorablePanel.hasErrors()) {
            return;
        }
        boolean userWillResolveErrors = this.queryUser.askUserToResolveSafetyErrors();
        if (userWillResolveErrors) {
            this.errorablePanel.getFirstPanelWithErrors().ifPresent(errorable -> this.eventManager.fireEvent(SafetyTabNavigationEvent.class, safetyTabNavigationEvent -> safetyTabNavigationEvent.navigateToTab(errorable)));
        }
    }
}

