/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.installation.dashboardserver;

import com.ur.i18n.TextResource;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import gui.tools.LanguagePack;
import gui.tools.URDialogCreator;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class FailNotifier {
    private static final Logger LOG = LogFactory.createLogger(FailNotifier.class);
    private final TextResource textResource;
    private final URDialogCreator urDialogCreator;

    @Inject
    public FailNotifier(TextResource textResource, URDialogCreator urDialogCreator) {
        this.textResource = textResource;
        this.urDialogCreator = urDialogCreator;
    }

    public String handleFailedToLoad(File file, Exception e) {
        String errorMessage = String.format("Failed to load installation:%s", file.getAbsolutePath());
        LOG.error(errorMessage, (Throwable)e);
        this.urDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().notARecognizedInstallationFile(), null);
        return errorMessage;
    }

    public void notAnInstallation(File installationFile) {
        String err = this.textResource.notAnInstallation(installationFile.getName());
        LOG.error(err, new Object[0]);
    }

    public void failedToLoad(Exception e) {
        LOG.error("Failed to load installation", (Throwable)e);
        this.urDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().notARecognizedInstallationFile(), null);
    }
}

