/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.installation.dashboardserver;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.view.installation.dashboardserver.FailNotifier;
import com.ur.view.installation.dashboardserver.InstallationFailedToLoad;
import com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.ProgramLookupService;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;

@Singleton
class InstallationLoader {
    private final FailNotifier failNotifier;
    private final RobotInstallationLookupService installationLookupService;
    private final RobotInstallationSite installationSite;
    private ProgramLookupService programLookupService;
    private boolean didPerformLoad = false;

    @Inject
    InstallationLoader(FailNotifier failNotifier, RobotInstallationLookupService installationLookupService, RobotInstallationSite installationSite, ProgramLookupService programLookupService) {
        this.failNotifier = failNotifier;
        this.installationLookupService = installationLookupService;
        this.installationSite = installationSite;
        this.programLookupService = programLookupService;
    }

    public void loadInstallation(File file) throws InterruptedException {
        this.loadOnUIThread(file);
        if (this.didLoadSuccessfully()) {
            return;
        }
        this.installationLookupService.loadPreviousInstallation();
        throw new InstallationFailedToLoad("LoadInstallationAction: Installation did not load successfully, loading previous installation.");
    }

    void loadOnUIThread(File file) throws InstallationFailedToLoad, InterruptedException {
        try {
            SwingUtilities.invokeAndWait(() -> this.doLoadInstallation(file));
        }
        catch (InvocationTargetException e) {
            throw new InstallationFailedToLoad(e);
        }
    }

    protected void doLoadInstallation(File installationFile) {
        this.didPerformLoad = false;
        try {
            Installation env = RobotInstallationPersistence.loadFromDashboard(installationFile);
            if (env == null) {
                this.failNotifier.notAnInstallation(installationFile);
                return;
            }
            this.didPerformLoad = this.installationSite.setInstallation(env);
            this.allowCurrentLoadedProgramToUseInstallation();
        }
        catch (Exception e) {
            this.failNotifier.failedToLoad(e);
        }
    }

    private void allowCurrentLoadedProgramToUseInstallation() {
        ProgramRootNode program = this.programLookupService.getProgramRootNode();
        if (program != null) {
            program.getComponent(FileManagementProgramComponent.class).setAcceptToRunProgramWithDifferentInstallationLoaded();
        }
    }

    boolean didLoadSuccessfully() {
        return this.didPerformLoad;
    }
}

