/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.installation.dashboardserver;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.polyscope.filemanager.FileFromDirectory;
import com.ur.view.installation.dashboardserver.FailNotifier;
import com.ur.view.installation.dashboardserver.InstallationLoader;
import com.ur.view.installation.dashboardserver.LoadInstallationTracker;
import java.io.File;
import javax.inject.Inject;

public class LoadInstallationAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser LOAD_INSTALLATION = new ScriptActionDefinitionParser("load installation <arg>");
    private static final String LOADING_INSTALLATION_FROM_FILE = "Loading installation: %s";
    private static final String FILE_NOT_FOUND = "File not found: %s";
    public static final String FAILED_TO_LOAD_INSTALLATION = "Failed to load installation:%s";
    private final InstallationLoader loader;
    private final LoadInstallationTracker tracker;
    private final FileFromDirectory fileFromDirectory;
    private final FailNotifier failNotifier;

    @Inject
    LoadInstallationAction(InstallationLoader loader, LoadInstallationTracker tracker, FileFromDirectory fileFromDirectory, FailNotifier failNotifier) {
        this.loader = loader;
        this.tracker = tracker;
        this.fileFromDirectory = fileFromDirectory;
        this.failNotifier = failNotifier;
    }

    public boolean canHandleMessage(String input) {
        return LOAD_INSTALLATION.isMatch(input);
    }

    public String execute(String inputLine) {
        String fileName = LOAD_INSTALLATION.getArgument(0, inputLine);
        File file = this.fileFromDirectory.programs(fileName);
        return this.loadInstallationFromFile(file, fileName);
    }

    private String loadInstallationFromFile(File file, String fileName) {
        if (!file.exists()) {
            return String.format(FILE_NOT_FOUND, file.getAbsolutePath());
        }
        return this.tryLoadInstallation(file, fileName);
    }

    private String tryLoadInstallation(File file, String fileName) {
        try {
            this.trackLoadingProcess(file, fileName);
            return String.format(LOADING_INSTALLATION_FROM_FILE, file.getAbsolutePath());
        }
        catch (Exception e) {
            return this.failNotifier.handleFailedToLoad(file, e);
        }
    }

    private void trackLoadingProcess(File file, String fileName) throws Exception {
        try {
            this.tracker.startTracking(fileName);
            this.loader.loadInstallation(file);
            this.tracker.trackingCompleted();
        }
        finally {
            this.tracker.disposeTrackers();
        }
    }
}

