/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.io;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.AbstractRegister;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.PersistIOPart;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PersistGeneralRegistersPart
implements PersistIOPart {
    private static final String BOOLEAN_REGISTER_INPUT_ACTIONS = "GeneralPurposeBooleanRegisterInputActions";
    private static final String BOOLEAN_REGISTER_OUTPUT_ACTIONS = "GeneralPurposeBooleanRegisterOutputActions";
    public static final String BOOLEAN_REGISTER_INPUT_NAMES = "GeneralPurposeBooleanRegisterInputNames";
    public static final String BOOLEAN_REGISTER_OUTPUT_NAMES = "GeneralPurposeBooleanRegisterOutputNames";
    public static final String INT_REGISTER_INPUT_NAMES = "GeneralPurposeIntRegisterInputNames";
    public static final String INT_REGISTER_OUTPUT_NAMES = "GeneralPurposeIntRegisterOutputNames";
    private static final String INT_REGISTER_OUTPUT_ACTIONS = "GeneralPurposeIntRegisterOutputActions";
    public static final String FLOAT_REGISTER_INPUT_NAMES = "GeneralPurposeFloatRegisterInputNames";
    public static final String FLOAT_REGISTER_OUTPUT_NAMES = "GeneralPurposeFloatRegisterOutputNames";
    private static final String FLOAT_REGISTER_OUTPUT_ACTIONS = "GeneralPurposeFloatRegisterOutputActions";
    private final IOService ioService;
    private final InputPinActionLookupService inputPinActionLookupService;

    @Inject
    public PersistGeneralRegistersPart(IOService ioService, InputPinActionLookupService inputPinActionLookupService) {
        this.ioService = ioService;
        this.inputPinActionLookupService = inputPinActionLookupService;
    }

    public void marshal(IOService toMarshal, Installation installation, PersistWriter writer) {
        writer.createNodeWithValueAttribute(BOOLEAN_REGISTER_INPUT_NAMES, this.getUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeBooleanInputRegisters()));
        writer.createNodeWithValueAttribute(BOOLEAN_REGISTER_OUTPUT_NAMES, this.getUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeBooleanOutputRegisters()));
        writer.createNodeWithValueAttribute(INT_REGISTER_INPUT_NAMES, this.getUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeIntInputRegisters()));
        writer.createNodeWithValueAttribute(INT_REGISTER_OUTPUT_NAMES, this.getUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeIntOutputRegisters()));
        writer.createNodeWithValueAttribute(FLOAT_REGISTER_INPUT_NAMES, this.getUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeFloatInputRegisters()));
        writer.createNodeWithValueAttribute(FLOAT_REGISTER_OUTPUT_NAMES, this.getUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeFloatOutputRegisters()));
        writer.createNodeWithValueAttribute(BOOLEAN_REGISTER_INPUT_ACTIONS, this.writeInputPinActions((Pin<?>[])this.ioService.getGeneralPurposeBooleanInputRegisters()));
        writer.createNodeWithValueAttribute(BOOLEAN_REGISTER_OUTPUT_ACTIONS, this.writePinOutputActions(this.ioService.getGeneralPurposeBooleanOutputRegisters()));
        writer.createNodeWithValueAttribute(INT_REGISTER_OUTPUT_ACTIONS, this.writePinOutputActions(this.ioService.getGeneralPurposeIntOutputRegisters()));
        writer.createNodeWithValueAttribute(FLOAT_REGISTER_OUTPUT_ACTIONS, this.writePinOutputActions(this.ioService.getGeneralPurposeFloatOutputRegisters()));
    }

    private String[] writePinOutputActions(Register<?>[] registers) {
        String[] r = new String[registers.length];
        int i = 0;
        while (i < registers.length) {
            if (registers[i] instanceof AbstractRegister) {
                AbstractRegister register = (AbstractRegister)registers[i];
                r[i] = register.getOutputAction().name();
            } else {
                r[i] = InputPinAction.NONE.name();
            }
            ++i;
        }
        return r;
    }

    private String[] writeInputPinActions(Pin<?>[] pins) {
        String[] r = new String[pins.length];
        int i = 0;
        while (i < pins.length) {
            if (pins[i] instanceof InputActionPin && ((InputActionPin)pins[i]).getIOPinAction() instanceof DefaultInputPinAction) {
                InputActionPin ioPin = (InputActionPin)pins[i];
                r[i] = ioPin.getIOPinAction().name();
            } else {
                r[i] = InputPinAction.NONE.name();
            }
            ++i;
        }
        return r;
    }

    private void readPinActions(Pin<?>[] pins, String[] strings) {
        int length = Math.min(pins.length, strings.length);
        int i = 0;
        while (i < length) {
            if (pins[i] instanceof InputActionPin) {
                InputActionPin ioPin = (InputActionPin)pins[i];
                ioPin.setIOPinAction(this.inputPinActionLookupService.getPinAction(Enum.valueOf(InputPinAction.class, strings[i])));
            }
            ++i;
        }
    }

    public void unmarshal(Installation installation, PersistReader reader) {
        if (reader.isNode(BOOLEAN_REGISTER_INPUT_NAMES)) {
            this.setUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeBooleanInputRegisters(), reader.getStringValueArray());
        } else if (reader.isNode(BOOLEAN_REGISTER_OUTPUT_NAMES)) {
            this.setUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeBooleanOutputRegisters(), reader.getStringValueArray());
        } else if (reader.isNode(INT_REGISTER_INPUT_NAMES)) {
            this.setUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeIntInputRegisters(), reader.getStringValueArray());
        } else if (reader.isNode(INT_REGISTER_OUTPUT_NAMES)) {
            this.setUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeIntOutputRegisters(), reader.getStringValueArray());
        } else if (reader.isNode(FLOAT_REGISTER_INPUT_NAMES)) {
            this.setUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeFloatInputRegisters(), reader.getStringValueArray());
        } else if (reader.isNode(FLOAT_REGISTER_OUTPUT_NAMES)) {
            this.setUserDefinedNames((Pin<?>[])this.ioService.getGeneralPurposeFloatOutputRegisters(), reader.getStringValueArray());
        }
        if (reader.isNode(BOOLEAN_REGISTER_INPUT_ACTIONS)) {
            this.readPinActions((Pin<?>[])this.ioService.getGeneralPurposeBooleanInputRegisters(), reader.getStringValueArray());
        }
        if (reader.isNode(BOOLEAN_REGISTER_OUTPUT_ACTIONS)) {
            this.readPinOutputActions((Pin<?>[])this.ioService.getGeneralPurposeBooleanOutputRegisters(), reader.getStringValueArray());
        }
        if (reader.isNode(INT_REGISTER_OUTPUT_ACTIONS)) {
            this.readPinOutputActions((Pin<?>[])this.ioService.getGeneralPurposeIntOutputRegisters(), reader.getStringValueArray());
        }
        if (reader.isNode(FLOAT_REGISTER_OUTPUT_ACTIONS)) {
            this.readPinOutputActions((Pin<?>[])this.ioService.getGeneralPurposeFloatOutputRegisters(), reader.getStringValueArray());
        }
    }

    public boolean canUnmarshal(PersistReader reader) {
        return reader.isNode(BOOLEAN_REGISTER_INPUT_NAMES) || reader.isNode(BOOLEAN_REGISTER_OUTPUT_NAMES) || reader.isNode(INT_REGISTER_INPUT_NAMES) || reader.isNode(INT_REGISTER_OUTPUT_NAMES) || reader.isNode(FLOAT_REGISTER_INPUT_NAMES) || reader.isNode(FLOAT_REGISTER_OUTPUT_NAMES) || reader.isNode(BOOLEAN_REGISTER_INPUT_ACTIONS) || reader.isNode(BOOLEAN_REGISTER_OUTPUT_ACTIONS) || reader.isNode(INT_REGISTER_OUTPUT_ACTIONS) || reader.isNode(FLOAT_REGISTER_OUTPUT_ACTIONS);
    }

    private void readPinOutputActions(Pin<?>[] pins, String[] strings) {
        int length = Math.min(pins.length, strings.length);
        int i = 0;
        while (i < length) {
            if (pins[i] instanceof OutputActionPin) {
                OutputActionPin pin = (OutputActionPin)pins[i];
                pin.setOutputAction(Enum.valueOf(OutputPinAction.class, strings[i]));
            }
            ++i;
        }
    }

    private String[] getUserDefinedNames(Pin<?>[] pins) {
        String[] result = new String[pins.length];
        int i = 0;
        while (i < pins.length) {
            result[i] = pins[i].getUserDefinedName();
            ++i;
        }
        return result;
    }

    private void setUserDefinedNames(Pin<?>[] pins, String[] names) {
        int length = Math.min(pins.length, names.length);
        int i = 0;
        while (i < length) {
            pins[i].setName(names[i]);
            ++i;
        }
    }
}

