/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.io.externalapi;

import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.swing.validation.ValidationStrategy;
import javax.inject.Inject;
import org.apache.commons.lang3.math.NumberUtils;

public class MinimumPulseTimeValidator
implements ValidationStrategy {
    private TextResource textResource;
    private static final double MINIMUM_PULSE_TIME = 0.002;

    @Inject
    public MinimumPulseTimeValidator(TextResource textResource) {
        this.textResource = textResource;
    }

    public boolean isValid(String s) {
        return NumberUtils.isNumber((String)(s = s.replace(',', '.'))) && Double.parseDouble(s) >= 0.002;
    }

    public String getErrorMessage(String s) {
        if (StringUtils.isNullOrOnlyWhitespace((String)s) || s.equals(".")) {
            return "";
        }
        try {
            Double.parseDouble(s);
        }
        catch (Exception exception) {
            return this.textResource.notANumber();
        }
        return this.textResource.MinimumPulseValue(String.valueOf(0.002));
    }

    public String getErrorMessageEnglish(String s) {
        return "Minimum value is 0.002 s";
    }
}

