/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.resources.ButtonImageResource;
import com.ur.view.constants.modbus.ModbusConnection;
import com.ur.view.modbus.ModbusSignal;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractModbusSignalIOControlView
extends JPanel {
    private static final Icon BAD_RESPONSE_TIME_ICON = ButtonImageResource.yellowLed24();
    private static final EnumMap<ModbusConnection, Icon> CONNECTION_2_ICON = new EnumMap(ModbusConnection.class);
    protected ModbusSignal modbusSignal;
    protected JLabel connectionStatusIcon;
    protected JLabel name;
    protected int signalValue;
    private ProgramModeHolder programModeService;

    static {
        CONNECTION_2_ICON.put(ModbusConnection.CONNECTION_OK, ButtonImageResource.greenLed24());
        CONNECTION_2_ICON.put(ModbusConnection.DISCONNECTED, ButtonImageResource.grayLed24());
        CONNECTION_2_ICON.put(ModbusConnection.CONNECTING, ButtonImageResource.grayLed24());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_ILLEGAL_FUNCTION_CODE, ButtonImageResource.yellowLed24E1());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_ILLEGAL_DATA_ACCESS, ButtonImageResource.yellowLed24E2());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_ILLEGAL_DATA_VALUE, ButtonImageResource.yellowLed24E3());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_SERVER_FAILURE, ButtonImageResource.yellowLed24E4());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_ACKNOWLEDGE, ButtonImageResource.yellowLed24E5());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_SERVER_BUSY, ButtonImageResource.yellowLed24E6());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_GATEWAY_PROBLEM, ButtonImageResource.yellowLed24EA());
        CONNECTION_2_ICON.put(ModbusConnection.EXCEPTION_GATEWAY_PROBLEM_TARGET_FAILURE, ButtonImageResource.yellowLed24EB());
    }

    AbstractModbusSignalIOControlView(ModbusSignal signal, ProgramModeHolder programModeService) {
        this.modbusSignal = signal;
        this.programModeService = programModeService;
        this.name = new JLabel();
        this.connectionStatusIcon = new JLabel();
    }

    public AbstractModbusSignalIOControlView initComponents() {
        this.setLayout(new FlowLayout(0, 5, 5));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                AbstractModbusSignalIOControlView.this.modbusSignal.requestSignalUpdate();
            }
        });
        this.updatePanel();
        return this;
    }

    public void updatePanel() {
        this.name.setText(String.valueOf(this.modbusSignal.getDefaultName()) + " [" + Integer.toString(this.modbusSignal.getPin()) + ']');
        this.connectionStatusIcon.setIcon(this.getStatusIcon());
        this.signalValue = this.modbusSignal.getValue();
    }

    private Icon getStatusIcon() {
        ModbusConnection connectionStatus = this.modbusSignal.getConnectionStatus();
        Icon statusIcon = connectionStatus == ModbusConnection.CONNECTION_OK && this.modbusSignal.hasBadResponseTime() ? BAD_RESPONSE_TIME_ICON : CONNECTION_2_ICON.get(connectionStatus);
        return statusIcon == null ? CONNECTION_2_ICON.get(ModbusConnection.DISCONNECTED) : statusIcon;
    }

    protected boolean canControlSignal() {
        return !this.modbusSignal.isInput() && this.modbusSignal.getConnectionStatus() == ModbusConnection.CONNECTION_OK && (this.modbusSignal.getModificationChoice() == 0 || this.modbusSignal.getModificationChoice() == 1 && this.programModeService.getMode() != ProgramModeHolder.ProgramMode.ReadOnly);
    }

    public ModbusSignal getModbusSignal() {
        return this.modbusSignal;
    }

    abstract void setWidthOfSignalValueField(int var1);
}

