/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.AbstractBorder;

class DashLineBorder
extends AbstractBorder {
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;

    public DashLineBorder(Color color, int thickness) {
        this.lineColor = color;
        this.thickness = thickness;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.thickness > 0 && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            Stroke oldStroke = g2d.getStroke();
            g2d.setColor(this.lineColor);
            g2d.setStroke(new BasicStroke(this.thickness, 0, 2, 0.0f, new float[]{4.0f}, 1.0f));
            int offs = this.thickness;
            int size = offs + offs;
            Rectangle2D.Float outer = new Rectangle2D.Float(x, y, width, height);
            Rectangle2D.Float inner = new Rectangle2D.Float(x + offs, y + offs, width - size, height - size);
            Path2D.Float path = new Path2D.Float(0);
            path.append(outer, false);
            path.append(inner, false);
            g2d.drawLine(x, y, x + width, y);
            g2d.drawLine(x, y + height, x + width, y + height);
            g2d.drawLine(x, y, x, y + height);
            g2d.drawLine(x + width, y, x + width, y + height);
            g2d.setColor(oldColor);
            g2d.setStroke(oldStroke);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return !this.roundedCorners;
    }
}

