/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.viewfacade.resources.ViewfacadeImageResource;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.AbstractModbusSignalIOControlView;
import com.ur.view.modbus.ModbusSignal;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;

public class DigitalModbusSignalIOControlView
extends AbstractModbusSignalIOControlView
implements ActionListener {
    private final JButton signalStatusField = new JButton();
    private long timeWhenPressed;
    private Component fillBox = Box.createRigidArea(new Dimension(0, 0));

    DigitalModbusSignalIOControlView(ModbusSignal signal, ProgramModeHolder programModeService) {
        super(signal, programModeService);
    }

    @Override
    public AbstractModbusSignalIOControlView initComponents() {
        super.initComponents();
        this.signalStatusField.setBorderPainted(false);
        this.signalStatusField.setMinimumSize(new Dimension(32, 32));
        this.signalStatusField.setPreferredSize(new Dimension(32, 32));
        this.signalStatusField.setMaximumSize(new Dimension(32, 32));
        this.signalStatusField.setBackground(this.getBackground());
        this.signalStatusField.setForeground(this.getForeground());
        this.updateIcon();
        this.add(this.connectionStatusIcon);
        this.add(this.fillBox);
        this.add(this.signalStatusField);
        this.add(this.name);
        this.signalStatusField.addActionListener(this);
        return this;
    }

    @Override
    public void updatePanel() {
        long t = System.currentTimeMillis();
        if (t - this.timeWhenPressed > 200L) {
            super.updatePanel();
            this.signalStatusField.setEnabled(this.canControlSignal());
            this.updateIcon();
        }
    }

    @Override
    void setWidthOfSignalValueField(int width) {
        int fillBoxWidth = width - this.signalStatusField.getPreferredSize().width - 5;
        fillBoxWidth = fillBoxWidth < 0 ? 0 : fillBoxWidth;
        this.fillBox.setMinimumSize(new Dimension(fillBoxWidth, 28));
        this.fillBox.setPreferredSize(new Dimension(fillBoxWidth, 28));
        this.fillBox.setMaximumSize(new Dimension(fillBoxWidth, 28));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timeWhenPressed = System.currentTimeMillis();
        if (this.modbusSignal.getModbusType() == ModbusType.DIGITAL_OUTPUT) {
            this.modbusSignal.sendModbusOutputSignalChange(this.modbusSignal.getValue() == 0);
        }
        this.modbusSignal.requestSignalUpdate();
    }

    private void updateIcon() {
        this.signalStatusField.setIcon(this.signalValue == 0 ? ViewfacadeImageResource.unselectedIOEnabled() : ViewfacadeImageResource.selectedIOEnabled());
        this.signalStatusField.setDisabledIcon(this.signalValue == 0 ? ViewfacadeImageResource.unselectedIODisabled() : ViewfacadeImageResource.selectedIODisabled());
    }
}

