/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedMessageLengthInputStreamWrapper
extends DataInputStream {
    public LimitedMessageLengthInputStreamWrapper(InputStream in, long messageLength) {
        super(new LimitedInputStream(in, messageLength));
    }

    public long getCurrentPosition() {
        return ((LimitedInputStream)this.in).currentPosition;
    }

    public long getMessageLength() {
        return ((LimitedInputStream)this.in).messageLength;
    }

    private static class LimitedInputStream
    extends FilterInputStream {
        private final long messageLength;
        private long currentPosition;

        public LimitedInputStream(InputStream is, long messageLenght) {
            super(is);
            this.messageLength = messageLenght;
        }

        @Override
        public int read() throws IOException {
            if (this.currentPosition == this.messageLength) {
                throw new ReadBeyondMessageEndException("Read beyond message end. Message length = " + this.messageLength, this.currentPosition);
            }
            int b = this.in.read();
            if (b >= 0) {
                ++this.currentPosition;
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.currentPosition + (long)len >= this.messageLength) {
                throw new ReadBeyondMessageEndException("Attempt to read beyond message end. Message length = " + this.messageLength, this.currentPosition);
            }
            int n = this.in.read(b, off, len);
            if (n >= 0) {
                this.currentPosition += (long)n;
            }
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.currentPosition + n >= this.messageLength) {
                throw new ReadBeyondMessageEndException("Skip beyond message end. Message length = " + this.messageLength, this.currentPosition);
            }
            if ((n = this.in.skip(n)) >= 0L) {
                this.currentPosition += n;
            }
            return n;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }
    }

    public static class ReadBeyondMessageEndException
    extends IOException {
        private long bytesRead;

        public ReadBeyondMessageEndException(String message, long bytesRead) {
            super(message);
            this.bytesRead = bytesRead;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }
    }
}

