/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.ModbusInterface;
import com.ur.view.modbus.ModbusSignal;
import com.ur.view.modbus.ModbusUnit;
import gui.tools.LanguagePack;

public class Modbus
extends InstallationNode {
    private final ModbusInterface modbusInterface;

    public Modbus(ModbusInterface modbusInterface) {
        this.modbusInterface = modbusInterface;
    }

    public String getTypeName() {
        return LanguagePack.getTextResource().modbusClient();
    }

    public ScriptWriter generatePreambleScript(ScriptWriter writer) {
        return writer;
    }

    public void generateScriptCodeForAdding(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        this.getScriptGenerator().setScriptGeneratorLookup(scriptGeneratorLookup);
        this.getScriptGenerator().scriptBegin(writer);
        for (ModbusUnit unit : this.modbusInterface) {
            for (ModbusSignal sig : unit.getSignals()) {
                sig.generateScriptCodeForAdding(writer);
            }
        }
        this.getScriptGenerator().scriptEnd(writer);
    }

    public void generateScriptCodeForOutputs(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        this.getScriptGenerator().setScriptGeneratorLookup(scriptGeneratorLookup);
        this.getScriptGenerator().scriptBegin(writer);
        for (ModbusUnit unit : this.modbusInterface) {
            for (ModbusSignal sig : unit.getSignals()) {
                if (sig.getModbusType() != ModbusType.DIGITAL_OUTPUT && sig.getModbusType() != ModbusType.REGISTER_OUTPUT) continue;
                writer.appendLine(sig.generateRunstateDependentChoice());
            }
        }
        this.getScriptGenerator().scriptEnd(writer);
    }
}

