/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.pin.service.IOInterface;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.ArrayUtils;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.ModbusInstallation;
import com.ur.view.modbus.ModbusSignal;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;

public class ModbusIOInterface
implements IOInterface {
    private final ModbusInstallation lookup;

    @Inject
    public ModbusIOInterface(ModbusInstallation lookup) {
        this.lookup = lookup;
    }

    public Collection<? extends Pin<?>> getInputs(IOService.IOInterfaceType type, IOService.IOSignalType ... filters) {
        ArrayList<ModbusSignal> result = new ArrayList<ModbusSignal>();
        if (EqualsUtil.notEqualsOneOf((Object)type, (Object[])new IOService.IOInterfaceType[]{IOService.IOInterfaceType.ALL, IOService.IOInterfaceType.MODBUS})) {
            return result;
        }
        if (ArrayUtils.contains((Object)IOService.IOSignalType.ALL, (Object[])filters)) {
            result.addAll(this.getAllOfType(ModbusType.DIGITAL_INPUT));
            result.addAll(this.getAllOfType(ModbusType.REGISTER_INPUT));
            return result;
        }
        if (ArrayUtils.contains((Object)IOService.IOSignalType.DIGITAL, (Object[])filters)) {
            result.addAll(this.getAllOfType(ModbusType.DIGITAL_INPUT));
        }
        if (ArrayUtils.contains((Object)IOService.IOSignalType.Integer, (Object[])filters)) {
            result.addAll(this.getAllOfType(ModbusType.REGISTER_INPUT));
        }
        return result;
    }

    public Collection<? extends Pin<?>> getOutputs(IOService.IOInterfaceType type, IOService.IOSignalType ... filters) {
        ArrayList<ModbusSignal> result = new ArrayList<ModbusSignal>();
        if (EqualsUtil.notEqualsOneOf((Object)type, (Object[])new IOService.IOInterfaceType[]{IOService.IOInterfaceType.ALL, IOService.IOInterfaceType.MODBUS})) {
            return result;
        }
        if (ArrayUtils.contains((Object)IOService.IOSignalType.ALL, (Object[])filters)) {
            result.addAll(this.getAllOfType(ModbusType.DIGITAL_OUTPUT));
            result.addAll(this.getAllOfType(ModbusType.REGISTER_OUTPUT));
            return result;
        }
        if (ArrayUtils.contains((Object)IOService.IOSignalType.DIGITAL, (Object[])filters)) {
            result.addAll(this.getAllOfType(ModbusType.DIGITAL_OUTPUT));
        }
        if (ArrayUtils.contains((Object)IOService.IOSignalType.Integer, (Object[])filters)) {
            result.addAll(this.getAllOfType(ModbusType.REGISTER_OUTPUT));
        }
        return result;
    }

    private Collection<ModbusSignal> getAllOfType(ModbusType type) {
        return this.lookup.getModbusInterface().getAllOfType(type);
    }
}

