/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.swing.CardPanel;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.util.Predicate;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.AbstractModbusSignalIOControlView;
import com.ur.view.modbus.DigitalModbusSignalIOControlView;
import com.ur.view.modbus.ModbusIOTabLayout;
import com.ur.view.modbus.ModbusInfoMessage;
import com.ur.view.modbus.ModbusInfoMessageListener;
import com.ur.view.modbus.ModbusInstallation;
import com.ur.view.modbus.ModbusInterface;
import com.ur.view.modbus.ModbusSignal;
import com.ur.view.modbus.ModbusUnit;
import com.ur.view.modbus.RegisterOutputModbusSignalIOControlView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

@Singleton
public class ModbusIOTab
extends CardPanel
implements ModbusInfoMessageListener,
ActionListener {
    public static final String SHOW_MODBUS_TAB = "showModbus.ModbusIOTab";
    public static final String MODBUS_TYPE_SELECTOR = "com.ur.view.modbus.ModbusIOTab.modbusTypeSelector";
    public static final String MODBUS_UNIT_SELECTOR = "com.ur.view.modbus.ModbusIOTab.modbusUnitSelector";
    public static final String MODBUS_UNIT_SELECTOR_PANEL = "com.ur.view.modbus.ModbusIOTab.modbusUnitSelectorPanel";
    public static final String INPUT_PANEL = "com.ur.view.modbus.ModbusIOTab.inputPanel";
    public static final String OUTPUT_PANEL = "com.ur.view.modbus.ModbusIOTab.outputPanel";
    private JComboBox modbusTypeSelector = new JComboBox<ModbusTypeFilter>(ModbusTypeFilter.values());
    private JComboBox modbusUnitSelector = new JComboBox();
    private JPanel modbusUnitSelectorPanel = new JPanel();
    private JPanel inputListBoxPanel = new JPanel();
    private JPanel outputsListBoxPanel = new JPanel();
    protected final ProgramModeHolder programModeService;
    protected final ModbusInstallation lookup;
    protected final ViewContext view;
    protected final TextResource textResource;
    protected final ModbusIOTabLayout layout;
    private ModbusInterface modbusInterface;
    protected final HashMap<String, AbstractModbusSignalIOControlView> map = new HashMap();

    @Inject
    public ModbusIOTab(ViewContext view, ModbusInstallation lookup, ProgramModeHolder programModeService, ModbusIOTabLayout layout) {
        this.view = view;
        this.lookup = lookup;
        this.programModeService = programModeService;
        this.modbusInterface = lookup.getModbusInterface();
        this.layout = layout;
        this.textResource = (TextResource)view.getTextResource(TextResource.class);
    }

    public ModbusIOTab initComponents() {
        this.setLayout(new BorderLayout());
        this.modbusTypeSelector.setRenderer(new ModbusTypeFilterCellRenderer(this.textResource));
        this.add(this.buildHeaderPanel(), "North");
        this.add(this.buildIOListPanels(), "Center");
        this.setNames();
        this.view.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:modbus_io");
        return this;
    }

    private void setNames() {
        this.setName(SHOW_MODBUS_TAB);
        this.modbusTypeSelector.setName(MODBUS_TYPE_SELECTOR);
        this.modbusUnitSelector.setName(MODBUS_UNIT_SELECTOR);
        this.modbusUnitSelectorPanel.setName(MODBUS_UNIT_SELECTOR_PANEL);
        this.inputListBoxPanel.setName(INPUT_PANEL);
        this.outputsListBoxPanel.setName(OUTPUT_PANEL);
    }

    private JPanel buildHeaderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.modbusTypeSelector.setSelectedItem((Object)ModbusTypeFilter.ALL);
        this.modbusTypeSelector.addActionListener(this);
        this.modbusTypeSelector.setPreferredSize(new Dimension(200, 28));
        jPanel.add(new JLabel(String.valueOf(this.textResource.ModbusType()) + ": "));
        jPanel.add(this.modbusTypeSelector);
        this.modbusUnitSelector.addActionListener(this);
        this.modbusUnitSelector.setPreferredSize(new Dimension(200, 28));
        this.populateModbusUnitSelector();
        this.modbusUnitSelectorPanel.add(new JLabel(String.valueOf(this.textResource.ModbusUnit()) + ": "));
        this.modbusUnitSelectorPanel.add(this.modbusUnitSelector);
        jPanel.add(this.modbusUnitSelectorPanel);
        return jPanel;
    }

    private JPanel buildIOListPanels() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2, 10, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.inputListBoxPanel.setLayout(new BoxLayout(this.inputListBoxPanel, 3));
        this.inputListBoxPanel.setBackground(Color.WHITE);
        JScrollPane inputsScrollPane = this.layout.createScrollPane(this.textResource.Inputs(), ModbusIOTab.buildListPanel(this.inputListBoxPanel));
        panel.add(inputsScrollPane);
        this.outputsListBoxPanel.setLayout(new BoxLayout(this.outputsListBoxPanel, 3));
        this.outputsListBoxPanel.setBackground(Color.WHITE);
        JScrollPane outputsScrollPane = this.layout.createScrollPane(this.textResource.Outputs(), ModbusIOTab.buildListPanel(this.outputsListBoxPanel));
        panel.add(outputsScrollPane);
        return panel;
    }

    private static JPanel buildListPanel(JPanel listBoxPanel) {
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)listBoxPanel, "North");
        listPanel.setBackground(Color.WHITE);
        new URFingerDragScrollMouseListener((Component)listPanel);
        return listPanel;
    }

    private void populateModbusUnitSelector() {
        Object oldSelection = this.modbusUnitSelector.getSelectedItem() == null ? this.textResource.iofilterAll() : this.modbusUnitSelector.getSelectedItem();
        this.modbusUnitSelector.removeAllItems();
        this.modbusUnitSelector.insertItemAt(this.textResource.iofilterAll(), 0);
        this.modbusUnitSelector.setSelectedIndex(0);
        for (ModbusUnit modbusUnit : this.modbusInterface) {
            this.modbusUnitSelector.addItem(modbusUnit.getIP());
        }
        this.modbusUnitSelector.setSelectedItem(oldSelection);
        this.modbusUnitSelectorPanel.setVisible(this.modbusUnitSelector.getItemCount() > 2);
    }

    @Override
    public void handleModbusInfoMessage(ModbusInfoMessage modbusInfoMessage) {
        for (ModbusSignal signal : this.modbusInterface.getModbusSignals()) {
            AbstractModbusSignalIOControlView panel = this.map.get(signal.getName());
            if (panel == null) continue;
            panel.updatePanel();
        }
    }

    public void enter(Object o) {
        super.enter(o);
        this.modbusInterface = this.lookup.getModbusInterface();
        this.populateModbusUnitSelector();
        this.populateIOListBox();
        ModbusInfoMessage.subscribe(this);
    }

    public Object exit() {
        ModbusInfoMessage.unsubscribe(this);
        return super.exit();
    }

    private void populateIOListBox() {
        this.map.clear();
        Collection<ModbusSignal> modbusSignals = this.modbusInterface.getModbusSignals();
        Map<String, Map<ModbusType, List<ModbusSignal>>> inputSignals = ModbusIOTab.groupSignals(modbusSignals, new ListFilter(true));
        this.addSignalsToPanel(this.inputListBoxPanel, inputSignals);
        Map<String, Map<ModbusType, List<ModbusSignal>>> outputSignals = ModbusIOTab.groupSignals(modbusSignals, new ListFilter(false));
        this.addSignalsToPanel(this.outputsListBoxPanel, outputSignals);
    }

    private static Map<String, Map<ModbusType, List<ModbusSignal>>> groupSignals(Collection<ModbusSignal> signals, Predicate<ModbusSignal> predicate) {
        HashMap<String, Map<ModbusType, List<ModbusSignal>>> signalGroups = new HashMap<String, Map<ModbusType, List<ModbusSignal>>>();
        for (ModbusSignal signal : signals) {
            if (!predicate.test((Object)signal)) continue;
            String signalIP = signal.getModbusUnit().getIP();
            ModbusType signalType = signal.getModbusType();
            if (!signalGroups.containsKey(signalIP)) {
                signalGroups.put(signalIP, new EnumMap(ModbusType.class));
            }
            if (!((Map)signalGroups.get(signalIP)).containsKey(signalType)) {
                ((Map)signalGroups.get(signalIP)).put(signalType, new ArrayList());
            }
            ((List)((Map)signalGroups.get(signalIP)).get(signalType)).add(signal);
        }
        return signalGroups;
    }

    private void addSignalsToPanel(JPanel container, Map<String, Map<ModbusType, List<ModbusSignal>>> signals) {
        container.removeAll();
        for (Map.Entry<String, Map<ModbusType, List<ModbusSignal>>> mu : signals.entrySet()) {
            container.add(this.buildModbusUnitHeader(String.valueOf(this.textResource.ModbusUnit()) + ": " + mu.getKey()));
            for (Map.Entry<ModbusType, List<ModbusSignal>> signalType : mu.getValue().entrySet()) {
                for (ModbusSignal signal : signalType.getValue()) {
                    AbstractModbusSignalIOControlView panel = this.createModbusSignalView(signal);
                    this.map.put(signal.getName(), panel);
                    container.add(panel);
                }
            }
        }
        container.invalidate();
    }

    private JPanel buildModbusUnitHeader(String title) {
        JPanel modbusUnitHeader = new JPanel();
        modbusUnitHeader.setLayout(new FlowLayout(0));
        modbusUnitHeader.setBackground(UIManager.getColor("List.selectionBackground"));
        JLabel modbusUnitText = new JLabel(title);
        modbusUnitText.setFont(this.view.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        modbusUnitHeader.add(modbusUnitText);
        return modbusUnitHeader;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.populateIOListBox();
    }

    private AbstractModbusSignalIOControlView createModbusSignalView(ModbusSignal signal) {
        AbstractModbusSignalIOControlView result;
        switch (signal.getModbusType()) {
            case DIGITAL_INPUT: 
            case DIGITAL_OUTPUT: {
                result = new DigitalModbusSignalIOControlView(signal, this.programModeService).initComponents();
                break;
            }
            case REGISTER_INPUT: 
            case REGISTER_OUTPUT: {
                result = new RegisterOutputModbusSignalIOControlView(signal, this.programModeService, this.view).initComponents();
                break;
            }
            default: {
                result = new EmptyModbusSignalIOControlView(signal, this.programModeService).initComponents();
            }
        }
        return this.layout.adjustModbusSignalView(result);
    }

    public static class EmptyModbusSignalIOControlView
    extends AbstractModbusSignalIOControlView {
        EmptyModbusSignalIOControlView(ModbusSignal signal, ProgramModeHolder programModeService) {
            super(signal, programModeService);
        }

        @Override
        public AbstractModbusSignalIOControlView initComponents() {
            this.removeAll();
            this.setPreferredSize(new Dimension(0, 0));
            this.setVisible(false);
            return this;
        }

        @Override
        void setWidthOfSignalValueField(int width) {
        }
    }

    private class ListFilter
    implements Predicate<ModbusSignal> {
        private boolean isInputFilter;

        ListFilter(boolean isInput) {
            this.isInputFilter = isInput;
        }

        public boolean test(ModbusSignal signal) {
            return signal.isInput() == this.isInputFilter && this.getModbusTypeFilter().test(signal) && this.isModbusUnitSelected(signal);
        }

        private ModbusTypeFilter getModbusTypeFilter() {
            return ModbusIOTab.this.modbusTypeSelector.getSelectedItem() instanceof ModbusTypeFilter ? (ModbusTypeFilter)((Object)ModbusIOTab.this.modbusTypeSelector.getSelectedItem()) : ModbusTypeFilter.ALL;
        }

        private boolean isModbusUnitSelected(ModbusSignal signal) {
            if (ModbusIOTab.this.modbusUnitSelector.getSelectedIndex() == 0) {
                return true;
            }
            return signal.getModbusUnit().getIP().equals(ModbusIOTab.this.modbusUnitSelector.getSelectedItem());
        }
    }

    public static enum ModbusTypeFilter implements Predicate<ModbusSignal>
    {
        ALL,
        DIGITAL,
        REGISTER;


        public boolean test(ModbusSignal signal) {
            switch (this) {
                case DIGITAL: {
                    return signal.getModbusType() == ModbusType.DIGITAL_INPUT || signal.getModbusType() == ModbusType.DIGITAL_OUTPUT;
                }
                case REGISTER: {
                    return signal.getModbusType() == ModbusType.REGISTER_INPUT || signal.getModbusType() == ModbusType.REGISTER_OUTPUT;
                }
            }
            return true;
        }
    }

    private static class ModbusTypeFilterCellRenderer
    extends DefaultComboBoxRenderer {
        private TextResource textResource;

        ModbusTypeFilterCellRenderer(TextResource textResource) {
            this.textResource = textResource;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(this.textResource.ModbusTypeFilter((ModbusTypeFilter)((Object)value)));
            return this;
        }
    }
}

