/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.util.logging.Log;
import com.ur.view.modbus.ModbusInfoMessageListener;
import com.ur.view.modbus.ModbusInterface;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;

class ModbusInfoMessage {
    private static final CopyOnWriteArraySet<ModbusInfoMessageListener> modbusInfoMessageListenerSet = new CopyOnWriteArraySet();
    private static final AtomicBoolean notifySubscribersQueued = new AtomicBoolean(false);
    private static final AtomicReference<SubscriptionReference> subscriptionReference = new AtomicReference();
    private final List<Unit> unitsInfoList;
    private Vector<Signal> signalValueList = new Vector();
    private ModbusInterface modbusInterface;

    public ModbusInfoMessage(ModbusInterface installationModbusInterface) {
        this.unitsInfoList = new ArrayList<Unit>(8);
        this.modbusInterface = installationModbusInterface;
    }

    public static void subscribe(ModbusInfoMessageListener modbusInfoMessageListener) {
        modbusInfoMessageListenerSet.add(modbusInfoMessageListener);
        if (modbusInfoMessageListenerSet.size() > 10) {
            System.err.println("There are now " + modbusInfoMessageListenerSet.size() + " modbus message subscribers!");
        }
    }

    public static boolean unsubscribe(ModbusInfoMessageListener modbusInfoMessageListener) {
        return modbusInfoMessageListenerSet.remove(modbusInfoMessageListener);
    }

    public void addSignal(String signalName, int value, int responseTime, int signalTimeSinceLastUpdateInMs, int signalConnectionStatus, int signalFailedSend, int signalRequestTimeouts, double signalAvgResponseFrequency) {
        this.signalValueList.add(new Signal(signalName, value, responseTime, signalTimeSinceLastUpdateInMs, signalConnectionStatus, signalFailedSend, signalRequestTimeouts, signalAvgResponseFrequency));
    }

    public Vector<Signal> getSignals() {
        return this.signalValueList;
    }

    public void addUnitInfo(Unit unit) {
        if (unit == null) {
            throw new InvalidParameterException();
        }
        this.unitsInfoList.add(unit);
    }

    public List<Unit> getUnitsInfoList() {
        return this.unitsInfoList;
    }

    private static void handleModbusInfoMessageSwingThreadSafe() {
        notifySubscribersQueued.set(false);
        SubscriptionReference reference = subscriptionReference.get();
        ModbusInfoMessage modbusInfoMessage = reference.getModbusInfoMessage();
        ModbusInterface modbusInterface = reference.getModbusInterface();
        modbusInterface.updateModbusSignalStatus(modbusInfoMessage);
        for (ModbusInfoMessageListener modbusInfoMessageListener : modbusInfoMessageListenerSet) {
            modbusInfoMessageListener.handleModbusInfoMessage(modbusInfoMessage);
        }
    }

    public void notifyAllSubscribers() throws InterruptedException {
        subscriptionReference.set(new SubscriptionReference(this, this.modbusInterface));
        if (notifySubscribersQueued.getAndSet(true)) {
            Log.debug((String)"Update already queued, notifying subscribers faster than UI thread can handle. Previous updates will be skipped.");
            return;
        }
        Runnable doWorkRunnable = ModbusInfoMessage::handleModbusInfoMessageSwingThreadSafe;
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Signal sig : this.signalValueList) {
            s.append(sig.signal_name).append(": ").append(sig.signal_value).append(" response time = ").append(sig.signal_responseTimeInMs).append(", time since last update = ").append(sig.signal_timeSinceLastUpdateInMs).append(", connection status = ").append(sig.signal_connectionStatus);
            s.append("\n");
        }
        for (Unit unit : this.unitsInfoList) {
            s.append(unit.ipAddress).append(" failed connects = ").append(unit.failedConnects).append(", invalid packets = ").append(unit.invalidPackets).append(", last connect errno = ").append(unit.lastConnectErrorCode);
            s.append("\n");
        }
        return s.toString();
    }

    public static class Signal {
        public final String signal_name;
        public final int signal_value;
        public final int signal_responseTimeInMs;
        public final int signal_timeSinceLastUpdateInMs;
        public final int signal_connectionStatus;
        public final int signal_failedSend;
        public final int signal_requestTimeouts;
        public final double signal_avgResponseFrequency;

        Signal(String name, int value, int responseTimeInMs, int signalTimeSinceLastUpdateInMs, int signalConnectionStatus, int signalFailedSend, int signalRequestTimeouts, double signalAvgResponseFrequency) {
            this.signal_name = name;
            this.signal_value = value;
            this.signal_responseTimeInMs = responseTimeInMs;
            this.signal_timeSinceLastUpdateInMs = signalTimeSinceLastUpdateInMs;
            this.signal_connectionStatus = signalConnectionStatus;
            this.signal_failedSend = signalFailedSend;
            this.signal_requestTimeouts = signalRequestTimeouts;
            this.signal_avgResponseFrequency = signalAvgResponseFrequency;
        }
    }

    private static class SubscriptionReference {
        private final ModbusInfoMessage modbusInfoMessage;
        private final ModbusInterface modbusInterface;

        private SubscriptionReference(ModbusInfoMessage modbusInfoMessage, ModbusInterface modbusInterface) {
            this.modbusInfoMessage = modbusInfoMessage;
            this.modbusInterface = modbusInterface;
        }

        public ModbusInfoMessage getModbusInfoMessage() {
            return this.modbusInfoMessage;
        }

        public ModbusInterface getModbusInterface() {
            return this.modbusInterface;
        }
    }

    public static class Unit {
        public final String ipAddress;
        public final int failedConnects;
        public final int invalidPackets;
        public final int lastConnectErrorCode;

        public Unit(String ipAddress, int failedConnects, int invalidPacket, int lastConnectErrorCode) {
            this.ipAddress = ipAddress;
            this.failedConnects = failedConnects;
            this.invalidPackets = invalidPacket;
            this.lastConnectErrorCode = lastConnectErrorCode;
        }

        public static Unit deserialize(DataInputStream inputByteStream) throws IOException {
            int muStatusLength = inputByteStream.readUnsignedShort();
            if (muStatusLength == 24) {
                byte[] buf = new byte[16];
                inputByteStream.readFully(buf);
                return new Unit(new String(buf).trim(), inputByteStream.readUnsignedShort(), inputByteStream.readUnsignedShort(), inputByteStream.readShort());
            }
            Log.warning((String)("Modbus unit: unsupported structure version  (" + muStatusLength + "), skipping"));
            inputByteStream.skipBytes(muStatusLength - 2);
            return null;
        }
    }
}

