/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.view.constants.modbus.ModbusConnection;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.ModbusInfoMessage;
import com.ur.view.modbus.ModbusSignal;
import com.ur.view.modbus.ModbusUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.inject.Inject;

public class ModbusInterface
implements Iterable<ModbusUnit> {
    private final ArrayList<ModbusUnit> modbusUnits = new ArrayList();
    private final NamingService namingService;
    private final RobotInstallationSite installationSite;

    @Inject
    public ModbusInterface(NamingService namingService, RobotInstallationSite installationSite) {
        this.namingService = namingService;
        this.installationSite = installationSite;
    }

    private Iterable<ModbusUnit> getModbusUnits() {
        return this.modbusUnits;
    }

    @Override
    public Iterator<ModbusUnit> iterator() {
        return this.modbusUnits.iterator();
    }

    public Collection<ModbusSignal> getModbusSignals() {
        ArrayList<ModbusSignal> signalList = new ArrayList<ModbusSignal>();
        for (ModbusUnit unit : this.getModbusUnits()) {
            for (ModbusSignal signal : unit.getSignals()) {
                signalList.add(signal);
            }
        }
        return signalList;
    }

    public void addUnit(ModbusUnit unit) {
        this.modbusUnits.add(unit);
    }

    public void deleteUnit(ModbusUnit unit) {
        this.deleteSignals(unit);
        this.modbusUnits.remove(unit);
    }

    private void deleteSignals(ModbusUnit unit) {
        for (ModbusSignal sig : new ArrayList<ModbusSignal>(unit.getSignals())) {
            this.deleteSignal(sig);
        }
    }

    public void deleteSignal(ModbusSignal sig) {
        ModbusUnit modbusUnit = sig.getModbusUnit();
        modbusUnit.removeSignal(sig);
        this.namingService.deregisterNamedEntity((NamedEntity)sig);
    }

    public void updateModbusSignalStatus(ModbusInfoMessage message) {
        HashMap<String, ModbusSignal> map = new HashMap<String, ModbusSignal>();
        for (ModbusUnit mu : this.modbusUnits) {
            for (ModbusSignal signal : mu.getSignals()) {
                map.put(signal.getName(), signal);
            }
        }
        for (ModbusInfoMessage.Signal sig : message.getSignals()) {
            if (!map.containsKey(sig.signal_name)) continue;
            ModbusSignal modbusSignal = (ModbusSignal)map.get(sig.signal_name);
            modbusSignal.setValue(sig.signal_value);
            modbusSignal.setSignalResponseTime(sig.signal_responseTimeInMs);
            modbusSignal.setTimeSinceLastUpdateInMs(sig.signal_timeSinceLastUpdateInMs);
            modbusSignal.setConnectionStatus(ModbusConnection.byId((int)sig.signal_connectionStatus));
            modbusSignal.setFailedSendCounter(sig.signal_failedSend);
            modbusSignal.setRequestTimeoutsCounter(sig.signal_requestTimeouts);
            modbusSignal.setAvgResponseFrequency(sig.signal_avgResponseFrequency);
        }
    }

    public ModbusSignal getSignal(String signalName) {
        for (ModbusUnit unit : this.getModbusUnits()) {
            for (ModbusSignal sig : unit.getSignals()) {
                if (!signalName.equals(sig.getName())) continue;
                return sig;
            }
        }
        return null;
    }

    public void loadTest() {
        if (this.configurationInstantiatedAndInstallationLoaded()) {
            for (ModbusUnit mu : this.getModbusUnits()) {
                for (ModbusSignal signal : mu.getSignals()) {
                    signal.loadTest();
                }
            }
        }
    }

    public void startModbusConnections() {
        if (this.configurationInstantiatedAndInstallationLoaded()) {
            for (ModbusUnit mu : this.getModbusUnits()) {
                for (ModbusSignal signal : mu.getSignals()) {
                    signal.startSignalConnection();
                }
            }
        }
    }

    public void stopModbusConnections() {
        if (this.configurationInstantiatedAndInstallationLoaded()) {
            for (ModbusUnit unit : this.getModbusUnits()) {
                for (ModbusSignal sig : unit.getSignals()) {
                    sig.stopSignalConnection();
                }
            }
        }
    }

    private boolean configurationInstantiatedAndInstallationLoaded() {
        return this.installationSite.getInstallation() != null;
    }

    public Collection<ModbusSignal> getAllOfType(ModbusType ... types) {
        ArrayList<ModbusSignal> result = new ArrayList<ModbusSignal>();
        for (ModbusUnit mu : this.getModbusUnits()) {
            for (ModbusSignal signal : mu.getSignals()) {
                if (!EqualsUtil.equalsOneOf((Object)signal.getModbusType(), (Object[])types)) continue;
                result.add(signal);
            }
        }
        return result;
    }

    public void clear() {
        Iterator<ModbusUnit> iterator = this.iterator();
        while (iterator.hasNext()) {
            ModbusUnit mu = iterator.next();
            this.deleteSignals(mu);
            iterator.remove();
        }
    }

    public int numberOfUnits() {
        return this.modbusUnits.size();
    }
}

