/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.MessageType;
import com.ur.view.modbus.LimitedMessageLengthInputStreamWrapper;
import com.ur.view.modbus.ModbusInfoMessage;
import com.ur.view.modbus.ModbusInstallation;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;

public class ModbusMessageConsumer
implements MessageConsumer {
    private final ModbusInstallation lookupService;

    @Inject
    public ModbusMessageConsumer(ModbusInstallation lookupService) {
        this.lookupService = lookupService;
    }

    public MessageType getPackageType() {
        return MessageType.MODBUS_INFO_MESSAGE;
    }

    public int consume(DataInput dataInputStream, int messageLength) throws IOException {
        int messageOffset = 0;
        boolean messageHasError = false;
        int byteCount = 0;
        int signalsCount = 0;
        if (byteCount + 4 <= messageLength) {
            signalsCount = dataInputStream.readInt();
            messageOffset += 4;
            byteCount += 4;
            if (signalsCount > 200) {
                Log.error((String)("Modbus error -1: We received a modbus message but signalsCount = " + signalsCount + " which must mean that data is corrupted"));
                messageHasError = true;
            }
        } else {
            Log.error((String)"Modbus error 0: We received a modbus message but it did not contain a signals count variable");
            messageHasError = true;
        }
        if (!messageHasError) {
            int i;
            ModbusInfoMessage modbusInfoMessage = new ModbusInfoMessage(this.lookupService.getModbusInterface());
            if (signalsCount > 0) {
                int signalNameLength = 0;
                i = 0;
                block4: while (i < signalsCount) {
                    if (byteCount + 2 < messageLength) {
                        signalNameLength = dataInputStream.readUnsignedShort();
                        messageOffset += 2;
                        byteCount += 2;
                        if (Math.abs(signalNameLength) > 20) {
                            Log.error((String)("Modbus error 1: signalNameLength > 20: signalNameLength = " + signalNameLength + ", signal number " + i + " in message"));
                            messageHasError = true;
                            break;
                        }
                    } else {
                        Log.error((String)("Modbus error 2: Could not read signal name length of signal number: " + i + ". Total number of signals = " + signalsCount));
                        messageHasError = true;
                        break;
                    }
                    char[] signalNameChars = new char[signalNameLength];
                    int j = 0;
                    while (j < signalNameChars.length) {
                        if (++byteCount < messageLength) {
                            signalNameChars[j] = (char)dataInputStream.readByte();
                            ++messageOffset;
                        } else {
                            Log.error((String)("Modbus error 3: Could not read character j = " + j + " of signalNameLength = " + signalNameLength + ". Total number of signals = " + signalsCount));
                            messageHasError = true;
                            break block4;
                        }
                        ++j;
                    }
                    String signalName = new String(signalNameChars);
                    if (byteCount + 12 + 1 <= messageLength) {
                        byteCount += 13;
                        int signalStatusInt = dataInputStream.readUnsignedShort();
                        int signalResponseTimeInMs = dataInputStream.readUnsignedShort();
                        int signalTimeSinceLastUpdateInMs = dataInputStream.readUnsignedShort();
                        byte signalConnectionStatus = dataInputStream.readByte();
                        int signalFailedSend = dataInputStream.readUnsignedShort();
                        int signalRequestTimeouts = dataInputStream.readUnsignedShort();
                        int responseFrequencyRaw = dataInputStream.readUnsignedShort();
                        double signalAvgResponseFrequency = (float)responseFrequencyRaw / 10.0f;
                        if (responseFrequencyRaw == 65535) {
                            signalAvgResponseFrequency = -1.0;
                        }
                        modbusInfoMessage.addSignal(signalName, signalStatusInt, signalResponseTimeInMs, signalTimeSinceLastUpdateInMs, signalConnectionStatus, signalFailedSend, signalRequestTimeouts, signalAvgResponseFrequency);
                        messageOffset += 13;
                    } else {
                        Log.error((String)("Modbus error 4: Could not read signal status of signal i=" + i + ", name=" + signalName + ", sigcount = " + signalsCount));
                        messageHasError = true;
                        break;
                    }
                    ++i;
                }
            }
            if (byteCount + 2 <= messageLength) {
                try {
                    LimitedMessageLengthInputStreamWrapper messageDataInputStream = new LimitedMessageLengthInputStreamWrapper((InputStream)((Object)dataInputStream), messageLength - byteCount);
                    int modbusUnits = messageDataInputStream.readUnsignedShort();
                    i = 0;
                    while (i < modbusUnits) {
                        ModbusInfoMessage.Unit u = ModbusInfoMessage.Unit.deserialize(messageDataInputStream);
                        if (u != null) {
                            modbusInfoMessage.addUnitInfo(u);
                        }
                        ++i;
                    }
                    messageOffset = (int)((long)messageOffset + messageDataInputStream.getCurrentPosition());
                    byteCount = (int)((long)byteCount + messageDataInputStream.getCurrentPosition());
                }
                catch (LimitedMessageLengthInputStreamWrapper.ReadBeyondMessageEndException e) {
                    messageOffset = (int)((long)messageOffset + e.getBytesRead());
                    byteCount = (int)((long)byteCount + e.getBytesRead());
                }
            }
            try {
                if (byteCount == messageLength && !messageHasError) {
                    modbusInfoMessage.notifyAllSubscribers();
                } else if (!(byteCount <= messageLength && byteCount >= messageLength || messageHasError)) {
                    Log.error((String)("Modbus error 5: Bytes read does not match message length, message = " + modbusInfoMessage.toString() + ", signalsCount = " + signalsCount + ", messageLength = " + messageLength + ", byteCount = " + byteCount));
                } else if (messageHasError) {
                    Log.error((String)"Modbus error 6: An error was detected during modbus message parsing");
                }
            }
            catch (Exception e) {
                Log.error((String)"Modbus error 7: ModbusInfoMessage.notifyAllSubscribers failed: ", (Throwable)e);
            }
        } else {
            Log.error((String)"Modbus error 8: Could not extract modbus information from controller message");
        }
        if (byteCount < messageLength) {
            Log.error((String)("Modbus error 9: too few bytes read, signalsCount = " + signalsCount + " messageLength = " + messageLength + ", byteCount = " + byteCount));
            Log.error((String)"Reading rest of message...");
            while (++byteCount <= messageLength) {
                dataInputStream.readByte();
            }
            Log.error((String)" Reading rest of message done");
        }
        return messageOffset;
    }

    public void initialize(RobotState robotStateToEditHere) {
    }
}

