/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.InstallationNodeInfo;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.pin.PinObserver;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.polyscope.viewfacade.resources.ViewfacadeImageResource;
import com.ur.resources.ButtonImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.GuiUtilities;
import com.ur.swing.TextProvider;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.constants.modbus.ModbusConnection;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.help.HelpLoader;
import com.ur.view.modbus.DashLineBorder;
import com.ur.view.modbus.ModbusInfoMessage;
import com.ur.view.modbus.ModbusInfoMessageListener;
import com.ur.view.modbus.ModbusInstallation;
import com.ur.view.modbus.ModbusSignal;
import com.ur.view.modbus.ModbusUnit;
import gui.polyscope.setup.UnknownSignalType;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.dialogs.input.NameValidationFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Format;
import java.util.HashMap;
import java.util.Vector;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.JTextComponent;

public class ModbusSetupTab
extends CardPanel
implements ModbusInfoMessageListener,
InstallationNodeInfo {
    public static final int MAX_SIGNALS = 56;
    public static final String REMOVE_MODBUS_UNIT = "removeModbusUnit.modbusSetupTab";
    public static final String REFRESH_LIST = "refreshList.modbusSetupTab";
    public static final String ADD_MODBUS_SIGNAL = "addModbusSignal.modbusSetupTab";
    public static final String ADD_MODBUS_UNIT = "addModbusUnit.modbusSetupTab";
    public static final String MODBUS_SIGNAL_TYPE = "modbusSignalType.modbusSetupTab";
    public static final String MODBUS_SIGNAL_NAME = "modbusSignalName.modbusSetupTab";
    public static final String EDIT_MODBUS_SIGNAL_OUTPUT_REGISTER = "editModbusSignalOutputRegister.modbusSetupTab";
    public static final String SHOW_MODBUS_ACTION = "showModbusAction.ModbusSetupTab";
    public static final String ADVANCED_OPTIONS = "advancedOptionsCheckBox.modbusSetupTab";
    public static final Color HIGHLIGHT_SECTION = new Color(245, 245, 245);
    public static final String MODBUS_SETUP_ADD_UNIT = "gui:installation_modbus_setup_addUnit";
    public static final String STYLE_REPONSE_TIME = ": %4d,   ";
    private static final int MODBUS_ADDRESS_MAX = 65535;
    private static final int MODBUS_REGISTER_VALUE_MAX = 65535;
    private static final int SLAVE_ADDRESS_MAX = 255;
    private static boolean showPopupDialog = true;
    private static HashMap<ModbusSignal, SignalPanel> nameSignalPanelMap;
    private static HashMap<ModbusUnit, ModbusUnitPanel> modbusUnitPanelMap;
    private final Icon inactiveIcon;
    private final Icon onIcon;
    private final Icon badResponseTimeIcon;
    private final Icon error1Icon;
    private final Icon error2Icon;
    private final Icon error3Icon;
    private final Icon error4Icon;
    private final Icon error5Icon;
    private final Icon error6Icon;
    private final Icon errorAIcon;
    private final Icon errorBIcon;
    private final NamingService namingService;
    private final ErrorDialogCreator errorDialogCreator;
    private final HelpIdAssigner helpIdAssigner;
    private ModbusInstallation lookupService;
    private ViewContext view;
    private URFontFactory fontFactory;
    private boolean showAdvancedOptions = false;
    private int signalPanelCounter = 0;
    private JCheckBox showAdvancedOptionsCheckBox;
    private ModbusUnitPanel isEditingModbusUnitPanel = null;
    private SignalPanel isEditingModbusSignalAdressPanel = null;
    private SignalPanel isEditingModbusSignalNamePanel = null;
    private SignalPanel isEditingModbusOutputRegisterPanel = null;
    private SignalPanel isEditingModbusSlaveAddressPanel = null;
    private boolean updating = false;
    private JButton addUnitBtn;
    private JButton deleteUnitBtn;
    private JTextField ipTextField;
    private JCheckBox sequentialModeCb;
    private JButton addSignalBtn;
    private JButton deleteSignalBtn;
    private JComboBox signalTypeComboBox;
    private JTextField signalAddressTextField;
    private JTextField signalNameJTextField;
    private JPanel signalStatusPanel;
    private JLabel modbusInputStateLabel;
    private JComponent advancedOptionsPanel;
    private WidgetFactory widgetFactory;
    private JPanel modbusEthernetUnitsPanel;
    private final DialogCreator dialogCreator;

    @Inject
    ModbusSetupTab(ErrorDialogCreator errorDialogCreator, ModbusInstallation lookupService, NamingService namingService, ViewContext view, DialogCreator dialogCreator) {
        this.errorDialogCreator = errorDialogCreator;
        this.widgetFactory = view.createWidgetFactory();
        this.lookupService = lookupService;
        this.namingService = namingService;
        this.view = view;
        this.fontFactory = view.getFontFactory();
        this.helpIdAssigner = view.getHelpIdAssigner();
        this.dialogCreator = dialogCreator;
        this.inactiveIcon = ButtonImageResource.grayLed();
        this.onIcon = ButtonImageResource.greenLed();
        this.badResponseTimeIcon = ButtonImageResource.yellowLed();
        this.error1Icon = ButtonImageResource.yellowLed24E1();
        this.error2Icon = ButtonImageResource.yellowLed24E2();
        this.error3Icon = ButtonImageResource.yellowLed24E3();
        this.error4Icon = ButtonImageResource.yellowLed24E4();
        this.error5Icon = ButtonImageResource.yellowLed24E5();
        this.error6Icon = ButtonImageResource.yellowLed24E6();
        this.errorAIcon = ButtonImageResource.yellowLed24EA();
        this.errorBIcon = ButtonImageResource.yellowLed24EB();
        this.initComponents();
        this.assignHelpIds();
        nameSignalPanelMap = new HashMap();
        modbusUnitPanelMap = new HashMap();
    }

    public static boolean checkForIPFormat(JTextField field) {
        if (ValidationFactory.getIpAddressValidator().isValid(field.getText())) {
            return true;
        }
        LegacyURDialogCreator.showErrorDialog(LanguagePack.getTextResource().invalidIpAddress(), ValidationFactory.getIpAddressValidator().getErrorMessage(field.getText()), "");
        return false;
    }

    public static void addSignalToMap(SignalPanel sig) {
        nameSignalPanelMap.put(sig.modbusSignal, sig);
    }

    private static String signalStatisticsToString(TextResource lang, ModbusSignal sig) {
        StringBuilder sb = new StringBuilder();
        if (sig.getConnectionStatus() == ModbusConnection.CONNECTION_OK) {
            sb.append(String.format(String.valueOf(lang.responseTime()) + STYLE_REPONSE_TIME, sig.getActualResponseTimeInMs()));
        } else {
            sb.append(String.valueOf(lang.responseTime()) + ": ----,   ");
        }
        sb.append(String.format(String.valueOf(lang.noResponse()) + STYLE_REPONSE_TIME, sig.getRequestTimeoutsCounter()));
        sb.append(String.format(String.valueOf(lang.sendFailed()) + STYLE_REPONSE_TIME, sig.getFailedSendCounter()));
        if (sig.getAvgResponseFrequency() >= 0.0 && sig.getConnectionStatus() == ModbusConnection.CONNECTION_OK) {
            sb.append(String.format(String.valueOf(lang.avgResponseFreq()) + ": %3.1fHz", sig.getAvgResponseFrequency()));
        } else {
            sb.append("Avg. resp. f: ----");
        }
        return sb.toString();
    }

    private static String unitStatisticsToString(TextResource lang, ModbusInfoMessage.Unit unitInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(String.valueOf(lang.failedConnects()) + ": %4d, ", unitInfo.failedConnects));
        sb.append(String.format(String.valueOf(lang.invalidPackets()) + ": %4d, ", unitInfo.invalidPackets));
        sb.append(String.valueOf(lang.connectionStatus()) + ": " + ModbusSetupTab.connectionStatusToString(unitInfo.lastConnectErrorCode));
        return sb.toString();
    }

    private static String connectionStatusToString(int connectionStatus) {
        String result = null;
        TextResource lang = LanguagePack.getTextResource();
        switch (connectionStatus) {
            case 111: {
                result = lang.socketStatusConnectionRefused();
                break;
            }
            case 32: 
            case 113: {
                result = lang.socketStatusHostUnreach();
                break;
            }
            case 100: 
            case 101: {
                result = lang.socketStatusNetDown();
                break;
            }
            case 11: 
            case 114: 
            case 115: {
                result = lang.socketStatusConnecting();
                break;
            }
            case 0: 
            case 106: {
                result = lang.socketStatusConnected();
                break;
            }
            default: {
                result = Integer.toString(connectionStatus);
            }
        }
        return result;
    }

    public static void testingIgnorePopups() {
        showPopupDialog = false;
    }

    public InstallationNode getInstallationNode() {
        return this.lookupService.getModbus();
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.showAdvancedOptionsCheckBox, "gui:installation_modbus_setup_advanced_options_checkBox");
        this.addUnitBtn = new JButton();
        this.helpIdAssigner.assignHelpId((JComponent)this.addUnitBtn, MODBUS_SETUP_ADD_UNIT);
        this.deleteUnitBtn = new JButton();
        this.helpIdAssigner.assignHelpId((JComponent)this.deleteUnitBtn, "gui:installation_modbus_setup_deleteUnit");
        this.ipTextField = new JTextField();
        this.helpIdAssigner.assignHelpId((JComponent)this.ipTextField, "gui:installation_modbus_setup_setUnitIP");
        this.addSignalBtn = new JButton();
        this.helpIdAssigner.assignHelpId((JComponent)this.addSignalBtn, "gui:installation_modbus_setup_addSignal");
        this.deleteSignalBtn = new JButton();
        this.helpIdAssigner.assignHelpId((JComponent)this.deleteSignalBtn, "gui:installation_modbus_setup_deleteSignal");
        this.signalTypeComboBox = new JComboBox();
        this.helpIdAssigner.assignHelpId(this.signalTypeComboBox, "gui:installation_modbus_setup_setSignalType");
        this.signalAddressTextField = new JTextField();
        this.helpIdAssigner.assignHelpId((JComponent)this.signalAddressTextField, "gui:installation_modbus_setup_setSignalAddress");
        this.signalNameJTextField = new JTextField();
        this.helpIdAssigner.assignHelpId((JComponent)this.signalNameJTextField, "gui:installation_modbus_setup_setSignalName");
        this.signalStatusPanel = new JPanel();
        this.helpIdAssigner.assignHelpId((JComponent)this.signalStatusPanel, "gui:installation_modbus_setup_signalValue");
        this.modbusInputStateLabel = new JLabel();
        this.helpIdAssigner.assignHelpId((JComponent)this.modbusInputStateLabel, "gui:installation_modbus_setup_signalConnectivity");
        this.advancedOptionsPanel = new JPanel();
        this.helpIdAssigner.assignHelpId(this.advancedOptionsPanel, "gui:installation_modbus_setup_advanced_options_description");
    }

    public void enter(Object o) {
        super.enter(o);
        if (this.isEditingModbusUnitPanel != null) {
            if (ModbusSetupTab.checkForIPFormat((JTextField)this.isEditingModbusUnitPanel.ipTextField)) {
                this.isEditingModbusUnitPanel.modbusUnit.setIP(this.isEditingModbusUnitPanel.ipTextField.getText());
            }
            this.isEditingModbusUnitPanel = null;
            this.updateSetupTab();
        } else if (this.isEditingModbusSignalAdressPanel != null) {
            try {
                int address = Integer.parseInt(this.isEditingModbusSignalAdressPanel.signalAddressField.getText());
                this.isEditingModbusSignalAdressPanel.modbusSignal.setPin(address);
            }
            catch (Exception exception) {}
            this.isEditingModbusSignalAdressPanel.updateSignalPanel();
            this.isEditingModbusSignalAdressPanel = null;
        } else if (this.isEditingModbusSignalNamePanel != null) {
            try {
                String nameCandidate = this.isEditingModbusSignalNamePanel.signalNameJTextField.getText();
                String oldName = this.isEditingModbusSignalNamePanel.modbusSignal.getName();
                if (!oldName.equals(nameCandidate)) {
                    this.isEditingModbusSignalNamePanel.modbusSignal.setName(nameCandidate);
                }
            }
            catch (Exception exception) {}
            this.isEditingModbusSignalNamePanel.updateSignalPanel();
            this.isEditingModbusSignalNamePanel = null;
        } else if (this.isEditingModbusOutputRegisterPanel != null) {
            try {
                this.isEditingModbusOutputRegisterPanel.setTimeWhenPressed(System.currentTimeMillis());
                this.isEditingModbusOutputRegisterPanel.getModbusSignal().sendModbusOutputRegisterValue(this.isEditingModbusOutputRegisterPanel.getOutputRegisterTextFieldValue());
            }
            catch (Exception e) {
                Log.error((String)("Exception in ModbusSetupTab::enter(): " + e.toString()));
            }
            this.isEditingModbusOutputRegisterPanel.updateSignalPanel();
            this.isEditingModbusOutputRegisterPanel = null;
        } else if (this.isEditingModbusSlaveAddressPanel != null) {
            try {
                int slaveAddress = Integer.parseInt(this.isEditingModbusSlaveAddressPanel.slaveAddressField.getText());
                if (slaveAddress >= 0 && slaveAddress <= 255) {
                    this.isEditingModbusSlaveAddressPanel.modbusSignal.setSlaveAddress(slaveAddress);
                }
            }
            catch (Exception exception) {}
            this.isEditingModbusSlaveAddressPanel.updateSignalPanel();
            this.isEditingModbusSlaveAddressPanel = null;
        } else {
            this.updateSetupTab();
        }
        for (SignalPanel each : nameSignalPanelMap.values()) {
            each.addListeners();
        }
        ModbusInfoMessage.subscribe(this);
        this.showAdvancedOptionsCheckBox.setSelected(this.showAdvancedOptions);
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                ModbusSetupTab.this.updateSetupTab();
            }
        });
    }

    public Object exit() {
        ModbusInfoMessage.unsubscribe(this);
        for (SignalPanel each : nameSignalPanelMap.values()) {
            each.removeListeners();
        }
        if (this.isEditingModbusSignalAdressPanel != null) {
            this.isEditingModbusSignalAdressPanel.removeListeners();
        }
        if (this.isEditingModbusSignalNamePanel != null) {
            this.isEditingModbusSignalNamePanel.removeListeners();
        }
        if (this.isEditingModbusOutputRegisterPanel != null) {
            this.isEditingModbusOutputRegisterPanel.removeListeners();
        }
        if (this.isEditingModbusSlaveAddressPanel != null) {
            this.isEditingModbusSlaveAddressPanel.removeListeners();
        }
        return super.exit();
    }

    private void initComponents() {
        WidgetFactory factory = this.view.createWidgetFactory();
        TextResource textResource = (TextResource)this.view.getTextResource(TextResource.class);
        this.setBorder((Border)new CardBorder(HTML.unHtml((String)textResource.modubusIoSetupTitle())));
        this.setLayout(new BorderLayout());
        JScrollPane modbusScrollPanel = new JScrollPane();
        JPanel footer = new JPanel(new BorderLayout());
        this.add(modbusScrollPanel, "Center");
        this.add(footer, "South");
        footer.setBorder(new CompoundBorder(new EmptyBorder(0, 15, 15, 15), new CompoundBorder(new MatteBorder(2, 0, 0, 0, Color.LIGHT_GRAY), new EmptyBorder(15, 0, 0, 0))));
        JButton refreshPushButton = factory.createButton((Action)((Object)new RefreshUnitsAndSignals()));
        this.showAdvancedOptionsCheckBox = factory.createCheckBox(textResource.showAdvancedOptions());
        this.showAdvancedOptionsCheckBox.setName(ADVANCED_OPTIONS);
        this.showAdvancedOptionsCheckBox.addActionListener(new ShowAdvancedOptionsActionListener());
        footer.add((Component)this.showAdvancedOptionsCheckBox, "Before");
        footer.add((Component)refreshPushButton, "After");
        this.modbusEthernetUnitsPanel = new JPanel();
        this.modbusEthernetUnitsPanel.setLayout(new BorderLayout());
        modbusScrollPanel.setViewportView(this.modbusEthernetUnitsPanel);
        modbusScrollPanel.setBackground(G5LookAndFeel.DEFAULT_BACKGROUND);
        new URFingerDragScrollMouseListener((Component)this.modbusEthernetUnitsPanel);
    }

    public void updateSetupTab() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            WidgetFactory factory = this.view.createWidgetFactory();
            nameSignalPanelMap.clear();
            modbusUnitPanelMap.clear();
            this.modbusEthernetUnitsPanel.removeAll();
            JPanel modbusUnitListPanel = new JPanel();
            modbusUnitListPanel.setLayout(new BoxLayout(modbusUnitListPanel, 1));
            modbusUnitListPanel.add(this.createAddModbusUnitHeader(factory, this.errorDialogCreator));
            ModbusUnit firstElement = null;
            for (ModbusUnit mu : this.lookupService.getModbusInterface()) {
                ModbusUnitPanel mup = new ModbusUnitPanel(mu);
                if (firstElement == null) {
                    firstElement = mu;
                    HelpLoader.updatePairInHelpMap(this.deleteUnitBtn, mup.deleteModbusUnitButton, "gui:installation_modbus_setup_deleteUnit");
                    this.deleteUnitBtn = mup.deleteModbusUnitButton;
                    HelpLoader.updatePairInHelpMap(this.ipTextField, (JComponent)mup.ipTextField, "gui:installation_modbus_setup_setUnitIP");
                    this.ipTextField = mup.ipTextField;
                    HelpLoader.updatePairInHelpMap(this.sequentialModeCb, mup.sequentialModeButton, "gui:installation_modbus_setup_sequentialMode");
                    this.sequentialModeCb = mup.sequentialModeButton;
                    HelpLoader.updatePairInHelpMap(this.addSignalBtn, mup.addNewSignalButton, "gui:installation_modbus_setup_addSignal");
                    this.addSignalBtn = mup.addNewSignalButton;
                    this.updateHelpMap(mup);
                }
                modbusUnitListPanel.add(mup);
                modbusUnitPanelMap.put(mu, mup);
            }
            this.modbusEthernetUnitsPanel.add((Component)modbusUnitListPanel, "North");
            this.modbusEthernetUnitsPanel.repaint();
            this.modbusEthernetUnitsPanel.revalidate();
            this.showAdvancedOptionsCheckBox.setEnabled(!nameSignalPanelMap.isEmpty());
        }
        catch (Exception e) {
            Log.error((String)"", (Throwable)e);
        }
        this.updating = false;
    }

    private void updateHelpMap(ModbusUnitPanel mup) {
        if (!mup.getSignalPanels().isEmpty()) {
            HelpLoader.updatePairInHelpMap(this.deleteSignalBtn, mup.getSignalPanels().firstElement().removeThisSignalButton, "gui:installation_modbus_setup_deleteSignal");
            this.deleteSignalBtn = mup.getSignalPanels().firstElement().removeThisSignalButton;
            HelpLoader.updatePairInHelpMap(this.signalTypeComboBox, mup.getSignalPanels().firstElement().signalTypeComboBox, "gui:installation_modbus_setup_setSignalType");
            this.signalTypeComboBox = mup.getSignalPanels().firstElement().signalTypeComboBox;
            HelpLoader.updatePairInHelpMap(this.signalAddressTextField, (JComponent)mup.getSignalPanels().firstElement().signalAddressField, "gui:installation_modbus_setup_setSignalAddress");
            this.signalAddressTextField = mup.getSignalPanels().firstElement().signalAddressField;
            HelpLoader.updatePairInHelpMap(this.signalNameJTextField, mup.getSignalPanels().firstElement().signalNameJTextField, "gui:installation_modbus_setup_setSignalName");
            this.signalNameJTextField = mup.getSignalPanels().firstElement().signalNameJTextField;
            HelpLoader.updatePairInHelpMap(this.signalStatusPanel, mup.getSignalPanels().firstElement().signalStatusPanel, "gui:installation_modbus_setup_signalValue");
            this.signalStatusPanel = mup.getSignalPanels().firstElement().signalStatusPanel;
            HelpLoader.updatePairInHelpMap(this.modbusInputStateLabel, mup.getSignalPanels().firstElement().modbusInputStateLabel, "gui:installation_modbus_setup_signalConnectivity");
            this.modbusInputStateLabel = mup.getSignalPanels().firstElement().modbusInputStateLabel;
            if (this.showAdvancedOptions) {
                HelpLoader.updatePairInHelpMap(this.advancedOptionsPanel, mup.getSignalPanels().firstElement().advancedOptionsPanel, "gui:installation_modbus_setup_advanced_options_description");
                this.advancedOptionsPanel = mup.getSignalPanels().firstElement().advancedOptionsPanel;
            }
        }
    }

    private JPanel createAddModbusUnitHeader(WidgetFactory factory, ErrorDialogCreator errorDialogCreator) {
        JButton addOldUnit = this.addUnitBtn;
        this.addUnitBtn = factory.createButton((Action)((Object)new AddUnitAction(errorDialogCreator)));
        this.addUnitBtn.setName(ADD_MODBUS_UNIT);
        this.addUnitBtn.setPreferredSize(new Dimension(320, 45));
        HelpLoader.updatePairInHelpMap(addOldUnit, this.addUnitBtn, MODBUS_SETUP_ADD_UNIT);
        JPanel header = new JPanel(new FlowLayout(1));
        header.setBorder(new CompoundBorder(new MatteBorder(15, 15, 15, 15, G5LookAndFeel.DEFAULT_BACKGROUND), new DashLineBorder(Color.LIGHT_GRAY, 2)));
        header.setBackground(HIGHLIGHT_SECTION);
        header.add(this.addUnitBtn);
        return header;
    }

    @Override
    public void handleModbusInfoMessage(ModbusInfoMessage modbusInfoMessage) {
        TextResource lang = LanguagePack.getTextResource();
        for (ModbusUnit mu : this.lookupService.getModbusInterface()) {
            for (ModbusSignal sig : mu.getSignals()) {
                if (nameSignalPanelMap.containsKey(sig)) {
                    SignalPanel currentSignalPanel = nameSignalPanelMap.get(sig);
                    currentSignalPanel.setSignalValue(sig.getValue());
                    currentSignalPanel.signalStatisticsLabel.setText(ModbusSetupTab.signalStatisticsToString(lang, sig));
                    this.setStatusIcon(sig, currentSignalPanel);
                    continue;
                }
                Log.warning((String)("Signal panel pointer is null!! " + nameSignalPanelMap + " is missing " + sig));
            }
        }
        for (ModbusUnit mu : modbusUnitPanelMap.keySet()) {
            for (ModbusInfoMessage.Unit unitInfo : modbusInfoMessage.getUnitsInfoList()) {
                if (!unitInfo.ipAddress.equals(mu.getIP().trim())) continue;
                ModbusSetupTab.modbusUnitPanelMap.get((Object)mu).unitStatisticsLabel.setText(ModbusSetupTab.unitStatisticsToString(lang, unitInfo));
            }
        }
    }

    private void setStatusIcon(ModbusSignal sig, SignalPanel currentSignalPanel) {
        switch (sig.getConnectionStatus()) {
            case CONNECTION_OK: {
                if (sig.getUpdateFrequencyHz() == -1) {
                    currentSignalPanel.modbusInputStateLabel.setIcon(this.onIcon);
                    break;
                }
                double allowedResponseTime = 1.0 / (double)sig.getUpdateFrequencyHz();
                double actualResponseTime = (double)sig.getActualResponseTimeInMs() / 1000.0;
                if (actualResponseTime > allowedResponseTime || sig.getAvgResponseFrequency() < (double)(sig.getUpdateFrequencyHz() / 2)) {
                    currentSignalPanel.modbusInputStateLabel.setIcon(this.badResponseTimeIcon);
                    break;
                }
                currentSignalPanel.modbusInputStateLabel.setIcon(this.onIcon);
                break;
            }
            case DISCONNECTED: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.inactiveIcon);
                break;
            }
            case CONNECTING: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.inactiveIcon);
                break;
            }
            case EXCEPTION_ILLEGAL_FUNCTION_CODE: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.error1Icon);
                break;
            }
            case EXCEPTION_ILLEGAL_DATA_ACCESS: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.error2Icon);
                break;
            }
            case EXCEPTION_ILLEGAL_DATA_VALUE: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.error3Icon);
                break;
            }
            case EXCEPTION_SERVER_FAILURE: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.error4Icon);
                break;
            }
            case EXCEPTION_ACKNOWLEDGE: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.error5Icon);
                break;
            }
            case EXCEPTION_SERVER_BUSY: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.error6Icon);
                break;
            }
            case EXCEPTION_GATEWAY_PROBLEM: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.errorAIcon);
                break;
            }
            case EXCEPTION_GATEWAY_PROBLEM_TARGET_FAILURE: {
                currentSignalPanel.modbusInputStateLabel.setIcon(this.errorBIcon);
            }
        }
    }

    public class AddUnitAction
    extends AbstractActionDefinition {
        private final ErrorDialogCreator errorDialogCreator;

        AddUnitAction(ErrorDialogCreator errorDialogCreator) {
            this.errorDialogCreator = errorDialogCreator;
            this.putValue("Name", ((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).addModbusUnit());
            this.putValue("Function", ActionDefinition.Function.PRIMARY);
            this.putValue("InternalName", ModbusSetupTab.ADD_MODBUS_UNIT);
            this.putValue("HelpId", ModbusSetupTab.MODBUS_SETUP_ADD_UNIT);
        }

        public void actionPerformed(ActionEvent ae) {
            ModbusUnit unit = new ModbusUnit("0.0.0.0");
            ModbusSignal theNewSignal = new ModbusSignal(this.errorDialogCreator, unit);
            theNewSignal.setName(ModbusSignal.DEFAULT_MODBUS_SIGNAL_NAME);
            unit.addSignal(theNewSignal);
            ModbusSetupTab.this.lookupService.getModbusInterface().addUnit(unit);
            ModbusSetupTab.this.updateSetupTab();
        }
    }

    public class DigitalOutputButtonListener
    extends MouseAdapter {
        private final SignalPanel signalPanel;
        private final JLabel label;

        DigitalOutputButtonListener(SignalPanel sig, JLabel label) {
            this.signalPanel = sig;
            this.label = label;
            label.setIcon(ViewfacadeImageResource.unselectedIOEnabled());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.label.setIcon(!this.signalPanel.isDigitalOutputIsSelected() ? ViewfacadeImageResource.selectedIOEnabled() : ViewfacadeImageResource.unselectedIOEnabled());
            this.signalPanel.setTimeWhenPressed(System.currentTimeMillis());
            this.signalPanel.getModbusSignal().sendModbusOutputSignalChange(!this.signalPanel.isDigitalOutputIsSelected());
        }
    }

    public class ModbusUnitPanel
    extends JPanel {
        public JButton deleteModbusUnitButton;
        public JButton addNewSignalButton;
        public NumberField ipTextField;
        public JLabel unitStatisticsLabel;
        public JCheckBox sequentialModeButton;
        private ModbusUnit modbusUnit;
        private Vector<SignalPanel> signalPanels;

        public ModbusUnitPanel(final ModbusUnit mu) {
            super(new BorderLayout());
            this.signalPanels = new Vector();
            this.modbusUnit = mu;
            WidgetFactory factory = ModbusSetupTab.this.view.createWidgetFactory();
            this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15), BorderFactory.createLineBorder(HIGHLIGHT_SECTION, 2)));
            this.ipTextField = new NumberField();
            this.ipTextField.setMode(Mode.IP_ADDRESS);
            this.ipTextField.setUnitWidth(0);
            this.ipTextField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getIpAddressValidator()});
            this.ipTextField.setText(mu.getIP());
            this.ipTextField.setHorizontalAlignment(2);
            this.ipTextField.setEditable(true);
            this.ipTextField.setHorizontalAlignment(4);
            this.ipTextField.setPreferredSize(new Dimension(200, 32));
            this.ipTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mu.setIP(ModbusUnitPanel.this.ipTextField.getText());
                    ModbusSetupTab.this.updateSetupTab();
                }
            });
            this.addNewSignalButton = factory.createButton((Action)((Object)new SignalAddActionListener(ModbusSetupTab.this.errorDialogCreator, mu)));
            this.deleteModbusUnitButton = factory.createButton((Action)((Object)new RemoveUnitAction(mu)));
            this.sequentialModeButton = new JCheckBox((Action)((Object)new SequentialModeToggleActionListener(mu)));
            this.sequentialModeButton.setFont(ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
            this.sequentialModeButton.setSelected(mu.isSequentialModeFlag());
            this.sequentialModeButton.setOpaque(false);
            this.sequentialModeButton.setVisible(ModbusSetupTab.this.showAdvancedOptions);
            JPanel setIPPanel = new JPanel(new BorderLayout());
            JPanel setIPLeftPanel = new JPanel(new FlowLayout(0, 5, 0));
            JPanel modbusUnitSignalsList = new JPanel();
            JPanel addNewSignalPanel = new JPanel(new FlowLayout(1));
            setIPLeftPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
            setIPLeftPanel.setOpaque(false);
            modbusUnitSignalsList.setLayout(new BoxLayout(modbusUnitSignalsList, 1));
            modbusUnitSignalsList.setBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15));
            TextResource text = (TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class);
            JPanel labels = new JPanel();
            labels.setLayout(new BoxLayout(labels, 0));
            labels.add(Box.createHorizontalStrut(45));
            labels.add(this.label(text.Type(), 265));
            labels.add(this.label(text.address(), 115));
            labels.add(this.label(text.Name(), 235));
            labels.add(this.label(text.Value(), 115));
            labels.add(Box.createGlue());
            modbusUnitSignalsList.add(labels);
            for (ModbusSignal ms : mu.getSignals()) {
                SignalPanel sp = new SignalPanel(ms);
                StringBuilder stringBuilder = new StringBuilder("SignalPanel");
                ModbusSetupTab modbusSetupTab2 = ModbusSetupTab.this;
                int n = modbusSetupTab2.signalPanelCounter;
                modbusSetupTab2.signalPanelCounter = n + 1;
                sp.setName(stringBuilder.append(n).toString());
                this.signalPanels.add(sp);
                modbusUnitSignalsList.add(sp);
            }
            addNewSignalPanel.setBorder(new CompoundBorder(new MatteBorder(15, 15, 15, 15, G5LookAndFeel.DEFAULT_BACKGROUND), new DashLineBorder(Color.LIGHT_GRAY, 2)));
            addNewSignalPanel.setBackground(HIGHLIGHT_SECTION);
            addNewSignalPanel.add(this.addNewSignalButton);
            JLabel ipAddress = new JLabel(((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).ipAddress());
            ipAddress.setFont(ipAddress.getFont().deriveFont(1));
            ipAddress.setHorizontalTextPosition(2);
            ipAddress.setHorizontalAlignment(2);
            setIPLeftPanel.add(ipAddress);
            setIPLeftPanel.add((Component)this.ipTextField);
            setIPLeftPanel.add(Box.createHorizontalStrut(15));
            setIPLeftPanel.add(this.sequentialModeButton);
            this.unitStatisticsLabel = new JLabel();
            this.unitStatisticsLabel.setFont(ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
            this.unitStatisticsLabel.setHorizontalAlignment(2);
            this.unitStatisticsLabel.setVisible(ModbusSetupTab.this.showAdvancedOptions);
            this.unitStatisticsLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 8, 5));
            setIPPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            setIPPanel.setBackground(HIGHLIGHT_SECTION);
            setIPPanel.add((Component)setIPLeftPanel, "West");
            setIPPanel.add((Component)this.deleteModbusUnitButton, "East");
            setIPPanel.add((Component)this.unitStatisticsLabel, "South");
            this.add((Component)setIPPanel, "First");
            this.add((Component)modbusUnitSignalsList, "Center");
            this.add((Component)addNewSignalPanel, "South");
        }

        private void disableAllSignals() {
            for (SignalPanel sp : this.signalPanels) {
                sp.setEnabled(false);
            }
        }

        public void update() {
            if ("0.0.0.0".equals(this.modbusUnit.getIP())) {
                this.disableAllSignals();
            }
            this.deleteModbusUnitButton.setEnabled(!this.modbusUnit.getSignals().isEmpty());
        }

        public Vector<SignalPanel> getSignalPanels() {
            return this.signalPanels;
        }

        private JLabel label(String type, int i) {
            return new JLabel(type, i){
                {
                    Dimension dimension = new Dimension(n, 32);
                    this.setPreferredSize(dimension);
                    this.setMinimumSize(dimension);
                    this.setMaximumSize(dimension);
                    this.setFont(this.getFont().deriveFont(1));
                }
            };
        }
    }

    private class RefreshUnitsAndSignals
    extends AbstractActionDefinition {
        RefreshUnitsAndSignals() {
            this.putValue("Name", ((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).refreshList());
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("InternalName", ModbusSetupTab.REFRESH_LIST);
            this.putValue("HelpId", "gui:installation_modbus_setup_refresh");
        }

        public void actionPerformed(ActionEvent evt) {
            ModbusSetupTab.this.lookupService.getModbusInterface().stopModbusConnections();
            ModbusSetupTab.this.lookupService.getModbusInterface().startModbusConnections();
            ModbusSetupTab.this.updateSetupTab();
        }
    }

    public class RemoveUnitAction
    extends AbstractActionDefinition {
        ModbusUnit modbusUnit;

        public RemoveUnitAction(ModbusUnit mu) {
            this.modbusUnit = mu;
            this.putValue("Name", ((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).deleteUnit());
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("InternalName", ModbusSetupTab.REMOVE_MODBUS_UNIT);
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.modbusUnit.getSignals().size() > 0) {
                DialogReturnValue val = this.confirmRemoveUnit();
                if (val == DialogReturnValue.OK) {
                    ModbusSetupTab.this.lookupService.getModbusInterface().deleteUnit(this.modbusUnit);
                    ModbusSetupTab.this.updateSetupTab();
                }
            } else {
                ModbusSetupTab.this.lookupService.getModbusInterface().deleteUnit(this.modbusUnit);
                ModbusSetupTab.this.updateSetupTab();
            }
        }

        private ConfirmationMessage confirmDeleteModbusUnit(String ipAddress) {
            TextResource textBundle = (TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class);
            return new ConfirmationMessage(textBundle.confirmDeleteModbusUnitTitle(), textBundle.confirmDeleteModbusUnitExplanation(ipAddress), textBundle.confirmDeleteModbusUnitAction(), textBundle.Cancel());
        }

        private DialogReturnValue confirmRemoveUnit() {
            if (showPopupDialog) {
                return ModbusSetupTab.this.dialogCreator.showConfirmationDialog(this.confirmDeleteModbusUnit(this.modbusUnit.getIP()));
            }
            return DialogReturnValue.OK;
        }
    }

    public class SequentialModeToggleActionListener
    extends AbstractActionDefinition {
        ModbusUnit modbusUnit;

        public SequentialModeToggleActionListener(ModbusUnit mu) {
            this.modbusUnit = mu;
            this.putValue("Name", ((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).modbusSequentialMode());
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getID() == 1001 && e.getSource() instanceof JToggleButton) {
                this.modbusUnit.setSequentialModeFlag(((JToggleButton)e.getSource()).isSelected());
            }
        }
    }

    public class SetUpdateFrequencyActionListener
    implements ActionListener {
        SignalPanel signalPanel;

        SetUpdateFrequencyActionListener(SignalPanel sig) {
            this.signalPanel = sig;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() instanceof JComboBox) {
                try {
                    JComboBox comboBox = (JComboBox)evt.getSource();
                    Integer selectedFrequency = (Integer)comboBox.getSelectedItem();
                    int valueToSendToController = selectedFrequency;
                    if (valueToSendToController == 0) {
                        valueToSendToController = -1;
                    }
                    this.signalPanel.modbusSignal.setUpdateFrequencyHz(valueToSendToController);
                }
                catch (Exception e) {
                    Log.error((String)("Failed to set update frequency for ModbusSignal " + this.signalPanel.modbusSignal.getName()), (Throwable)e);
                }
            }
        }
    }

    private class ShowAdvancedOptionsActionListener
    implements ActionListener {
        private ShowAdvancedOptionsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() instanceof AbstractButton) {
                try {
                    AbstractButton tempButton = (AbstractButton)evt.getSource();
                    ModbusSetupTab.this.showAdvancedOptions = tempButton.isSelected();
                    ModbusSetupTab.this.updateSetupTab();
                }
                catch (Exception e) {
                    Log.error((String)"It was not an abstract button that was the source of the action event: ", (Throwable)e);
                }
            }
        }
    }

    public class SignalAddActionListener
    extends AbstractActionDefinition {
        private final ErrorDialogCreator errorDialogCreator;
        ModbusUnit modbusUnit;

        public SignalAddActionListener(ErrorDialogCreator errorDialogCreator, ModbusUnit mu) {
            this.errorDialogCreator = errorDialogCreator;
            this.modbusUnit = mu;
            this.putValue("Name", ((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).addNewSignal());
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("InternalName", ModbusSetupTab.ADD_MODBUS_SIGNAL);
        }

        public void actionPerformed(ActionEvent ae) {
            if (nameSignalPanelMap.size() >= 56) {
                LegacyURDialogCreator.showMessageDialog(((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).MaxModbusSignalCountReached());
                return;
            }
            ModbusSignal theNewSignal = new ModbusSignal(this.errorDialogCreator, this.modbusUnit);
            theNewSignal.setName(ModbusSignal.DEFAULT_MODBUS_SIGNAL_NAME);
            this.modbusUnit.addSignal(theNewSignal);
            ModbusSetupTab.this.updateSetupTab();
        }
    }

    public class SignalPanel
    extends JPanel
    implements PinObserver {
        private final TextResource text;
        private final JComboBox signalTypeComboBox;
        private final NumberField signalAddressField;
        private final JTextField signalNameJTextField;
        private final JLabel modbusInputStateLabel;
        private final JLabel toggleOutputSignal;
        private final JLabel digitalInputSignalValue;
        private final JTextField inputRegisterValue;
        private final JPanel signalStatusPanel;
        private final NumberField outputRegisterField;
        private final JButton removeThisSignalButton;
        private final JLabel signalStatisticsLabel;
        private final ModbusSignal modbusSignal;
        private NumberField slaveAddressField;
        private JComponent advancedOptionsPanel;
        private long timeWhenPressed;
        private boolean ignoreUpdatesForOutputRegister;

        public SignalPanel(ModbusSignal modbusSignalIn) {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 15, 0));
            this.modbusSignal = modbusSignalIn;
            this.text = (TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class);
            this.modbusInputStateLabel = new JLabel(ModbusSetupTab.this.inactiveIcon);
            this.signalStatusPanel = new JPanel(new FlowLayout(0, 0, 0));
            this.signalStatusPanel.setPreferredSize(new Dimension(100, 32));
            this.digitalInputSignalValue = new JLabel();
            this.digitalInputSignalValue.setPreferredSize(new Dimension(100, 32));
            this.digitalInputSignalValue.setMaximumSize(new Dimension(100, 32));
            this.digitalInputSignalValue.setMinimumSize(new Dimension(100, 32));
            this.digitalInputSignalValue.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    SignalPanel.this.modbusSignal.requestSignalUpdate();
                }
            });
            this.inputRegisterValue = new JTextField();
            this.inputRegisterValue.setPreferredSize(new Dimension(100, 32));
            this.inputRegisterValue.setMaximumSize(new Dimension(100, 32));
            this.inputRegisterValue.setMinimumSize(new Dimension(100, 32));
            this.inputRegisterValue.setHorizontalAlignment(4);
            this.inputRegisterValue.setFont(ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Size.MEDIUM));
            this.inputRegisterValue.setEditable(false);
            this.outputRegisterField = ModbusSetupTab.this.widgetFactory.createNumberField(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignalPanel.this.setAndSendOutputRegisterValue((JTextField)actionEvent.getSource());
                    SignalPanel.this.ignoreUpdatesForOutputRegister = false;
                }
            });
            this.outputRegisterField.setUnitWidth(0);
            this.outputRegisterField.setPreferredSize(new Dimension(100, 32));
            this.outputRegisterField.setMaximumSize(new Dimension(100, 32));
            this.outputRegisterField.setMinimumSize(new Dimension(100, 32));
            this.outputRegisterField.setFont(ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Size.MEDIUM));
            this.outputRegisterField.setHorizontalAlignment(4);
            this.outputRegisterField.setName(ModbusSetupTab.EDIT_MODBUS_SIGNAL_OUTPUT_REGISTER);
            this.outputRegisterField.setMode(Mode.PositiveWholeNumbers);
            String outOfBoundsOutputRegisterErrorMessage = LanguagePack.getTextResource().valueOutOfRange(0.0, "", 65535.0);
            this.outputRegisterField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)65535.0, (boolean)true, (String)outOfBoundsOutputRegisterErrorMessage)});
            this.outputRegisterField.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SignalPanel.this.ignoreUpdatesForOutputRegister = true;
                }
            });
            this.outputRegisterField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"######"));
            this.toggleOutputSignal = ModbusSetupTab.this.widgetFactory.createLabel("");
            this.toggleOutputSignal.addMouseListener(new DigitalOutputButtonListener(this, this.toggleOutputSignal));
            this.toggleOutputSignal.setPreferredSize(new Dimension(32, 32));
            this.signalTypeComboBox = new JComboBox();
            this.signalTypeComboBox.setFont(ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Size.MEDIUM));
            this.signalTypeComboBox.setPreferredSize(new Dimension(250, 32));
            this.signalTypeComboBox.setMaximumSize(new Dimension(250, 32));
            this.signalTypeComboBox.setMinimumSize(new Dimension(250, 32));
            this.signalTypeComboBox.setModel(new DefaultComboBoxModel<ModbusType>(this.hackyGetModbusTypes()));
            this.signalTypeComboBox.setRenderer(new ModbusSignalTypeRenderer());
            this.signalTypeComboBox.addActionListener(new SignalTypeActionListener(this));
            this.signalTypeComboBox.setName(ModbusSetupTab.MODBUS_SIGNAL_TYPE);
            this.signalAddressField = ModbusSetupTab.this.widgetFactory.createNumberField(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignalPanel.this.setSignalAddress((JTextField)actionEvent.getSource());
                }
            });
            this.signalAddressField.setUnitWidth(0);
            this.signalAddressField.setPreferredSize(new Dimension(100, 32));
            this.signalAddressField.setMaximumSize(new Dimension(100, 32));
            this.signalAddressField.setMinimumSize(new Dimension(100, 32));
            this.signalAddressField.setHorizontalAlignment(4);
            this.signalAddressField.setMode(Mode.PositiveWholeNumbers);
            String outOfBoundsSignalAddressErrorMessage = LanguagePack.getTextResource().valueOutOfRange(0.0, "", 65535.0);
            this.signalAddressField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)65535.0, (boolean)true, (String)outOfBoundsSignalAddressErrorMessage)});
            this.signalAddressField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"######"));
            this.signalNameJTextField = new JTextField(this.modbusSignal.getName());
            this.signalNameJTextField.setName(ModbusSetupTab.MODBUS_SIGNAL_NAME);
            this.signalNameJTextField.setPreferredSize(new Dimension(220, 32));
            this.signalNameJTextField.setMaximumSize(new Dimension(220, 32));
            this.signalNameJTextField.setMinimumSize(new Dimension(220, 32));
            TextProvider modbusNameProvider = this.createModbusSignalNameProvider();
            TextFieldUtils.bindValidator((JTextComponent)this.signalNameJTextField, (ValidationStrategy)NameValidationFactory.getVariableNameValidator(modbusNameProvider, ModbusSetupTab.this.namingService, ModbusSignal.class, this.text));
            TextFieldUtils.bindTextPicker((JComponent)this.signalNameJTextField, (TextHolder)new TextHolder(){

                public String getText() {
                    return SignalPanel.this.signalNameJTextField.getText();
                }

                public void setText(String text) {
                    SignalPanel.this.signalNameJTextField.setText(text);
                    SignalPanel.this.modbusSignal.setName(text);
                }
            }, (ValidationStrategy)NameValidationFactory.getVariableNameValidator(modbusNameProvider, ModbusSetupTab.this.namingService, ModbusSignal.class, this.text));
            this.removeThisSignalButton = new JButton((Action)((Object)new SignalRemoveActionListener(this.modbusSignal)));
            JPanel signalLeftSidePanel = new JPanel();
            signalLeftSidePanel.setLayout(new BoxLayout(signalLeftSidePanel, 0));
            signalLeftSidePanel.add(this.modbusInputStateLabel);
            signalLeftSidePanel.add(Box.createHorizontalStrut(15));
            signalLeftSidePanel.add(this.signalTypeComboBox);
            signalLeftSidePanel.add(Box.createHorizontalStrut(15));
            signalLeftSidePanel.add((Component)this.signalAddressField);
            signalLeftSidePanel.add(Box.createHorizontalStrut(15));
            signalLeftSidePanel.add(this.signalNameJTextField);
            signalLeftSidePanel.add(Box.createHorizontalStrut(15));
            signalLeftSidePanel.add(this.signalStatusPanel);
            signalLeftSidePanel.add(Box.createGlue());
            signalLeftSidePanel.add(this.removeThisSignalButton);
            this.add((Component)signalLeftSidePanel, "Center");
            this.signalStatisticsLabel = new JLabel();
            this.signalStatisticsLabel.setFont(ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
            if (ModbusSetupTab.this.showAdvancedOptions) {
                JPanel verticalContainer = new JPanel(new BorderLayout());
                verticalContainer.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                JPanel firstLineContainer = new JPanel(new FlowLayout(0));
                firstLineContainer.add(this.constructUpdateFrequencyPanel(this.modbusSignal));
                firstLineContainer.add(this.constructSetSlaveAddressPanel());
                verticalContainer.add((Component)firstLineContainer, "North");
                Box secondLineContainer = new Box(0);
                secondLineContainer.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                secondLineContainer.add(this.signalStatisticsLabel);
                secondLineContainer.add(Box.createHorizontalGlue());
                verticalContainer.add((Component)secondLineContainer, "South");
                this.add((Component)verticalContainer, "South");
                this.advancedOptionsPanel = verticalContainer;
            }
            this.updateSignalPanel();
            ModbusSetupTab.addSignalToMap(this);
        }

        private ModbusType[] hackyGetModbusTypes() {
            ModbusType[] modbusGroups = new ModbusType[]{ModbusType.UNDEFINED, ModbusType.DIGITAL_INPUT, ModbusType.DIGITAL_OUTPUT, ModbusType.REGISTER_INPUT, ModbusType.REGISTER_OUTPUT};
            return modbusGroups;
        }

        private TextProvider createModbusSignalNameProvider() {
            return new TextProvider(){

                public String getText() {
                    if (SignalPanel.this.modbusSignal == null) {
                        return "";
                    }
                    return SignalPanel.this.modbusSignal.getName();
                }
            };
        }

        private void setAndSendOutputRegisterValue(JTextField outputRegisterField) {
            int out = this.parseIntFromTextField(outputRegisterField, this.modbusSignal.getValue());
            this.modbusSignal.setValue(out);
            this.setTimeWhenPressed(System.currentTimeMillis());
            this.modbusSignal.sendModbusOutputRegisterValue(out);
        }

        private int parseIntFromTextField(JTextField textField, int defaultValue) {
            return PrimitiveUtils.parseInteger((String)textField.getText(), (int)defaultValue);
        }

        private void setSignalAddress(JTextField signalAddressField) {
            int signalAddress = this.parseIntFromTextField(signalAddressField, this.modbusSignal.getPin());
            this.modbusSignal.setPin(signalAddress);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.signalAddressField.setEnabled(enabled);
            this.signalNameJTextField.setEnabled(enabled);
            this.toggleOutputSignal.setEnabled(enabled);
            this.inputRegisterValue.setText("");
            this.inputRegisterValue.setEnabled(enabled);
            if (!this.ignoreUpdatesForOutputRegister) {
                this.outputRegisterField.setText("");
                this.outputRegisterField.setEnabled(enabled);
            }
            if (this.advancedOptionsPanel != null) {
                GuiUtilities.setContainerEnabledRecursive((Container)this.advancedOptionsPanel, (boolean)enabled);
            }
        }

        public void addListeners() {
            EventNotificationService.register((Object)this, PinObserver.class, (Object)this);
        }

        public void removeListeners() {
            EventNotificationService.unregister((Object)this, PinObserver.class);
        }

        public void setTimeWhenPressed(long time) {
            this.timeWhenPressed = time;
        }

        public ModbusSignal getModbusSignal() {
            return this.modbusSignal;
        }

        public boolean isDigitalOutputIsSelected() {
            return this.modbusSignal.getValue() == 1;
        }

        public int getOutputRegisterTextFieldValue() {
            return PrimitiveUtils.parseInteger((String)this.outputRegisterField.getText(), (int)0);
        }

        private void updateSignalPanel() {
            this.signalTypeComboBox.setSelectedIndex(this.modbusSignal.getModbusType().getId() + 1);
            switch (this.modbusSignal.getModbusType()) {
                case DIGITAL_INPUT: {
                    if (this.digitalInputSignalValue.getParent() != this.signalStatusPanel) {
                        this.signalStatusPanel.removeAll();
                        this.signalStatusPanel.add(this.digitalInputSignalValue);
                    }
                    this.setEnabled(true);
                    break;
                }
                case DIGITAL_OUTPUT: {
                    if (this.toggleOutputSignal.getParent() != this.signalStatusPanel) {
                        this.signalStatusPanel.removeAll();
                        this.signalStatusPanel.add(this.toggleOutputSignal);
                    }
                    this.setEnabled(true);
                    break;
                }
                case REGISTER_INPUT: {
                    if (this.inputRegisterValue.getParent() != this.signalStatusPanel) {
                        this.signalStatusPanel.removeAll();
                        this.signalStatusPanel.add(this.inputRegisterValue);
                    }
                    this.setEnabled(true);
                    break;
                }
                case REGISTER_OUTPUT: {
                    if (this.signalStatusPanel.getParent() != this.signalStatusPanel) {
                        this.signalStatusPanel.removeAll();
                        this.signalStatusPanel.add((Component)this.outputRegisterField);
                    }
                    this.setEnabled(true);
                    break;
                }
                case UNDEFINED: {
                    if (this.digitalInputSignalValue.getParent() != this.signalStatusPanel) {
                        this.signalStatusPanel.removeAll();
                    }
                    this.setEnabled(false);
                    break;
                }
                default: {
                    Log.error((String)("Unknown signal type: " + this.modbusSignal.getModbusType()));
                }
            }
            this.signalStatusPanel.repaint();
            this.signalStatusPanel.revalidate();
            this.signalAddressField.setText(String.valueOf(this.modbusSignal.getPin()));
            if (this.slaveAddressField != null) {
                this.slaveAddressField.setText(Integer.toString(this.modbusSignal.getSlaveAddress()));
            }
        }

        public void setSignalValue(int value) {
            if (value < 0) {
                return;
            }
            this.setEnabled(true);
            switch (this.modbusSignal.getModbusType()) {
                case DIGITAL_INPUT: {
                    if (this.modbusSignal.getUpdateFrequencyHz() <= 0) {
                        if (this.modbusSignal.getTimeSinceLastUpdateInMs() > 2000) {
                            this.digitalInputSignalValue.setText("?");
                        } else {
                            this.digitalInputSignalValue.setText("");
                        }
                    } else {
                        this.digitalInputSignalValue.setText("");
                    }
                    this.digitalInputSignalValue.setIcon(value == 0 ? ViewfacadeImageResource.unselectedIODisabled() : ViewfacadeImageResource.selectedIODisabled());
                    break;
                }
                case DIGITAL_OUTPUT: {
                    long t1 = System.currentTimeMillis();
                    if (t1 - this.timeWhenPressed <= 400L) break;
                    this.toggleOutputSignal.setIcon(value == 0 ? ViewfacadeImageResource.unselectedIOEnabled() : ViewfacadeImageResource.selectedIOEnabled());
                    break;
                }
                case REGISTER_INPUT: {
                    String valueString1 = Integer.toString(value);
                    this.inputRegisterValue.setText(valueString1);
                    break;
                }
                case REGISTER_OUTPUT: {
                    long t2 = System.currentTimeMillis();
                    if (t2 - this.timeWhenPressed <= 200L || this.ignoreUpdatesForOutputRegister) break;
                    String valueString = Integer.toString(value);
                    this.outputRegisterField.setText(valueString);
                    break;
                }
            }
        }

        private JPanel constructUpdateFrequencyPanel(ModbusSignal sig) {
            Font fontToUse = ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD);
            JPanel updateFrequenciesPanel = new JPanel(new FlowLayout(0));
            JLabel freqLabel = new JLabel(LanguagePack.getTextResource().Frequency());
            freqLabel.setFont(fontToUse);
            updateFrequenciesPanel.add(freqLabel);
            JComboBox frequenciesComboBox = new JComboBox();
            frequenciesComboBox.setPreferredSize(new Dimension(80, 32));
            frequenciesComboBox.setFont(fontToUse);
            frequenciesComboBox.addActionListener(new SetUpdateFrequencyActionListener(this));
            frequenciesComboBox.setModel(this.createUpdateFrequenciesForComboBoxModel());
            try {
                int valueToDisplayInComboBox = sig.getUpdateFrequencyHz();
                if (valueToDisplayInComboBox == -1) {
                    valueToDisplayInComboBox = 0;
                }
                frequenciesComboBox.setSelectedItem(valueToDisplayInComboBox);
            }
            catch (Exception e) {
                Log.error((String)"Could not set update frequency for modbus signal: ", (Throwable)e);
                frequenciesComboBox.setSelectedIndex(0);
            }
            updateFrequenciesPanel.add(frequenciesComboBox);
            return updateFrequenciesPanel;
        }

        public DefaultComboBoxModel createUpdateFrequenciesForComboBoxModel() {
            DefaultComboBoxModel<Integer> result = new DefaultComboBoxModel<Integer>();
            result.addElement(0);
            result.addElement(1);
            result.addElement(2);
            result.addElement(5);
            result.addElement(10);
            result.addElement(25);
            result.addElement(50);
            result.addElement(100);
            result.addElement(125);
            result.addElement(250);
            result.addElement(500);
            return result;
        }

        private JPanel constructSetSlaveAddressPanel() {
            Font fontToUse = ModbusSetupTab.this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD);
            JPanel slaveAddressPanel = new JPanel(new FlowLayout(0));
            JLabel slaveTextLabel = new JLabel(LanguagePack.getTextResource().modbusSlaveAddress());
            slaveTextLabel.setFont(fontToUse);
            slaveAddressPanel.add(slaveTextLabel);
            this.slaveAddressField = ModbusSetupTab.this.widgetFactory.createNumberField(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignalPanel.this.setSlaveAddress((JTextField)actionEvent.getSource());
                }
            });
            this.slaveAddressField.setUnitWidth(0);
            this.slaveAddressField.setFont(fontToUse);
            this.slaveAddressField.setPreferredSize(new Dimension(65, 32));
            this.slaveAddressField.setHorizontalAlignment(4);
            String outOfBoundsSlaveAddressErrorMessage = ((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).valueOutOfRange(0.0, "", 255.0);
            this.slaveAddressField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)255.0, (boolean)true, (String)outOfBoundsSlaveAddressErrorMessage)});
            this.slaveAddressField.setMode(Mode.PositiveWholeNumbers);
            this.slaveAddressField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0"));
            slaveAddressPanel.add((Component)this.slaveAddressField);
            return slaveAddressPanel;
        }

        private void setSlaveAddress(JTextField slaveAddressField) {
            int out = this.parseIntFromTextField(slaveAddressField, this.modbusSignal.getSlaveAddress());
            this.modbusSignal.setSlaveAddress(out);
        }

        public void added(Pin<?> pin) {
        }

        public void removed(Pin<?> pin) {
        }

        public void nameChanged(Pin<?> pin, String oldName, String newName) {
            if (pin == this.modbusSignal) {
                this.signalNameJTextField.setText(this.modbusSignal.getName());
            }
        }

        public void typeChanged(Pin<?> pin) {
        }

        @Override
        public String toString() {
            return "SignalPanel: " + this.modbusSignal;
        }

        private class ModbusSignalTypeRenderer
        extends DefaultComboBoxRenderer {
            private ModbusSignalTypeRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof ModbusType) {
                    this.setText(this.getTextForValue((ModbusType)value));
                } else {
                    this.setText(SignalPanel.this.text.pleaseSelect());
                }
                return this;
            }

            private String getTextForValue(ModbusType value) {
                switch (value) {
                    case UNDEFINED: {
                        return SignalPanel.this.text.pleaseSelect();
                    }
                    case DIGITAL_INPUT: {
                        return SignalPanel.this.text.digitalInput();
                    }
                    case DIGITAL_OUTPUT: {
                        return SignalPanel.this.text.digitalOutput();
                    }
                    case REGISTER_INPUT: {
                        return SignalPanel.this.text.registerInput();
                    }
                    case REGISTER_OUTPUT: {
                        return SignalPanel.this.text.registerOutput();
                    }
                }
                throw new UnknownSignalType(value);
            }
        }
    }

    public class SignalRemoveActionListener
    extends AbstractActionDefinition {
        ModbusSignal modbusSignal;

        public SignalRemoveActionListener(ModbusSignal ms) {
            this.modbusSignal = ms;
            this.putValue("Name", ((TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class)).Delete());
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                DialogReturnValue val = this.confirmRemovalOfSignal();
                if (val == DialogReturnValue.OK) {
                    ModbusSetupTab.this.lookupService.getModbusInterface().deleteSignal(this.modbusSignal);
                    ModbusSetupTab.this.updateSetupTab();
                }
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
        }

        private ConfirmationMessage confirmDeleteModbusSignal(String modbusName, String ipAddress) {
            TextResource textBundle = (TextResource)ModbusSetupTab.this.view.getTextResource(TextResource.class);
            return new ConfirmationMessage(textBundle.confirmDeleteModbusSignalTitle(), textBundle.confirmDeleteModbusSignalExplanation(modbusName, ipAddress), textBundle.confirmDeleteModbusSignalAction(), textBundle.Cancel());
        }

        private DialogReturnValue confirmRemovalOfSignal() {
            if (showPopupDialog) {
                return ModbusSetupTab.this.dialogCreator.showConfirmationDialog(this.confirmDeleteModbusSignal(this.modbusSignal.getName(), this.modbusSignal.getModbusUnit().getIP()));
            }
            return DialogReturnValue.OK;
        }
    }

    public class SignalTypeActionListener
    implements ActionListener {
        SignalPanel signalPanel;

        public SignalTypeActionListener(SignalPanel signalPanel) {
            this.signalPanel = signalPanel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JComboBox cb = (JComboBox)ae.getSource();
            int type = cb.getSelectedIndex();
            this.signalPanel.modbusSignal.setModbusType(ModbusType.byId((int)(type - 1)));
            this.signalPanel.updateSignalPanel();
        }
    }
}

