/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NameChange;
import com.ur.lang.naming.NameChangeAspect;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.PinObserver;
import com.ur.polyscope.pin.PinValueChangeObserver;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.IOServiceType;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.validation.IpAddressValidator;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.constants.modbus.ModbusConnection;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.hmc.ControllerSocketSender;
import com.ur.view.modbus.ModbusSignal$AjcClosure1;
import com.ur.view.modbus.ModbusSignal$AjcClosure3;
import com.ur.view.modbus.ModbusUnit;
import gui.tools.LanguagePack;
import java.util.EnumSet;
import java.util.HashMap;
import javax.inject.Inject;
import javax.swing.JTextField;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ModbusSignal
implements Pin<Integer>,
ModifiablePin,
InputActionPin {
    private static final String SIGNAL_CREATED = "Signal created";
    private static final String SIGNAL_LOADED = "Signal loaded";
    public static final String DEFAULT_MODBUS_SIGNAL_NAME;
    private final ErrorDialogCreator errorDialogCreator;
    private transient ModbusConnection connectionStatus = ModbusConnection.DISCONNECTED;
    private transient int signalValue = 0;
    private transient ModbusType modbusType = ModbusType.UNDEFINED;
    private transient String loadTestString;
    private transient int timeSinceLastUpdateInMs = 0;
    private ModbusUnit modbusUnit;
    private int slaveAddress = 255;
    private int signalAddress = 0;
    private int updateFrequencyHz = 10;
    protected String name = DEFAULT_MODBUS_SIGNAL_NAME;
    private int modificationChoice = 0;
    private int actualResponseTimeInMS = 0;
    private int failedSendCounter;
    private int requestTimeoutsCounter;
    private double avgResponseFrequency = -1.0;
    private OutputPinAction outputPinAction = OutputPinAction.NONE;
    private PinAction inputPinAction = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
    private final ModbusDigitalIONotificationStrategy digitalIoNotification = new ModbusDigitalIONotificationStrategy();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ModbusSignal.ajc$preClinit();
        DEFAULT_MODBUS_SIGNAL_NAME = LanguagePack.getTextResource().Modbus();
    }

    public ModbusSignal(ErrorDialogCreator errorDialogCreator, ModbusUnit modbusUnit) {
        this.errorDialogCreator = errorDialogCreator;
        this.initialize(modbusUnit);
    }

    @Inject
    public ModbusSignal(ErrorDialogCreator errorDialogCreator) {
        this.errorDialogCreator = errorDialogCreator;
    }

    ModbusSignal(ErrorDialogCreator errorDialogCreator, String name, ModbusType type, int signalAddress, int slaveAddress, int updateFrequency, String loadTest, int modificationChoice) {
        this.errorDialogCreator = errorDialogCreator;
        this.initialize(name, type, signalAddress, slaveAddress, updateFrequency, loadTest, modificationChoice);
    }

    public boolean isUnassigned() {
        return this.modbusType != ModbusType.UNDEFINED && this.getOutputAction() != OutputPinAction.PROGRAM_RUNNING && this.getOutputAction() != OutputPinAction.CONTINUOUS_PULSE && this.getOutputAction() != OutputPinAction.LOW_WHEN_PROGRAM_ABORTED_HIGH_WHEN_NOT;
    }

    public IOServiceType getValueType() {
        if (EqualsUtil.equalsOneOf((Object)this.modbusType, (Object[])new ModbusType[]{ModbusType.DIGITAL_INPUT, ModbusType.DIGITAL_OUTPUT})) {
            return IOServiceType.DIGITAL;
        }
        if (EqualsUtil.equalsOneOf((Object)this.modbusType, (Object[])new ModbusType[]{ModbusType.REGISTER_INPUT, ModbusType.REGISTER_OUTPUT})) {
            return IOServiceType.INTEGER;
        }
        return IOServiceType.UNKNOWN;
    }

    public final void initialize(ModbusUnit modbusUnit) {
        this.modbusUnit = modbusUnit;
        this.loadTestString = SIGNAL_CREATED;
    }

    public final void initialize(String name, ModbusType type, int pin, int slaveAddress, int updateFrequency, String loadTest, int modificationChoice) {
        this.name = name;
        this.modbusType = type;
        this.signalAddress = pin;
        this.slaveAddress = slaveAddress;
        this.updateFrequencyHz = updateFrequency;
        this.loadTestString = loadTest;
        this.modificationChoice = modificationChoice;
        this.notifyChangeOccurred();
    }

    public void setModificationChoice(int choice) {
        if (choice != this.modificationChoice) {
            this.modificationChoice = choice;
            this.notifyChangeOccurred();
        }
    }

    public void generatePreambleScript(ScriptWriter writer) {
    }

    public String appendSetOutputRunstateDependentChoice(int choice) {
        return null;
    }

    public int getModificationChoice() {
        return this.modificationChoice;
    }

    public String getDefaultName() {
        return this.getName();
    }

    public String getDefinedName() {
        return this.getName();
    }

    public String getUserDefinedName() {
        return this.getDefinedName();
    }

    public String getShortName() {
        return "M" + this.getPin();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean useDisplayNameOverDefaultName() {
        return false;
    }

    public boolean isInput() {
        return EqualsUtil.equalsOneOf((Object)this.modbusType, (Object[])new ModbusType[]{ModbusType.DIGITAL_INPUT, ModbusType.REGISTER_INPUT, ModbusType.UNDEFINED});
    }

    @NameChange
    public void setName(String newName) {
        String string = newName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ModbusSignal$AjcClosure1 modbusSignal$AjcClosure1 = new ModbusSignal$AjcClosure1(objectArray);
        NameChangeAspect.aspectOf().aroundAnnotatedMethod(modbusSignal$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public ModbusType getModbusType() {
        return this.modbusType;
    }

    public void setModbusType(ModbusType t) {
        if (this.modbusType == t) {
            return;
        }
        if (this.isInput() && !this.modbusTypeIsInput(t)) {
            this.inputPinAction = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
        }
        if (!this.isInput() && this.modbusTypeIsInput(t)) {
            this.outputPinAction = OutputPinAction.NONE;
        }
        this.modbusType = t;
        this.startSignalConnection();
        EventNotificationService.notify(PinObserver.class, (NotificationStrategy)new NotificationStrategy<PinObserver>(){

            public void notify(PinObserver listener) {
                listener.typeChanged((Pin)ModbusSignal.this);
            }
        });
        this.notifyChangeOccurred();
    }

    private boolean modbusTypeIsInput(ModbusType t) {
        return EqualsUtil.equalsOneOf((Object)t, (Object[])new ModbusType[]{ModbusType.REGISTER_INPUT, ModbusType.DIGITAL_INPUT});
    }

    public int getSlaveAddress() {
        return this.slaveAddress;
    }

    public void setSlaveAddress(int addr) {
        if (this.slaveAddress == addr) {
            return;
        }
        this.slaveAddress = addr;
        this.startSignalConnection();
        this.notifyChangeOccurred();
    }

    public int getPin() {
        return this.signalAddress;
    }

    public void setPin(int addr) {
        if (this.signalAddress == addr) {
            return;
        }
        this.signalAddress = addr;
        this.startSignalConnection();
        this.notifyChangeOccurred();
    }

    public ModbusConnection getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(ModbusConnection cs) {
        this.connectionStatus = cs;
    }

    public Integer getValue() {
        return this.signalValue;
    }

    public void setValue(int signalValueIn) {
        this.signalValue = signalValueIn;
        if (EnumSet.of(ModbusType.DIGITAL_INPUT, ModbusType.DIGITAL_OUTPUT).contains(this.modbusType)) {
            EventNotificationService.notify(PinValueChangeObserver.Digital.class, (NotificationStrategy)this.digitalIoNotification);
        }
    }

    public void setSignalResponseTime(int responseTime) {
        this.actualResponseTimeInMS = responseTime;
    }

    public int getActualResponseTimeInMs() {
        return this.actualResponseTimeInMS;
    }

    public ModbusUnit getModbusUnit() {
        return this.modbusUnit;
    }

    public ScriptWriter generateScriptCodeForAdding(ScriptWriter writer) {
        if (this.modbusType != ModbusType.UNDEFINED) {
            writer.appendLine("modbus_add_signal(\"" + this.modbusUnit.getIP() + "\", " + this.slaveAddress + ", " + this.signalAddress + ", " + this.modbusType.getId() + ", " + "\"" + this.name + "\", " + (this.modbusUnit.isSequentialModeFlag() ? "True" : "False") + ")");
            writer.appendLine("modbus_set_signal_update_frequency(\"" + this.name + "\", " + this.getUpdateFrequencyHz() + ")");
        }
        return writer;
    }

    public void startSignalConnection() {
        if (this.checkForIPFormat(new JTextField(this.modbusUnit.getIP())) && this.areParametersValid()) {
            StringBuffer sb = new StringBuffer();
            sb.append("modbus_add_signal(\"" + this.modbusUnit.getIP() + "\", " + this.slaveAddress + ", " + this.signalAddress + ", " + this.modbusType.getId() + ", " + "\"" + this.name + "\", " + (this.modbusUnit.isSequentialModeFlag() ? "True" : "False") + ")\n");
            sb.append(String.valueOf(this.generateInputActionScriptCode()) + "\n");
            ControllerSocketSender.sendAsSecondaryProgram(sb.toString());
            this.sendChangeUpdateFrequency();
        }
    }

    private boolean areParametersValid() {
        if (this.name == null) {
            return false;
        }
        return this.slaveAddress >= 0 && this.slaveAddress <= 255 && this.signalAddress >= 0 && this.modbusType != ModbusType.UNDEFINED && this.name.length() > 0;
    }

    private boolean checkForIPFormat(JTextField field) {
        IpAddressValidator ipAddressValidator = new IpAddressValidator();
        if (ipAddressValidator.isValid(field.getText())) {
            return true;
        }
        this.errorDialogCreator.showErrorDialog(new ErrorMessage(LanguagePack.getTextResource().invalidIpAddress(), ipAddressValidator.getErrorMessage(field.getText())), new OkDialogListener());
        return false;
    }

    public void stopSignalConnection() {
        String s = "modbus_delete_signal(\"" + this.name + "\")\n";
        ControllerSocketSender.sendAsSecondaryProgram(s);
    }

    public void sendModbusOutputSignalChange(boolean newValue) {
        String s = "modbus_set_output_signal(\"" + this.name + "\", " + (newValue ? "True" : "False") + ")\n";
        ControllerSocketSender.sendAsSecondaryProgram(s);
    }

    public void requestSignalUpdate() {
        String s = "modbus_request_update_signal_value(\"" + this.name + "\")\n";
        ControllerSocketSender.sendAsSecondaryProgram(s);
    }

    public void sendModbusOutputRegisterValue(int newRegisterValue) {
        String s = "modbus_set_output_register(\"" + this.name + "\", " + Integer.toString(newRegisterValue) + ")\n";
        ControllerSocketSender.sendAsSecondaryProgram(s);
    }

    public String generateSetterScriptCode(String newSignalValue) {
        if (this.modbusType == ModbusType.DIGITAL_OUTPUT) {
            return "modbus_set_output_signal(\"" + this.name + "\", " + newSignalValue + ")";
        }
        if (this.modbusType == ModbusType.REGISTER_OUTPUT) {
            return "modbus_set_output_register(\"" + this.name + "\", " + newSignalValue + ")";
        }
        Log.error((String)"Tried to generate set-code for signal that is not an output.");
        return "";
    }

    public String generateGetterScriptCode() {
        return "modbus_get_signal_status(\"" + this.name + "\")";
    }

    public String generateRunstateDependentChoice() {
        return "modbus_set_runstate_dependent_choice(\"" + this.name + "\"," + this.outputPinAction.getRunstateChoice() + ")\n";
    }

    public boolean isProgramStateModeSupported() {
        return true;
    }

    public void setOutputAction(OutputPinAction action) {
        OutputPinAction outputPinAction = action = action == null ? OutputPinAction.NONE : action;
        if (this.isInput() && action != OutputPinAction.NONE) {
            throw new IllegalStateException("Cannot assign output action to an input signal!");
        }
        this.outputPinAction = action;
        this.inputPinAction = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
        this.notifyChangeOccurred();
    }

    public OutputPinAction getOutputAction() {
        return this.outputPinAction;
    }

    public void setModbusUnit(ModbusUnit unit) {
        if (this.modbusUnit != unit) {
            this.modbusUnit = unit;
            this.notifyChangeOccurred();
        }
    }

    public void loadTest() {
        if (this.loadTestString == null) {
            this.modificationChoice = 0;
            this.loadTestString = SIGNAL_LOADED;
        }
    }

    public String getLoadTestString() {
        return this.loadTestString;
    }

    public void setLoadTestString(String loadTestString) {
        this.loadTestString = loadTestString;
    }

    public int getUpdateFrequencyHz() {
        if (this.updateFrequencyHz == 0) {
            this.updateFrequencyHz = 10;
        }
        return this.updateFrequencyHz;
    }

    public void setUpdateFrequencyHz(int intValue) {
        if (intValue != this.updateFrequencyHz) {
            this.updateFrequencyHz = intValue;
            this.sendChangeUpdateFrequency();
            this.notifyChangeOccurred();
        }
    }

    private void sendChangeUpdateFrequency() {
        String s = "modbus_set_signal_update_frequency(\"" + this.name + "\", " + this.updateFrequencyHz + ")\n";
        ControllerSocketSender.sendAsSecondaryProgram(s);
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        if (entityToCompareTo instanceof ModbusSignal) {
            ModbusSignal otherSignal = (ModbusSignal)entityToCompareTo;
            if (this.generateScriptCodeForAdding(new ScriptWriter()).equals((Object)otherSignal.generateScriptCodeForAdding(new ScriptWriter()))) {
                return true;
            }
        }
        return false;
    }

    public NamedEntity clone() {
        return this;
    }

    private void notifyNameChangeListeners(final String oldName, final String newName) {
        EventNotificationService.notify(PinObserver.class, (NotificationStrategy)new NotificationStrategy<PinObserver>(){

            public void notify(PinObserver listener) {
                listener.nameChanged((NamedEntity)ModbusSignal.this, oldName, newName);
            }
        });
    }

    public int getTimeSinceLastUpdateInMs() {
        return this.timeSinceLastUpdateInMs;
    }

    public void setTimeSinceLastUpdateInMs(int timeSinceLastUpdateInMs) {
        this.timeSinceLastUpdateInMs = timeSinceLastUpdateInMs;
    }

    private void notifyChangeOccurred() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
    }

    public String toString() {
        return this.getName();
    }

    public void setFailedSendCounter(int failedSendCounter) {
        this.failedSendCounter = failedSendCounter;
    }

    public int getFailedSendCounter() {
        return this.failedSendCounter;
    }

    public void setRequestTimeoutsCounter(int requestTimeoutsCounter) {
        this.requestTimeoutsCounter = requestTimeoutsCounter;
    }

    public int getRequestTimeoutsCounter() {
        return this.requestTimeoutsCounter;
    }

    public void setAvgResponseFrequency(double avgResponseFrequency) {
        this.avgResponseFrequency = avgResponseFrequency;
    }

    public double getAvgResponseFrequency() {
        return this.avgResponseFrequency;
    }

    public boolean hasBadResponseTime() {
        double allowedResponseTime = 1.0 / (double)this.getUpdateFrequencyHz();
        double actualResponseTime = (double)this.getActualResponseTimeInMs() / 1000.0;
        boolean result = this.getUpdateFrequencyHz() == -1 ? false : actualResponseTime > allowedResponseTime || this.getAvgResponseFrequency() < (double)(this.getUpdateFrequencyHz() / 2);
        return result;
    }

    public PinAction getIOPinAction() {
        return this.inputPinAction;
    }

    @InstallationChangedEvent
    public void setIOPinAction(PinAction action) {
        PinAction pinAction = action;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)pinAction);
        Object[] objectArray = new Object[]{this, pinAction, joinPoint};
        ModbusSignal$AjcClosure3 modbusSignal$AjcClosure3 = new ModbusSignal$AjcClosure3(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(modbusSignal$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public String generateInputActionScriptCode() {
        if (EqualsUtil.equals((Object)this.modbusType, (Object)ModbusType.DIGITAL_INPUT)) {
            boolean isFreeDrive = this.getIOPinAction() instanceof DefaultInputPinAction && ((DefaultInputPinAction)this.getIOPinAction()).getInputPinAction() == InputPinAction.FREEDRIVE;
            return "modbus_set_digital_input_action(\"" + this.name + "\", " + (isFreeDrive ? "\"freedrive\"" : "\"default\"") + ")";
        }
        return "";
    }

    static final /* synthetic */ void setName_aroundBody0(ModbusSignal ajc$this, String newName, JoinPoint joinPoint) {
        if (newName.equals(ajc$this.name) || newName.length() == 0) {
            return;
        }
        ajc$this.stopSignalConnection();
        String oldName = ajc$this.name;
        ajc$this.name = newName;
        ajc$this.startSignalConnection();
        ajc$this.notifyNameChangeListeners(oldName, newName);
        ajc$this.notifyChangeOccurred();
    }

    static final /* synthetic */ void setIOPinAction_aroundBody2(ModbusSignal ajc$this, PinAction action, JoinPoint joinPoint) {
        PinAction pinAction = action = action == null ? DefaultInputPinAction.INPUT_PIN_ACTION_NONE : action;
        if (!ajc$this.isInput() && action != DefaultInputPinAction.INPUT_PIN_ACTION_NONE) {
            throw new IllegalStateException("Cannot assign input action to an output signal");
        }
        ajc$this.inputPinAction = action;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ModbusSignal.java", ModbusSignal.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setName", "com.ur.view.modbus.ModbusSignal", "java.lang.String", "newName", "", "void"), 191);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIOPinAction", "com.ur.view.modbus.ModbusSignal", "com.ur.polyscope.pin.PinAction", "action", "", "void"), 571);
    }

    private class ModbusDigitalIONotificationStrategy
    implements NotificationStrategy<PinValueChangeObserver.Digital> {
        private ModbusDigitalIONotificationStrategy() {
        }

        public void notify(PinValueChangeObserver.Digital listener) {
            HashMap<ModbusSignal, PinValueChangeObserver.Digital.Value> signalValueMap = new HashMap<ModbusSignal, PinValueChangeObserver.Digital.Value>();
            signalValueMap.put(ModbusSignal.this, PinValueChangeObserver.Digital.Value.fromInt((int)ModbusSignal.this.signalValue));
            listener.digitalInputChanged(signalValueMap);
        }
    }
}

