/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.ModbusSignal;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class ModbusSignalConversionStrategy
extends ConversionStrategyTemplate<ModbusSignal>
implements InstallationComponentConversionStrategy<ModbusSignal> {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String SLAVE_ADDRESS = "slaveAddress";
    private static final String UPDATE_FREQUENCY = "updateFrequency";
    private static final String SIGNAL_ADDRESS = "signalAddress";
    private static final String LOAD_TEST_STRING = "loadTestString";
    private static final String MODIFICATION_CHOICE = "modificationChoice";
    private static final String PRESERVE_STATE_AT_PROGRAM_STOP = "preserveStateAtProgramStop";
    private static final String SET_LOW_AT_PROGRAM_STOP = "setLowAtProgramStop";
    private static final String OUTPUT_ACTION = "outputAction";
    private static final String INPUT_ACTION = "inputAction";
    private static final String PROGRAM_STATE_MODE = "programStateMode";
    private final ErrorDialogCreator errorDialogCreator;
    private final InputPinActionLookupService inputPinActionLookupService;

    @Inject
    public ModbusSignalConversionStrategy(ErrorDialogCreator errorDialogCreator, InputPinActionLookupService inputPinActionLookupService) {
        super(ModbusSignal.class);
        this.errorDialogCreator = errorDialogCreator;
        this.inputPinActionLookupService = inputPinActionLookupService;
    }

    public void marshal(ModbusSignal toPersist, PersistWriter writer) {
        writer.addAttribute(NAME, toPersist.getDefinedName());
        writer.addAttribute(TYPE, (Enum)toPersist.getModbusType());
        writer.addAttribute(SLAVE_ADDRESS, toPersist.getSlaveAddress());
        writer.addAttribute(UPDATE_FREQUENCY, toPersist.getUpdateFrequencyHz());
        writer.addAttribute(SIGNAL_ADDRESS, toPersist.getPin());
        writer.addAttribute(LOAD_TEST_STRING, toPersist.getLoadTestString());
        writer.addAttribute(MODIFICATION_CHOICE, toPersist.getModificationChoice());
        OutputPinAction outputAction = toPersist.getOutputAction();
        writer.addAttribute(OUTPUT_ACTION, outputAction.name());
        PinAction action = toPersist.getIOPinAction();
        if (!(action instanceof DefaultInputPinAction)) {
            action = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
        }
        writer.addAttribute(INPUT_ACTION, (Enum)((DefaultInputPinAction)action).getInputPinAction());
    }

    public ModbusSignal unmarshal(PersistReader reader) {
        if (reader.isNode("gui.installation.ModbusSignal")) {
            return this.pre_3_0(reader);
        }
        return this.is_3_0(reader);
    }

    public Map<String, Class<? extends ModbusSignal>> getClassAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends ModbusSignal>> result = new HashMap<String, Class<? extends ModbusSignal>>();
        result.put("ModbusSignal", ModbusSignal.class);
        return result;
    }

    private ModbusSignal pre_3_0(PersistReader reader) {
        String name = "";
        ModbusType type = ModbusType.UNDEFINED;
        int signalAddress = -1;
        int slaveAddress = -1;
        int updateFrequency = 0;
        String loadTest = null;
        int modificationChoice = 0;
        boolean preserveStateAtProgramStop = false;
        boolean ifNotPreserveThenSetLowAtProgramStop = false;
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode(NAME)) {
                name = reader.getStringValue();
            } else if (reader.isNode(TYPE)) {
                type = ModbusType.byId((int)reader.getIntegerValue());
            } else if (reader.isNode(SIGNAL_ADDRESS)) {
                signalAddress = reader.getIntegerValue();
            } else if (reader.isNode(SLAVE_ADDRESS)) {
                slaveAddress = reader.getIntegerValue();
            } else if (reader.isNode(UPDATE_FREQUENCY)) {
                updateFrequency = reader.getIntegerValue();
            } else if (reader.isNode(LOAD_TEST_STRING)) {
                loadTest = reader.getStringValue();
            } else if (reader.isNode(MODIFICATION_CHOICE)) {
                modificationChoice = reader.getIntegerValue();
            } else if (reader.isNode(PRESERVE_STATE_AT_PROGRAM_STOP)) {
                preserveStateAtProgramStop = reader.getBooleanValue();
            } else if (reader.isNode("ifNotPreserveThenSetLowAtProgramStop")) {
                ifNotPreserveThenSetLowAtProgramStop = reader.getBooleanValue();
            }
            reader.moveToParentNode();
        }
        ModbusSignal result = new ModbusSignal(this.errorDialogCreator, name, type, signalAddress, slaveAddress, updateFrequency, loadTest, modificationChoice);
        result.setOutputAction(OutputPinAction.byValues((boolean)false, (boolean)preserveStateAtProgramStop, (boolean)ifNotPreserveThenSetLowAtProgramStop));
        return result;
    }

    private ModbusSignal is_3_0(PersistReader reader) {
        reader.moveToChildNode();
        try {
            String name = reader.getStringAttribute(NAME);
            ModbusType type = (ModbusType)reader.getEnumAttribute(TYPE, ModbusType.class);
            int signalAddress = reader.getIntegerAttribute(SIGNAL_ADDRESS);
            int slaveAddress = reader.getIntegerAttribute(SLAVE_ADDRESS);
            int updateFrequency = reader.getIntegerAttribute(UPDATE_FREQUENCY);
            String loadTest = reader.getStringAttribute(LOAD_TEST_STRING);
            int modificationChoice = reader.getIntegerAttribute(MODIFICATION_CHOICE);
            boolean preserveStateAtProgramStop = true;
            if (reader.hasOneOfAttributes(new String[]{PRESERVE_STATE_AT_PROGRAM_STOP})) {
                preserveStateAtProgramStop = reader.getBooleanAttribute(PRESERVE_STATE_AT_PROGRAM_STOP);
            }
            boolean ifNotPreserveThenSetLowAtProgramStop = false;
            if (reader.hasOneOfAttributes(new String[]{SET_LOW_AT_PROGRAM_STOP})) {
                ifNotPreserveThenSetLowAtProgramStop = reader.getBooleanAttribute(SET_LOW_AT_PROGRAM_STOP);
            }
            boolean programStateMode = false;
            if (reader.hasOneOfAttributes(new String[]{PROGRAM_STATE_MODE})) {
                programStateMode = reader.getBooleanAttribute(PROGRAM_STATE_MODE);
            }
            OutputPinAction outputPinAction = reader.hasOneOfAttributes(new String[]{OUTPUT_ACTION}) ? (OutputPinAction)reader.getEnumAttribute(OUTPUT_ACTION, OutputPinAction.class) : OutputPinAction.byValues((boolean)programStateMode, (boolean)preserveStateAtProgramStop, (boolean)ifNotPreserveThenSetLowAtProgramStop);
            InputPinAction pinAction = (InputPinAction)reader.getEnumAttribute(INPUT_ACTION, InputPinAction.class);
            ModbusSignal result = new ModbusSignal(this.errorDialogCreator, name, type, signalAddress, slaveAddress, updateFrequency, loadTest, modificationChoice);
            if (result.isInput()) {
                result.setIOPinAction(pinAction != null ? this.inputPinActionLookupService.getPinAction(pinAction) : null);
            } else {
                result.setOutputAction(outputPinAction);
            }
            ModbusSignal modbusSignal = result;
            return modbusSignal;
        }
        finally {
            reader.moveToParentNode();
        }
    }
}

